/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.dynamics.Body;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Force {
    protected Vector2 force;

    public Force() {
        this.force = new Vector2();
    }

    public Force(double d, double d2) {
        this.force = new Vector2(d, d2);
    }

    public Force(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.nullVector"));
        }
        this.force = vector2;
    }

    public Force(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.nullForce"));
        }
        this.force = force.force.copy();
    }

    public void set(double d, double d2) {
        this.force.set(d, d2);
    }

    public void set(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.setNullVector"));
        }
        this.force.set(vector2);
    }

    public void set(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.force.setNullForce"));
        }
        this.force.set(force.force);
    }

    public void apply(Body body) {
        body.force.add(this.force);
    }

    public boolean isComplete(double d) {
        return true;
    }

    public String toString() {
        return this.force.toString();
    }

    public Vector2 getForce() {
        return this.force;
    }
}

