/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldPoint;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.CoefficientMixer;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraintId;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Vector2;

public class ContactConstraint
extends Constraint {
    protected ContactConstraintId id;
    protected BodyFixture fixture1;
    protected BodyFixture fixture2;
    protected List<Contact> contacts;
    protected Vector2 normal;
    protected Vector2 tangent;
    protected double friction;
    protected double restitution;
    protected boolean sensor;
    protected double tangentSpeed;
    protected Matrix22 K;
    protected Matrix22 invK;

    public ContactConstraint(Body body, BodyFixture bodyFixture, Body body2, BodyFixture bodyFixture2, Manifold manifold, World world) {
        super(body, body2);
        this.fixture1 = bodyFixture;
        this.fixture2 = bodyFixture2;
        this.id = new ContactConstraintId(body, bodyFixture, body2, bodyFixture2);
        List<ManifoldPoint> list = manifold.getPoints();
        int n = list.size();
        this.contacts = new ArrayList<Contact>(n);
        for (int i = 0; i < n; ++i) {
            ManifoldPoint manifoldPoint = list.get(i);
            Contact contact = new Contact(manifoldPoint.getId(), manifoldPoint.getPoint(), manifoldPoint.getDepth(), this.body1.getLocalPoint(manifoldPoint.getPoint()), this.body2.getLocalPoint(manifoldPoint.getPoint()));
            this.contacts.add(contact);
        }
        this.normal = manifold.getNormal();
        this.tangent = this.normal.cross(1.0);
        this.world = world;
        CoefficientMixer coefficientMixer = world.getCoefficientMixer();
        this.friction = coefficientMixer.mixFriction(bodyFixture.getFriction(), bodyFixture2.getFriction());
        this.restitution = coefficientMixer.mixRestitution(bodyFixture.getRestitution(), bodyFixture2.getRestitution());
        this.sensor = bodyFixture.isSensor() || bodyFixture2.isSensor();
        this.tangentSpeed = 0.0;
        this.onIsland = false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ContactConstraint[").append(super.toString()).append("|Fixture1=").append(this.fixture1).append("|Fixture2=").append(this.fixture2).append("|Normal=").append(this.normal).append("|Tangent=").append(this.tangent).append("|Friction=").append(this.friction).append("|Restitution=").append(this.restitution).append("|IsSensor=").append(this.sensor).append("|TangentSpeed=").append(this.tangentSpeed).append("|Contacts={");
        int n = this.contacts.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.contacts.get(i));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
        int n = this.contacts.size();
        for (int i = 0; i < n; ++i) {
            Contact contact = this.contacts.get(i);
            contact.p.add(vector2);
        }
    }

    public ContactConstraintId getId() {
        return this.id;
    }

    public Vector2 getNormal() {
        return this.normal;
    }

    public Vector2 getTangent() {
        return this.tangent;
    }

    public List<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public Body getBody1() {
        return this.body1;
    }

    public BodyFixture getFixture1() {
        return this.fixture1;
    }

    @Override
    public Body getBody2() {
        return this.body2;
    }

    public BodyFixture getFixture2() {
        return this.fixture2;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        this.friction = d;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setRestitution(double d) {
        this.restitution = d;
    }

    public boolean isSensor() {
        return this.sensor;
    }

    public void setSensor(boolean bl) {
        this.sensor = bl;
    }

    public double getTangentSpeed() {
        return this.tangentSpeed;
    }

    public void setTangentSpeed(double d) {
        this.tangentSpeed = d;
    }
}

