/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class DistanceJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double frequency;
    protected double dampingRatio;
    protected double distance;
    protected double invK;
    protected Vector2 n;
    protected double bias;
    protected double gamma;
    protected double impulse;

    public DistanceJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor1"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor2"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector22);
        this.distance = vector2.distance(vector22);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DistanceJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor1=").append(this.getAnchor1()).append("|WorldAnchor2=").append(this.getAnchor2()).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("|Distance=").append(this.distance).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = vector2.sum(this.body1.getWorldCenter()).subtract(vector22.sum(this.body2.getWorldCenter()));
        double d6 = this.n.getMagnitude();
        if (d6 < d) {
            this.n.zero();
        } else {
            this.n.multiply(1.0 / d6);
        }
        double d7 = vector2.cross(this.n);
        double d8 = vector22.cross(this.n);
        double d9 = d2 + d4 * d7 * d7;
        double d10 = this.invK = d9 <= Epsilon.E ? 0.0 : 1.0 / (d9 += d3 + d5 * d8 * d8);
        if (this.frequency > 0.0) {
            double d11 = step.getDeltaTime();
            double d12 = d6 - this.distance;
            double d13 = Math.PI * 2 * this.frequency;
            double d14 = 2.0 * this.invK * this.dampingRatio * d13;
            double d15 = this.invK * d13 * d13;
            this.gamma = d11 * (d14 + d11 * d15);
            this.gamma = this.gamma <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
            this.bias = d12 * d11 * d15 * this.gamma;
            this.invK = d9 <= Epsilon.E ? 0.0 : 1.0 / (d9 += this.gamma);
        } else {
            this.gamma = 0.0;
            this.bias = 0.0;
        }
        this.impulse *= step.getDeltaTimeRatio();
        Vector2 vector23 = this.n.product(this.impulse);
        this.body1.getLinearVelocity().add(vector23.product(d2));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d4 * vector2.cross(vector23));
        this.body2.getLinearVelocity().subtract(vector23.product(d3));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d5 * vector22.cross(vector23));
    }

    @Override
    public void solveVelocityConstraints() {
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
        Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
        double d5 = this.n.dot(vector23.difference(vector24));
        double d6 = -this.invK * (d5 + this.bias + this.gamma * this.impulse);
        this.impulse += d6;
        Vector2 vector25 = this.n.product(d6);
        this.body1.getLinearVelocity().add(vector25.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector25));
        this.body2.getLinearVelocity().subtract(vector25.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * vector22.cross(vector25));
    }

    @Override
    public boolean solvePositionConstraints() {
        if (this.frequency > 0.0) {
            return true;
        }
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        double d2 = settings.getMaximumLinearCorrection();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        Vector2 vector2 = this.body1.getWorldCenter();
        Vector2 vector22 = this.body2.getWorldCenter();
        Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.n = vector23.sum(this.body1.getWorldCenter()).subtract(vector24.sum(this.body2.getWorldCenter()));
        double d7 = this.n.normalize();
        double d8 = d7 - this.distance;
        d8 = Interval.clamp(d8, -d2, d2);
        double d9 = -this.invK * d8;
        Vector2 vector25 = this.n.product(d9);
        this.body1.translate(vector25.product(d3));
        this.body1.rotate(d5 * vector23.cross(vector25), vector2);
        this.body2.translate(vector25.product(-d4));
        this.body2.rotate(-d6 * vector24.cross(vector25), vector22);
        return Math.abs(d8) < d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.n.product(this.impulse * d);
    }

    @Override
    public double getReactionTorque(double d) {
        return 0.0;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.distance.invalidDistance"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.distance = d;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.dampingRatio = d;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.frequency = d;
    }
}

