/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class PrismaticJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorForce;
    protected boolean limitEnabled;
    protected double upperLimit;
    protected double lowerLimit;
    protected double referenceAngle;
    protected Matrix33 K;
    protected double motorMass;
    protected Joint.LimitState limitState;
    protected Vector3 impulse;
    protected double motorImpulse;
    protected Vector2 xAxis;
    protected Vector2 yAxis;
    protected Vector2 perp;
    protected Vector2 axis;
    protected double s1;
    protected double s2;
    protected double a1;
    protected double a2;

    public PrismaticJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAxis"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        Vector2 vector23 = vector22.getNormalized();
        this.xAxis = body2.getLocalVector(vector23);
        this.yAxis = this.xAxis.cross(1.0);
        this.referenceAngle = body.getTransform().getRotation() - body2.getTransform().getRotation();
        this.K = new Matrix33();
        this.impulse = new Vector3();
        this.limitEnabled = false;
        this.motorEnabled = false;
        this.limitState = Joint.LimitState.INACTIVE;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrismaticJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|XAxis=").append(this.xAxis).append("|YAxis=").append(this.yAxis).append("|Axis=").append(this.getAxis()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorForce=").append(this.maximumMotorForce).append("|ReferenceAngle=").append(this.referenceAngle).append("|IsLimitEnabled=").append(this.limitEnabled).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getWorldCenter().sum(vector2).subtract(this.body2.getWorldCenter().sum(vector22));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        this.s1 = vector2.cross(this.perp);
        this.s2 = vector22.sum(vector23).cross(this.perp);
        this.a1 = vector2.cross(this.axis);
        this.a2 = vector22.sum(vector23).cross(this.axis);
        this.K.m00 = d2 + d3 + this.s1 * this.s1 * d4 + this.s2 * this.s2 * d5;
        this.K.m01 = this.s1 * d4 + this.s2 * d5;
        this.K.m02 = this.s1 * this.a1 * d4 + this.s2 * this.a2 * d5;
        this.K.m10 = this.K.m01;
        this.K.m11 = d4 + d5;
        if (this.K.m11 <= Epsilon.E) {
            this.K.m11 = 1.0;
        }
        this.K.m12 = this.a1 * d4 + this.a2 * d5;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.motorMass = this.K.m22 = d2 + d3 + this.a1 * this.a1 * d4 + this.a2 * this.a2 * d5;
        if (Math.abs(this.motorMass) > Epsilon.E) {
            this.motorMass = 1.0 / this.motorMass;
        }
        if (!this.motorEnabled) {
            this.motorImpulse = 0.0;
        }
        if (this.limitEnabled) {
            double d6 = this.axis.dot(vector23);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d) {
                this.limitState = Joint.LimitState.EQUAL;
            } else if (d6 <= this.lowerLimit) {
                if (this.limitState != Joint.LimitState.AT_LOWER) {
                    this.limitState = Joint.LimitState.AT_LOWER;
                    this.impulse.z = 0.0;
                }
            } else if (d6 >= this.upperLimit) {
                if (this.limitState != Joint.LimitState.AT_UPPER) {
                    this.limitState = Joint.LimitState.AT_UPPER;
                    this.impulse.z = 0.0;
                }
            } else {
                this.limitState = Joint.LimitState.INACTIVE;
                this.impulse.z = 0.0;
            }
        } else {
            this.limitState = Joint.LimitState.INACTIVE;
            this.impulse.z = 0.0;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 vector24 = new Vector2();
        vector24.x = this.perp.x * this.impulse.x + (this.motorImpulse + this.impulse.z) * this.axis.x;
        vector24.y = this.perp.y * this.impulse.x + (this.motorImpulse + this.impulse.z) * this.axis.y;
        double d7 = this.impulse.x * this.s1 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a1;
        double d8 = this.impulse.x * this.s2 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a2;
        this.body1.getLinearVelocity().add(vector24.product(d2));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d4 * d7);
        this.body2.getLinearVelocity().subtract(vector24.product(d3));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d5 * d8);
    }

    @Override
    public void solveVelocityConstraints() {
        double d;
        double d2;
        Vector2 vector2;
        Step step = this.world.getStep();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        Vector2 vector22 = this.body1.getLinearVelocity();
        Vector2 vector23 = this.body2.getLinearVelocity();
        double d7 = this.body1.getAngularVelocity();
        double d8 = this.body2.getAngularVelocity();
        if (this.motorEnabled && this.limitState != Joint.LimitState.EQUAL) {
            double d9 = this.axis.dot(vector22.difference(vector23)) + this.a1 * d7 - this.a2 * d8;
            double d10 = this.motorMass * (this.motorSpeed - d9);
            double d11 = this.motorImpulse;
            double d12 = this.maximumMotorForce * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + d10, -d12, d12);
            d10 = this.motorImpulse - d11;
            vector2 = this.axis.product(d10);
            d2 = d10 * this.a1;
            d = d10 * this.a2;
            vector22.add(vector2.product(d3));
            d7 += d2 * d5;
            vector23.subtract(vector2.product(d4));
            d8 -= d * d6;
        }
        Vector2 vector24 = new Vector2();
        vector24.x = this.perp.dot(vector22.difference(vector23)) + this.s1 * d7 - this.s2 * d8;
        vector24.y = d7 - d8;
        if (this.limitEnabled && this.limitState != Joint.LimitState.INACTIVE) {
            double d13 = this.axis.dot(vector22.difference(vector23)) + this.a1 * d7 - this.a2 * d8;
            Vector3 vector3 = new Vector3(vector24.x, vector24.y, d13);
            Vector3 vector32 = this.K.solve33(vector3.negate());
            Vector3 vector33 = this.impulse.copy();
            this.impulse.add(vector32);
            if (this.limitState == Joint.LimitState.AT_LOWER) {
                this.impulse.z = Math.max(this.impulse.z, 0.0);
            } else if (this.limitState == Joint.LimitState.AT_UPPER) {
                this.impulse.z = Math.min(this.impulse.z, 0.0);
            }
            Vector2 vector25 = vector24.negate().difference(new Vector2(this.K.m02, this.K.m12).multiply(this.impulse.z - vector33.z));
            Vector2 vector26 = this.K.solve22(vector25).add(vector33.x, vector33.y);
            this.impulse.x = vector26.x;
            this.impulse.y = vector26.y;
            vector32 = this.impulse.difference(vector33);
            vector2 = new Vector2();
            vector2.x = this.perp.x * vector32.x + vector32.z * this.axis.x;
            vector2.y = this.perp.y * vector32.x + vector32.z * this.axis.y;
            d2 = vector32.x * this.s1 + vector32.y + vector32.z * this.a1;
            d = vector32.x * this.s2 + vector32.y + vector32.z * this.a2;
            vector22.add(vector2.product(d3));
            d7 += d2 * d5;
            vector23.subtract(vector2.product(d4));
            d8 -= d * d6;
        } else {
            Vector2 vector27 = this.K.solve22(vector24.negate());
            this.impulse.x += vector27.x;
            this.impulse.y += vector27.y;
            Vector2 vector28 = this.perp.product(vector27.x);
            double d14 = vector27.x * this.s1 + vector27.y;
            double d15 = vector27.x * this.s2 + vector27.y;
            vector22.add(vector28.product(d3));
            d7 += d14 * d5;
            vector23.subtract(vector28.product(d4));
            d8 -= d15 * d6;
        }
        this.body1.setAngularVelocity(d7);
        this.body2.setAngularVelocity(d8);
    }

    @Override
    public boolean solvePositionConstraints() {
        Vector3 vector3;
        Object object;
        Settings settings = this.world.getSettings();
        double d = settings.getMaximumLinearCorrection();
        double d2 = settings.getLinearTolerance();
        double d3 = settings.getAngularTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d4 = mass.getInverseMass();
        double d5 = mass2.getInverseMass();
        double d6 = mass.getInverseInertia();
        double d7 = mass2.getInverseInertia();
        Vector2 vector2 = this.body1.getWorldCenter();
        Vector2 vector22 = this.body2.getWorldCenter();
        Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector25 = vector2.sum(vector23).subtract(vector22.sum(vector24));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        Vector2 vector26 = new Vector2();
        vector26.x = this.perp.dot(vector25);
        vector26.y = transform.getRotation() - transform2.getRotation() - this.referenceAngle;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        boolean bl = false;
        if (this.limitEnabled) {
            this.a1 = vector23.cross(this.axis);
            this.a2 = vector24.sum(vector25).cross(this.axis);
            double d11 = this.axis.dot(vector25);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d2) {
                d8 = Interval.clamp(d11, -d, d);
                d9 = Math.abs(d11);
                bl = true;
            } else if (d11 <= this.lowerLimit) {
                d8 = Interval.clamp(d11 - this.lowerLimit + d2, -d, 0.0);
                d9 = this.lowerLimit - d11;
                bl = true;
            } else if (d11 >= this.upperLimit) {
                d8 = Interval.clamp(d11 - this.upperLimit - d2, 0.0, d);
                d9 = d11 - this.upperLimit;
                bl = true;
            }
        }
        this.s1 = vector23.cross(this.perp);
        this.s2 = vector24.sum(vector25).cross(this.perp);
        d9 = Math.max(d9, Math.abs(vector26.x));
        d10 = Math.abs(vector26.y);
        if (bl) {
            this.K.m00 = d4 + d5 + this.s1 * this.s1 * d6 + this.s2 * this.s2 * d7;
            this.K.m01 = this.s1 * d6 + this.s2 * d7;
            this.K.m02 = this.s1 * this.a1 * d6 + this.s2 * this.a2 * d7;
            this.K.m10 = this.K.m01;
            this.K.m11 = d6 + d7;
            if (this.K.m11 <= Epsilon.E) {
                this.K.m11 = 1.0;
            }
            this.K.m12 = this.a1 * d6 + this.a2 * d7;
            this.K.m20 = this.K.m02;
            this.K.m21 = this.K.m12;
            this.K.m22 = d4 + d5 + this.a1 * this.a1 * d6 + this.a2 * this.a2 * d7;
            object = new Vector3(vector26.x, vector26.y, d8);
            vector3 = this.K.solve33(((Vector3)object).negate());
        } else {
            this.K.m00 = d4 + d5 + this.s1 * this.s1 * d6 + this.s2 * this.s2 * d7;
            this.K.m01 = this.s1 * d6 + this.s2 * d7;
            this.K.m02 = 0.0;
            this.K.m10 = this.K.m01;
            this.K.m11 = d6 + d7;
            if (this.K.m11 <= Epsilon.E) {
                this.K.m11 = 1.0;
            }
            this.K.m12 = 0.0;
            this.K.m20 = 0.0;
            this.K.m21 = 0.0;
            this.K.m22 = 0.0;
            object = this.K.solve22(vector26.negate());
            vector3 = new Vector3(((Vector2)object).x, ((Vector2)object).y, 0.0);
        }
        object = new Vector2();
        ((Vector2)object).x = this.perp.x * vector3.x + vector3.z * this.axis.x;
        ((Vector2)object).y = this.perp.y * vector3.x + vector3.z * this.axis.y;
        double d12 = vector3.x * this.s1 + vector3.y + vector3.z * this.a1;
        double d13 = vector3.x * this.s2 + vector3.y + vector3.z * this.a2;
        this.body1.translate(((Vector2)object).product(d4));
        this.body1.rotateAboutCenter(d12 * d6);
        this.body2.translate(((Vector2)object).product(-d5));
        this.body2.rotateAboutCenter(-d13 * d7);
        return d9 <= d2 && d10 <= d3;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        Vector2 vector2 = new Vector2();
        vector2.x = this.impulse.x * this.perp.x + (this.motorImpulse + this.impulse.z) * this.axis.x;
        vector2.y = this.impulse.x * this.perp.y + (this.motorImpulse + this.impulse.z) * this.axis.y;
        vector2.multiply(d);
        return vector2;
    }

    @Override
    public double getReactionTorque(double d) {
        return d * this.impulse.y;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getJointSpeed() {
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Vector2 vector2 = this.body1.getWorldCenter();
        Vector2 vector22 = this.body2.getWorldCenter();
        Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector25 = vector2.sum(vector23).subtract(vector22.sum(vector24));
        Vector2 vector26 = this.body2.getWorldVector(this.xAxis);
        Vector2 vector27 = this.body1.getLinearVelocity();
        Vector2 vector28 = this.body2.getLinearVelocity();
        double d = this.body1.getAngularVelocity();
        double d2 = this.body2.getAngularVelocity();
        double d3 = vector25.dot(vector26.cross(d2)) + vector26.dot(vector27.sum(vector23.cross(d)).subtract(vector28.sum(vector24.cross(d2))));
        return d3;
    }

    public double getJointTranslation() {
        Vector2 vector2 = this.body1.getWorldPoint(this.localAnchor1);
        Vector2 vector22 = this.body2.getWorldPoint(this.localAnchor2);
        Vector2 vector23 = vector22.difference(vector2);
        Vector2 vector24 = this.body2.getWorldVector(this.xAxis);
        return vector23.dot(vector24);
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = bl;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double d) {
        if (this.motorEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.motorSpeed = d;
    }

    public double getMaximumMotorForce() {
        return this.maximumMotorForce;
    }

    public void setMaximumMotorForce(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorForce"));
        }
        this.maximumMotorForce = d;
    }

    public double getMotorForce(double d) {
        return this.motorImpulse * d;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.limitEnabled = bl;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double d) {
        if (d > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.limitEnabled && d != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.lowerLimit = d;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double d) {
        if (d < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.limitEnabled && d != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.upperLimit = d;
    }

    public void setLimits(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.limitEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.impulse.z = 0.0;
        }
        this.lowerLimit = d;
        this.upperLimit = d2;
    }

    public void setLimitsEnabled(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = d;
        this.upperLimit = d2;
        this.limitEnabled = true;
    }

    public Vector2 getAxis() {
        return this.body2.getWorldVector(this.xAxis);
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double d) {
        this.referenceAngle = d;
    }
}

