/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class WheelJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorTorque;
    protected double frequency;
    protected double dampingRatio;
    protected double bias;
    protected double gamma;
    protected double invK;
    protected double springMass;
    protected double motorMass;
    protected double impulse;
    protected double springImpulse;
    protected double motorImpulse;
    protected Vector2 xAxis;
    protected Vector2 yAxis;
    protected Vector2 perp;
    protected Vector2 axis;
    protected double s1;
    protected double s2;
    protected double a1;
    protected double a2;

    public WheelJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAxis"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        Vector2 vector23 = vector22.getNormalized();
        this.xAxis = body2.getLocalVector(vector23);
        this.yAxis = this.xAxis.cross(1.0);
        this.invK = 0.0;
        this.impulse = 0.0;
        this.motorMass = 0.0;
        this.motorImpulse = 0.0;
        this.springMass = 0.0;
        this.springImpulse = 0.0;
        this.frequency = 0.0;
        this.dampingRatio = 0.0;
        this.gamma = 0.0;
        this.bias = 0.0;
        this.motorEnabled = false;
        this.maximumMotorTorque = 0.0;
        this.motorSpeed = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WheelJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|XAxis=").append(this.xAxis).append("|YAxis=").append(this.yAxis).append("|Axis=").append(this.getAxis()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorTorque=").append(this.maximumMotorTorque).append("|Frequency=").append(this.frequency).append("|DampingRatio=").append(this.dampingRatio).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getWorldCenter().sum(vector2).subtract(this.body2.getWorldCenter().sum(vector22));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        this.s1 = vector2.cross(this.perp);
        this.s2 = vector22.sum(vector23).cross(this.perp);
        this.invK = d + d2 + this.s1 * this.s1 * d3 + this.s2 * this.s2 * d4;
        if (this.invK > Epsilon.E) {
            this.invK = 1.0 / this.invK;
        }
        if (this.frequency > 0.0) {
            this.a1 = vector2.cross(this.axis);
            this.a2 = vector22.sum(vector23).cross(this.axis);
            double d5 = d + d2 + this.a1 * this.a1 * d3 + this.a2 * this.a2 * d4;
            if (d5 > Epsilon.E) {
                this.springMass = 1.0 / d5;
                double d6 = vector23.dot(this.axis);
                double d7 = step.getDeltaTime();
                double d8 = Math.PI * 2 * this.frequency;
                double d9 = 2.0 * this.springMass * this.dampingRatio * d8;
                double d10 = this.springMass * d8 * d8;
                this.gamma = d7 * (d9 + d7 * d10);
                this.gamma = Math.abs(this.gamma) <= Epsilon.E ? 0.0 : 1.0 / this.gamma;
                this.bias = d6 * d7 * d10 * this.gamma;
                this.springMass = d5 + this.gamma;
                this.springMass = Math.abs(this.springMass) <= Epsilon.E ? 0.0 : 1.0 / this.springMass;
            }
        } else {
            this.springMass = 0.0;
            this.springImpulse = 0.0;
        }
        if (this.motorEnabled) {
            this.motorMass = d3 + d4;
            if (Math.abs(this.motorMass) > Epsilon.E) {
                this.motorMass = 1.0 / this.motorMass;
            }
        } else {
            this.motorMass = 0.0;
            this.motorImpulse = 0.0;
        }
        this.impulse *= step.getDeltaTimeRatio();
        this.springImpulse *= step.getDeltaTimeRatio();
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 vector24 = new Vector2();
        vector24.x = this.perp.x * this.impulse + this.springImpulse * this.axis.x;
        vector24.y = this.perp.y * this.impulse + this.springImpulse * this.axis.y;
        double d11 = this.impulse * this.s1 + this.springImpulse * this.a1 + this.motorImpulse;
        double d12 = this.impulse * this.s2 + this.springImpulse * this.a2 + this.motorImpulse;
        this.body1.getLinearVelocity().add(vector24.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * d11);
        this.body2.getLinearVelocity().subtract(vector24.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * d12);
    }

    @Override
    public void solveVelocityConstraints() {
        Step step = this.world.getStep();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = this.body1.getLinearVelocity();
        Vector2 vector22 = this.body2.getLinearVelocity();
        double d5 = this.body1.getAngularVelocity();
        double d6 = this.body2.getAngularVelocity();
        double d7 = this.axis.dot(vector2.difference(vector22)) + this.a1 * d5 - this.a2 * d6;
        double d8 = -this.springMass * (d7 + this.bias + this.gamma * this.springImpulse);
        this.springImpulse += d8;
        Vector2 vector23 = this.axis.product(d8);
        double d9 = d8 * this.a1;
        double d10 = d8 * this.a2;
        vector2.add(vector23.product(d));
        d5 += d9 * d3;
        vector22.subtract(vector23.product(d2));
        d6 -= d10 * d4;
        if (this.motorEnabled) {
            d7 = d5 - d6 - this.motorSpeed;
            d8 = this.motorMass * -d7;
            double d11 = this.motorImpulse;
            double d12 = this.maximumMotorTorque * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + d8, -d12, d12);
            d8 = this.motorImpulse - d11;
            d5 += d8 * d3;
            d6 -= d8 * d4;
        }
        d7 = this.perp.dot(vector2.difference(vector22)) + this.s1 * d5 - this.s2 * d6;
        d8 = this.invK * -d7;
        this.impulse += d8;
        vector23 = this.perp.product(d8);
        d9 = d8 * this.s1;
        d10 = d8 * this.s2;
        vector2.add(vector23.product(d));
        vector22.subtract(vector23.product(d2));
        this.body1.setAngularVelocity(d5 += d9 * d3);
        this.body2.setAngularVelocity(d6 -= d10 * d4);
    }

    @Override
    public boolean solvePositionConstraints() {
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        Vector2 vector2 = this.body1.getWorldCenter();
        Vector2 vector22 = this.body2.getWorldCenter();
        Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector25 = vector2.sum(vector23).subtract(vector22.sum(vector24));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        double d6 = this.perp.dot(vector25);
        double d7 = d2 + d3 + this.s1 * this.s1 * d4 + this.s2 * this.s2 * d5;
        double d8 = 0.0;
        d8 = d7 > Epsilon.E ? -d6 / d7 : 0.0;
        Vector2 vector26 = new Vector2();
        vector26.x = this.perp.x * d8;
        vector26.y = this.perp.y * d8;
        double d9 = this.s1 * d8;
        double d10 = this.s2 * d8;
        this.body1.translate(vector26.product(d2));
        this.body1.rotateAboutCenter(d9 * d4);
        this.body2.translate(vector26.product(-d3));
        this.body2.rotateAboutCenter(-d10 * d5);
        return Math.abs(d6) <= d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        Vector2 vector2 = new Vector2();
        vector2.x = this.impulse * this.perp.x + this.springImpulse * this.axis.x;
        vector2.y = this.impulse * this.perp.y + this.springImpulse * this.axis.y;
        vector2.multiply(d);
        return vector2;
    }

    @Override
    public double getReactionTorque(double d) {
        return this.motorImpulse * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getJointSpeed() {
        double d = this.body1.getAngularVelocity();
        double d2 = this.body2.getAngularVelocity();
        return d2 - d;
    }

    public double getJointTranslation() {
        Vector2 vector2 = this.body1.getWorldPoint(this.localAnchor1);
        Vector2 vector22 = this.body2.getWorldPoint(this.localAnchor2);
        Vector2 vector23 = vector22.difference(vector2);
        Vector2 vector24 = this.body2.getWorldVector(this.xAxis);
        return vector23.dot(vector24);
    }

    public boolean isSpring() {
        return this.frequency > 0.0;
    }

    public boolean isSpringDamper() {
        return this.frequency > 0.0 && this.dampingRatio > 0.0;
    }

    public double getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidDampingRatio"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.dampingRatio = d;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidFrequency"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.frequency = d;
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = bl;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double d) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorSpeed = d;
    }

    public double getMaximumMotorTorque() {
        return this.maximumMotorTorque;
    }

    public void setMaximumMotorTorque(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorTorque"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.maximumMotorTorque = d;
    }

    public double getMotorTorque(double d) {
        return this.motorImpulse * d;
    }

    public Vector2 getAxis() {
        return this.body2.getWorldVector(this.xAxis);
    }
}

