/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class AABB {
    protected Vector2 min;
    protected Vector2 max;

    public AABB(double d, double d2, double d3, double d4) {
        this(new Vector2(d, d2), new Vector2(d3, d4));
    }

    public AABB(Vector2 vector2, Vector2 vector22) {
        if (vector2.x > vector22.x || vector2.y > vector22.y) {
            throw new IllegalArgumentException(Messages.getString("geometry.aabb.invalidMinMax"));
        }
        this.min = vector2;
        this.max = vector22;
    }

    public AABB(double d) {
        this(null, d);
    }

    public AABB(Vector2 vector2, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.aabb.invalidRadius"));
        }
        if (vector2 == null) {
            this.min = new Vector2(-d, -d);
            this.max = new Vector2(d, d);
        } else {
            this.min = new Vector2(vector2.x - d, vector2.y - d);
            this.max = new Vector2(vector2.x + d, vector2.y + d);
        }
    }

    public AABB(AABB aABB) {
        this.min = aABB.min.copy();
        this.max = aABB.max.copy();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AABB[Min=").append(this.min).append("|Max=").append(this.max).append("]");
        return stringBuilder.toString();
    }

    public void translate(Vector2 vector2) {
        this.max.add(vector2);
        this.min.add(vector2);
    }

    public AABB getTranslated(Vector2 vector2) {
        return new AABB(this.min.sum(vector2), this.max.sum(vector2));
    }

    public double getWidth() {
        return this.max.x - this.min.x;
    }

    public double getHeight() {
        return this.max.y - this.min.y;
    }

    public double getPerimeter() {
        return 2.0 * (this.max.x - this.min.x + this.max.y - this.min.y);
    }

    public double getArea() {
        return (this.max.x - this.min.x) * (this.max.y - this.min.y);
    }

    public void union(AABB aABB) {
        this.min.x = Math.min(this.min.x, aABB.min.x);
        this.min.y = Math.min(this.min.y, aABB.min.y);
        this.max.x = Math.max(this.max.x, aABB.max.x);
        this.max.y = Math.max(this.max.y, aABB.max.y);
    }

    public AABB getUnion(AABB aABB) {
        Vector2 vector2 = new Vector2();
        Vector2 vector22 = new Vector2();
        vector2.x = Math.min(this.min.x, aABB.min.x);
        vector2.y = Math.min(this.min.y, aABB.min.y);
        vector22.x = Math.max(this.max.x, aABB.max.x);
        vector22.y = Math.max(this.max.y, aABB.max.y);
        return new AABB(vector2, vector22);
    }

    public void intersection(AABB aABB) {
        this.min.x = Math.max(this.min.x, aABB.min.x);
        this.min.y = Math.max(this.min.y, aABB.min.y);
        this.max.x = Math.min(this.max.x, aABB.max.x);
        this.max.y = Math.min(this.max.y, aABB.max.y);
        if (this.min.x > this.max.x || this.min.y > this.max.y) {
            this.min.x = 0.0;
            this.min.y = 0.0;
            this.max.x = 0.0;
            this.max.y = 0.0;
        }
    }

    public AABB getIntersection(AABB aABB) {
        Vector2 vector2 = new Vector2();
        Vector2 vector22 = new Vector2();
        vector2.x = Math.max(this.min.x, aABB.min.x);
        vector2.y = Math.max(this.min.y, aABB.min.y);
        vector22.x = Math.min(this.max.x, aABB.max.x);
        vector22.y = Math.min(this.max.y, aABB.max.y);
        if (vector2.x > vector22.x || vector2.y > vector22.y) {
            return new AABB(new Vector2(), new Vector2());
        }
        return new AABB(vector2, vector22);
    }

    public void expand(double d) {
        double d2 = d * 0.5;
        this.min.x -= d2;
        this.min.y -= d2;
        this.max.x += d2;
        this.max.y += d2;
        if (d < 0.0) {
            double d3;
            if (this.min.x > this.max.x) {
                this.min.x = d3 = (this.min.x + this.max.x) * 0.5;
                this.max.x = d3;
            }
            if (this.min.y > this.max.y) {
                this.min.y = d3 = (this.min.y + this.max.y) * 0.5;
                this.max.y = d3;
            }
        }
    }

    public AABB getExpanded(double d) {
        double d2 = d * 0.5;
        double d3 = this.min.x - d2;
        double d4 = this.min.y - d2;
        double d5 = this.max.x + d2;
        double d6 = this.max.y + d2;
        if (d < 0.0) {
            double d7;
            if (d3 > d5) {
                d3 = d7 = (d3 + d5) * 0.5;
                d5 = d7;
            }
            if (d4 > d6) {
                d4 = d7 = (d4 + d6) * 0.5;
                d6 = d7;
            }
        }
        return new AABB(new Vector2(d3, d4), new Vector2(d5, d6));
    }

    public boolean overlaps(AABB aABB) {
        if (this.min.x > aABB.max.x || this.max.x < aABB.min.x) {
            return false;
        }
        return !(this.min.y > aABB.max.y) && !(this.max.y < aABB.min.y);
    }

    public boolean contains(AABB aABB) {
        return this.min.x <= aABB.min.x && this.max.x >= aABB.max.x && this.min.y <= aABB.min.y && this.max.y >= aABB.max.y;
    }

    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    public boolean contains(double d, double d2) {
        return this.min.x <= d && this.max.x >= d && this.min.y <= d2 && this.max.y >= d2;
    }

    public boolean isDegenerate() {
        return this.min.x == this.max.x || this.min.y == this.max.y;
    }

    public boolean isDegenerate(double d) {
        return Math.abs(this.max.x - this.min.x) <= d || Math.abs(this.max.y - this.min.y) <= d;
    }

    public double getMinX() {
        return this.min.x;
    }

    public double getMaxX() {
        return this.max.x;
    }

    public double getMaxY() {
        return this.max.y;
    }

    public double getMinY() {
        return this.min.y;
    }
}

