/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.AbstractShape;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Shape;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;
import org.dyn4j.resources.Messages;

public class HalfEllipse
extends AbstractShape
implements Convex,
Shape,
Transformable {
    private static final double INERTIA_CONSTANT = 0.10975696064646573;
    protected double width;
    protected double height;
    protected double a;
    protected Vector2 localXAxis;
    protected Vector2 ellipseCenter;
    protected Vector2[] vertices;

    public HalfEllipse(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipse.invalidWidth"));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("geometry.halfEllipse.invalidHeight"));
        }
        this.width = d;
        this.height = d2;
        this.a = d * 0.5;
        this.ellipseCenter = new Vector2();
        this.center = new Vector2(0.0, 4.0 * d2 / (Math.PI * 3));
        this.localXAxis = new Vector2(1.0, 0.0);
        this.vertices = new Vector2[]{new Vector2(-this.a, 0.0), new Vector2(this.a, 0.0)};
        this.radius = this.center.distance(this.vertices[1]);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HalfEllipse[").append(super.toString()).append("|Width=").append(this.width).append("|Height=").append(this.height).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    @Override
    public Vector2[] getAxes(Vector2[] vector2Array, Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.halfEllipse.satNotSupported"));
    }

    @Override
    public Vector2[] getFoci(Transform transform) {
        throw new UnsupportedOperationException(Messages.getString("geometry.halfEllipse.satNotSupported"));
    }

    @Override
    public Vector2 getFarthestPoint(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        double d = this.getRotation();
        vector22.rotate(-d);
        vector22.x *= this.a;
        vector22.y *= this.height;
        vector22.normalize();
        Vector2 vector23 = null;
        if (vector22.y <= 0.0 && vector22.x >= 0.0) {
            return transform.getTransformed(this.vertices[1]);
        }
        if (vector22.y <= 0.0 && vector22.x <= 0.0) {
            return transform.getTransformed(this.vertices[0]);
        }
        vector23 = new Vector2(vector22.x * this.a, vector22.y * this.height);
        vector23.rotate(d);
        vector23.add(this.ellipseCenter);
        transform.transform(vector23);
        return vector23;
    }

    @Override
    public Feature getFarthestFeature(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformedR(vector2);
        if (vector22.getAngleBetween(this.localXAxis) < 0.0) {
            Vector2 vector23 = this.getFarthestPoint(vector2, transform);
            return new Vertex(vector23);
        }
        return Segment.getFarthestFeature(this.vertices[0], this.vertices[1], vector2, transform);
    }

    @Override
    public Interval project(Vector2 vector2, Transform transform) {
        Vector2 vector22 = this.getFarthestPoint(vector2, transform);
        Vector2 vector23 = this.getFarthestPoint(vector2.getNegative(), transform);
        double d = vector22.dot(vector2);
        double d2 = vector23.dot(vector2);
        return new Interval(d2, d);
    }

    @Override
    public AABB createAABB(Transform transform) {
        Interval interval = this.project(Vector2.X_AXIS, transform);
        Interval interval2 = this.project(Vector2.Y_AXIS, transform);
        return new AABB(interval.getMin(), interval2.getMin(), interval.getMax(), interval2.getMax());
    }

    @Override
    public Mass createMass(double d) {
        double d2 = Math.PI * this.a * this.height;
        double d3 = d2 * d * 0.5;
        double d4 = d3 * (this.a * this.a + this.height * this.height) * 0.10975696064646573;
        return new Mass(this.center, d3, d4);
    }

    @Override
    public double getRadius(Vector2 vector2) {
        return this.radius + vector2.distance(this.center);
    }

    @Override
    public boolean contains(Vector2 vector2, Transform transform) {
        Vector2 vector22 = transform.getInverseTransformed(vector2);
        double d = this.getRotation();
        vector22.rotate(-d, this.ellipseCenter.x, this.ellipseCenter.y);
        double d2 = vector22.x - this.ellipseCenter.x;
        double d3 = vector22.y - this.ellipseCenter.y;
        if (d3 < 0.0) {
            return false;
        }
        double d4 = d2 * d2;
        double d5 = this.a * this.a;
        double d6 = d3 * d3;
        double d7 = this.height * this.height;
        double d8 = d4 / d5 + d6 / d7;
        return d8 <= 1.0;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        super.rotate(d, d2, d3);
        this.localXAxis.rotate(d);
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].rotate(d, d2, d3);
        }
        this.ellipseCenter.rotate(d, d2, d3);
    }

    @Override
    public void translate(double d, double d2) {
        super.translate(d, d2);
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].add(d, d2);
        }
        this.ellipseCenter.add(d, d2);
    }

    public double getRotation() {
        return Vector2.X_AXIS.getAngleBetween(this.localXAxis);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHalfWidth() {
        return this.a;
    }

    public Vector2 getEllipseCenter() {
        return this.ellipseCenter;
    }
}

