/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class Matrix33 {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix33() {
    }

    public Matrix33(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix33(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException(Messages.getString("geometry.matrix.nullArray"));
        }
        if (dArray.length != 9) {
            throw new IndexOutOfBoundsException(Messages.getString("geometry.matrix.invalidLength9"));
        }
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public Matrix33(Matrix33 matrix33) {
        this.m00 = matrix33.m00;
        this.m01 = matrix33.m01;
        this.m02 = matrix33.m02;
        this.m10 = matrix33.m10;
        this.m11 = matrix33.m11;
        this.m12 = matrix33.m12;
        this.m20 = matrix33.m20;
        this.m21 = matrix33.m21;
        this.m22 = matrix33.m22;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.m00);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m01);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m02);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m10);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m11);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m12);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m20);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m21);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.m22);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Matrix33) {
            Matrix33 matrix33 = (Matrix33)object;
            if (matrix33.m00 == this.m00 && matrix33.m01 == this.m01 && matrix33.m02 == this.m02 && matrix33.m10 == this.m10 && matrix33.m11 == this.m11 && matrix33.m12 == this.m12 && matrix33.m20 == this.m20 && matrix33.m21 == this.m21 && matrix33.m22 == this.m22) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.m00).append(" ").append(this.m01).append(" ").append(this.m02).append("][").append(this.m10).append(" ").append(this.m11).append(" ").append(this.m12).append("][").append(this.m20).append(" ").append(this.m21).append(" ").append(this.m22).append("]");
        return stringBuilder.toString();
    }

    public Matrix33 add(Matrix33 matrix33) {
        this.m00 += matrix33.m00;
        this.m01 += matrix33.m01;
        this.m02 += matrix33.m02;
        this.m10 += matrix33.m10;
        this.m11 += matrix33.m11;
        this.m12 += matrix33.m12;
        this.m20 += matrix33.m20;
        this.m21 += matrix33.m21;
        this.m22 += matrix33.m22;
        return this;
    }

    public Matrix33 sum(Matrix33 matrix33) {
        Matrix33 matrix332 = new Matrix33(this);
        matrix332.m00 += matrix33.m00;
        matrix332.m01 += matrix33.m01;
        matrix332.m02 += matrix33.m02;
        matrix332.m10 += matrix33.m10;
        matrix332.m11 += matrix33.m11;
        matrix332.m12 += matrix33.m12;
        matrix332.m20 += matrix33.m20;
        matrix332.m21 += matrix33.m21;
        matrix332.m22 += matrix33.m22;
        return matrix332;
    }

    public Matrix33 subtract(Matrix33 matrix33) {
        this.m00 -= matrix33.m00;
        this.m01 -= matrix33.m01;
        this.m02 -= matrix33.m02;
        this.m10 -= matrix33.m10;
        this.m11 -= matrix33.m11;
        this.m12 -= matrix33.m12;
        this.m20 -= matrix33.m20;
        this.m21 -= matrix33.m21;
        this.m22 -= matrix33.m22;
        return this;
    }

    public Matrix33 difference(Matrix33 matrix33) {
        Matrix33 matrix332 = new Matrix33(this);
        matrix332.m00 -= matrix33.m00;
        matrix332.m01 -= matrix33.m01;
        matrix332.m02 -= matrix33.m02;
        matrix332.m10 -= matrix33.m10;
        matrix332.m11 -= matrix33.m11;
        matrix332.m12 -= matrix33.m12;
        matrix332.m20 -= matrix33.m20;
        matrix332.m21 -= matrix33.m21;
        matrix332.m22 -= matrix33.m22;
        return matrix332;
    }

    public Matrix33 multiply(Matrix33 matrix33) {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m10;
        double d5 = this.m11;
        double d6 = this.m12;
        double d7 = this.m20;
        double d8 = this.m21;
        double d9 = this.m22;
        this.m00 = d * matrix33.m00 + d2 * matrix33.m10 + d3 * matrix33.m20;
        this.m01 = d * matrix33.m01 + d2 * matrix33.m11 + d3 * matrix33.m21;
        this.m02 = d * matrix33.m02 + d2 * matrix33.m12 + d3 * matrix33.m22;
        this.m10 = d4 * matrix33.m00 + d5 * matrix33.m10 + d6 * matrix33.m20;
        this.m11 = d4 * matrix33.m01 + d5 * matrix33.m11 + d6 * matrix33.m21;
        this.m12 = d4 * matrix33.m02 + d5 * matrix33.m12 + d6 * matrix33.m22;
        this.m20 = d7 * matrix33.m00 + d8 * matrix33.m10 + d9 * matrix33.m20;
        this.m21 = d7 * matrix33.m01 + d8 * matrix33.m11 + d9 * matrix33.m21;
        this.m22 = d7 * matrix33.m02 + d8 * matrix33.m12 + d9 * matrix33.m22;
        return this;
    }

    public Matrix33 product(Matrix33 matrix33) {
        Matrix33 matrix332 = new Matrix33();
        matrix332.m00 = this.m00 * matrix33.m00 + this.m01 * matrix33.m10 + this.m02 * matrix33.m20;
        matrix332.m01 = this.m00 * matrix33.m01 + this.m01 * matrix33.m11 + this.m02 * matrix33.m21;
        matrix332.m02 = this.m00 * matrix33.m02 + this.m01 * matrix33.m12 + this.m02 * matrix33.m22;
        matrix332.m10 = this.m10 * matrix33.m00 + this.m11 * matrix33.m10 + this.m12 * matrix33.m20;
        matrix332.m11 = this.m10 * matrix33.m01 + this.m11 * matrix33.m11 + this.m12 * matrix33.m21;
        matrix332.m12 = this.m10 * matrix33.m02 + this.m11 * matrix33.m12 + this.m12 * matrix33.m22;
        matrix332.m20 = this.m20 * matrix33.m00 + this.m21 * matrix33.m10 + this.m22 * matrix33.m20;
        matrix332.m21 = this.m20 * matrix33.m01 + this.m21 * matrix33.m11 + this.m22 * matrix33.m21;
        matrix332.m22 = this.m20 * matrix33.m02 + this.m21 * matrix33.m12 + this.m22 * matrix33.m22;
        return matrix332;
    }

    public Vector3 multiply(Vector3 vector3) {
        double d = vector3.x;
        double d2 = vector3.y;
        double d3 = vector3.z;
        vector3.x = this.m00 * d + this.m01 * d2 + this.m02 * d3;
        vector3.y = this.m10 * d + this.m11 * d2 + this.m12 * d3;
        vector3.z = this.m20 * d + this.m21 * d2 + this.m22 * d3;
        return vector3;
    }

    public Vector3 product(Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        vector32.x = this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        vector32.y = this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        vector32.z = this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        return vector32;
    }

    public Vector3 multiplyT(Vector3 vector3) {
        double d = vector3.x;
        double d2 = vector3.y;
        double d3 = vector3.z;
        vector3.x = this.m00 * d + this.m10 * d2 + this.m20 * d3;
        vector3.y = this.m01 * d + this.m11 * d2 + this.m21 * d3;
        vector3.z = this.m02 * d + this.m12 * d2 + this.m22 * d3;
        return vector3;
    }

    public Vector3 productT(Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        vector32.x = this.m00 * vector3.x + this.m10 * vector3.y + this.m20 * vector3.z;
        vector32.y = this.m01 * vector3.x + this.m11 * vector3.y + this.m21 * vector3.z;
        vector32.z = this.m02 * vector3.x + this.m12 * vector3.y + this.m22 * vector3.z;
        return vector32;
    }

    public Matrix33 multiply(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
        return this;
    }

    public Matrix33 product(double d) {
        Matrix33 matrix33 = new Matrix33(this);
        matrix33.m00 *= d;
        matrix33.m01 *= d;
        matrix33.m02 *= d;
        matrix33.m10 *= d;
        matrix33.m11 *= d;
        matrix33.m12 *= d;
        matrix33.m20 *= d;
        matrix33.m21 *= d;
        matrix33.m22 *= d;
        return matrix33;
    }

    public Matrix33 identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix33 transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
        return this;
    }

    public Matrix33 getTranspose() {
        Matrix33 matrix33 = new Matrix33();
        matrix33.m00 = this.m00;
        matrix33.m01 = this.m10;
        matrix33.m02 = this.m20;
        matrix33.m10 = this.m01;
        matrix33.m11 = this.m11;
        matrix33.m12 = this.m21;
        matrix33.m20 = this.m02;
        matrix33.m21 = this.m12;
        matrix33.m22 = this.m22;
        return matrix33;
    }

    public double determinant() {
        return this.m00 * this.m11 * this.m22 + this.m01 * this.m12 * this.m20 + this.m02 * this.m10 * this.m21 - this.m20 * this.m11 * this.m02 - this.m21 * this.m12 * this.m00 - this.m22 * this.m10 * this.m01;
    }

    public Matrix33 invert() {
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        double d2 = d * (this.m11 * this.m22 - this.m12 * this.m21);
        double d3 = -d * (this.m01 * this.m22 - this.m21 * this.m02);
        double d4 = d * (this.m01 * this.m12 - this.m11 * this.m02);
        double d5 = -d * (this.m10 * this.m22 - this.m20 * this.m12);
        double d6 = d * (this.m00 * this.m22 - this.m20 * this.m02);
        double d7 = -d * (this.m00 * this.m12 - this.m10 * this.m02);
        double d8 = d * (this.m10 * this.m21 - this.m20 * this.m11);
        double d9 = -d * (this.m00 * this.m21 - this.m20 * this.m01);
        double d10 = d * (this.m00 * this.m11 - this.m10 * this.m01);
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        return this;
    }

    public Matrix33 getInverse() {
        Matrix33 matrix33 = new Matrix33();
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        matrix33.m00 = d * (this.m11 * this.m22 - this.m12 * this.m21);
        matrix33.m01 = -d * (this.m01 * this.m22 - this.m21 * this.m02);
        matrix33.m02 = d * (this.m01 * this.m12 - this.m11 * this.m02);
        matrix33.m10 = -d * (this.m10 * this.m22 - this.m20 * this.m12);
        matrix33.m11 = d * (this.m00 * this.m22 - this.m20 * this.m02);
        matrix33.m12 = -d * (this.m00 * this.m12 - this.m10 * this.m02);
        matrix33.m20 = d * (this.m10 * this.m21 - this.m20 * this.m11);
        matrix33.m21 = -d * (this.m00 * this.m21 - this.m20 * this.m01);
        matrix33.m22 = d * (this.m00 * this.m11 - this.m10 * this.m01);
        return matrix33;
    }

    public Vector3 solve33(Vector3 vector3) {
        double d = this.determinant();
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        Vector3 vector32 = new Vector3();
        double d2 = this.m11 * this.m22 - this.m12 * this.m21;
        double d3 = -this.m01 * this.m22 + this.m21 * this.m02;
        double d4 = this.m01 * this.m12 - this.m11 * this.m02;
        double d5 = -this.m10 * this.m22 + this.m20 * this.m12;
        double d6 = this.m00 * this.m22 - this.m20 * this.m02;
        double d7 = -this.m00 * this.m12 + this.m10 * this.m02;
        double d8 = this.m10 * this.m21 - this.m20 * this.m11;
        double d9 = -this.m00 * this.m21 + this.m20 * this.m01;
        double d10 = this.m00 * this.m11 - this.m10 * this.m01;
        vector32.x = d * (d2 * vector3.x + d3 * vector3.y + d4 * vector3.z);
        vector32.y = d * (d5 * vector3.x + d6 * vector3.y + d7 * vector3.z);
        vector32.z = d * (d8 * vector3.x + d9 * vector3.y + d10 * vector3.z);
        return vector32;
    }

    public Vector2 solve22(Vector2 vector2) {
        double d = this.m00 * this.m11 - this.m01 * this.m10;
        if (Math.abs(d) > Epsilon.E) {
            d = 1.0 / d;
        }
        Vector2 vector22 = new Vector2();
        vector22.x = d * (this.m11 * vector2.x - this.m01 * vector2.y);
        vector22.y = d * (this.m00 * vector2.y - this.m10 * vector2.x);
        return vector22;
    }
}

