/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Ray {
    protected Vector2 start;
    protected Vector2 direction;

    public Ray(double d) {
        this(new Vector2(d));
    }

    public Ray(Vector2 vector2) {
        this(new Vector2(), vector2);
    }

    public Ray(Vector2 vector2, double d) {
        this(vector2, new Vector2(d));
    }

    public Ray(Vector2 vector2, Vector2 vector22) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullStart"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullDirection"));
        }
        if (vector22.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.ray.zeroDirection"));
        }
        this.start = vector2;
        this.direction = vector22;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ray[Start=").append(this.start).append("|Direction=").append(this.getDirection()).append("]");
        return stringBuilder.toString();
    }

    public Vector2 getStart() {
        return this.start;
    }

    public void setStart(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullStart"));
        }
        this.start = vector2;
    }

    public double getDirection() {
        return this.direction.getDirection();
    }

    public void setDirection(double d) {
        this.direction = new Vector2(d);
    }

    public Vector2 getDirectionVector() {
        return this.direction;
    }

    public void setDirection(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("geometry.ray.nullDirection"));
        }
        if (vector2.isZero()) {
            throw new IllegalArgumentException(Messages.getString("geometry.ray.zeroDirection"));
        }
        this.direction = vector2;
    }
}

