/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry;

import org.dyn4j.Epsilon;

public class Vector2 {
    protected static final Vector2 X_AXIS = new Vector2(1.0, 0.0);
    protected static final Vector2 Y_AXIS = new Vector2(0.0, 1.0);
    public double x;
    public double y;

    public Vector2() {
    }

    public Vector2(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public Vector2(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2(double d, double d2, double d3, double d4) {
        this.x = d3 - d;
        this.y = d4 - d2;
    }

    public Vector2(Vector2 vector2, Vector2 vector22) {
        this.x = vector22.x - vector2.x;
        this.y = vector22.y - vector2.y;
    }

    public Vector2(double d) {
        this.x = Math.cos(d);
        this.y = Math.sin(d);
    }

    public static Vector2 create(double d, double d2) {
        double d3 = d * Math.cos(d2);
        double d4 = d * Math.sin(d2);
        return new Vector2(d3, d4);
    }

    public Vector2 copy() {
        return new Vector2(this.x, this.y);
    }

    public double distance(double d, double d2) {
        return Math.hypot(this.x - d, this.y - d2);
    }

    public double distance(Vector2 vector2) {
        return Math.hypot(this.x - vector2.x, this.y - vector2.y);
    }

    public double distanceSquared(double d, double d2) {
        return (this.x - d) * (this.x - d) + (this.y - d2) * (this.y - d2);
    }

    public double distanceSquared(Vector2 vector2) {
        return (this.x - vector2.x) * (this.x - vector2.x) + (this.y - vector2.y) * (this.y - vector2.y);
    }

    public static Vector2 tripleProduct(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        Vector2 vector24 = new Vector2();
        double d = vector2.x * vector23.x + vector2.y * vector23.y;
        double d2 = vector22.x * vector23.x + vector22.y * vector23.y;
        vector24.x = vector22.x * d - vector2.x * d2;
        vector24.y = vector22.y * d - vector2.y * d2;
        return vector24;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Vector2) {
            Vector2 vector2 = (Vector2)object;
            return this.x == vector2.x && this.y == vector2.y;
        }
        return false;
    }

    public boolean equals(Vector2 vector2) {
        if (vector2 == null) {
            return false;
        }
        if (this == vector2) {
            return true;
        }
        return this.x == vector2.x && this.y == vector2.y;
    }

    public boolean equals(double d, double d2) {
        return this.x == d && this.y == d2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(this.x).append(", ").append(this.y).append(")");
        return stringBuilder.toString();
    }

    public Vector2 set(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
        return this;
    }

    public Vector2 set(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vector2 getXComponent() {
        return new Vector2(this.x, 0.0);
    }

    public Vector2 getYComponent() {
        return new Vector2(0.0, this.y);
    }

    public double getMagnitude() {
        return Math.hypot(this.x, this.y);
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2 setMagnitude(double d) {
        if (Math.abs(d) <= Epsilon.E) {
            this.x = 0.0;
            this.y = 0.0;
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        double d2 = Math.hypot(this.x, this.y);
        d2 = d / d2;
        this.x *= d2;
        this.y *= d2;
        return this;
    }

    public double getDirection() {
        return Math.atan2(this.y, this.x);
    }

    public Vector2 setDirection(double d) {
        double d2 = Math.hypot(this.x, this.y);
        this.x = d2 * Math.cos(d);
        this.y = d2 * Math.sin(d);
        return this;
    }

    public Vector2 add(Vector2 vector2) {
        this.x += vector2.x;
        this.y += vector2.y;
        return this;
    }

    public Vector2 add(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    public Vector2 sum(Vector2 vector2) {
        return new Vector2(this.x + vector2.x, this.y + vector2.y);
    }

    public Vector2 sum(double d, double d2) {
        return new Vector2(this.x + d, this.y + d2);
    }

    public Vector2 subtract(Vector2 vector2) {
        this.x -= vector2.x;
        this.y -= vector2.y;
        return this;
    }

    public Vector2 subtract(double d, double d2) {
        this.x -= d;
        this.y -= d2;
        return this;
    }

    public Vector2 difference(Vector2 vector2) {
        return new Vector2(this.x - vector2.x, this.y - vector2.y);
    }

    public Vector2 difference(double d, double d2) {
        return new Vector2(this.x - d, this.y - d2);
    }

    public Vector2 to(Vector2 vector2) {
        return new Vector2(vector2.x - this.x, vector2.y - this.y);
    }

    public Vector2 to(double d, double d2) {
        return new Vector2(d - this.x, d2 - this.y);
    }

    public Vector2 multiply(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public Vector2 product(double d) {
        return new Vector2(this.x * d, this.y * d);
    }

    public double dot(Vector2 vector2) {
        return this.x * vector2.x + this.y * vector2.y;
    }

    public double dot(double d, double d2) {
        return this.x * d + this.y * d2;
    }

    public double cross(Vector2 vector2) {
        return this.x * vector2.y - this.y * vector2.x;
    }

    public double cross(double d, double d2) {
        return this.x * d2 - this.y * d;
    }

    public Vector2 cross(double d) {
        return new Vector2(-1.0 * this.y * d, this.x * d);
    }

    public boolean isOrthogonal(Vector2 vector2) {
        return Math.abs(this.x * vector2.x + this.y * vector2.y) <= Epsilon.E;
    }

    public boolean isOrthogonal(double d, double d2) {
        return Math.abs(this.x * d + this.y * d2) <= Epsilon.E;
    }

    public boolean isZero() {
        return Math.abs(this.x) <= Epsilon.E && Math.abs(this.y) <= Epsilon.E;
    }

    public Vector2 negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        return this;
    }

    public Vector2 getNegative() {
        return new Vector2(-this.x, -this.y);
    }

    public Vector2 zero() {
        this.x = 0.0;
        this.y = 0.0;
        return this;
    }

    public Vector2 rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        double d5 = this.y;
        this.x = d4 * d2 - d5 * d3;
        this.y = d4 * d3 + d5 * d2;
        return this;
    }

    public Vector2 rotate(double d, double d2, double d3) {
        this.x -= d2;
        this.y -= d3;
        this.rotate(d);
        this.x += d2;
        this.y += d3;
        return this;
    }

    public Vector2 rotate(double d, Vector2 vector2) {
        return this.rotate(d, vector2.x, vector2.y);
    }

    public Vector2 project(Vector2 vector2) {
        double d = this.dot(vector2);
        double d2 = vector2.dot(vector2);
        if (d2 <= Epsilon.E) {
            return new Vector2();
        }
        d2 = d / d2;
        return new Vector2(d2 * vector2.x, d2 * vector2.y);
    }

    public Vector2 getRightHandOrthogonalVector() {
        return new Vector2(-this.y, this.x);
    }

    public Vector2 right() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
        return this;
    }

    public Vector2 getLeftHandOrthogonalVector() {
        return new Vector2(this.y, -this.x);
    }

    public Vector2 left() {
        double d = this.x;
        this.x = this.y;
        this.y = -d;
        return this;
    }

    public Vector2 getNormalized() {
        double d = this.getMagnitude();
        if (d <= Epsilon.E) {
            return new Vector2();
        }
        d = 1.0 / d;
        return new Vector2(this.x * d, this.y * d);
    }

    public double normalize() {
        double d = Math.hypot(this.x, this.y);
        if (d <= Epsilon.E) {
            return 0.0;
        }
        double d2 = 1.0 / d;
        this.x *= d2;
        this.y *= d2;
        return d;
    }

    public double getAngleBetween(Vector2 vector2) {
        double d = Math.atan2(vector2.y, vector2.x) - Math.atan2(this.y, this.x);
        if (d > Math.PI) {
            return d - Math.PI * 2;
        }
        if (d < -Math.PI) {
            return d + Math.PI * 2;
        }
        return d;
    }
}

