/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.decompose;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Geometry;
import org.dyn4j.geometry.Polygon;
import org.dyn4j.geometry.Triangle;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.decompose.MonotoneChain;
import org.dyn4j.geometry.decompose.MonotonePolygon;
import org.dyn4j.geometry.decompose.MonotoneVertex;
import org.dyn4j.resources.Messages;

public class DoublyConnectedEdgeList {
    protected List<Vertex> vertices = new ArrayList<Vertex>();
    protected List<HalfEdge> edges = new ArrayList<HalfEdge>();
    protected List<Face> faces = new ArrayList<Face>();

    public DoublyConnectedEdgeList(Vector2[] vector2Array) {
        this.initialize(vector2Array);
    }

    protected void initialize(Vector2[] vector2Array) {
        HalfEdge halfEdge;
        Object object;
        int n = vector2Array.length;
        Face face = new Face();
        this.faces.add(face);
        HalfEdge halfEdge2 = null;
        HalfEdge halfEdge3 = null;
        for (int i = 0; i < n; ++i) {
            object = vector2Array[i];
            Vertex vertex = new Vertex();
            HalfEdge halfEdge4 = new HalfEdge();
            HalfEdge halfEdge5 = new HalfEdge();
            halfEdge4.face = face;
            halfEdge4.next = null;
            halfEdge4.origin = vertex;
            halfEdge4.twin = halfEdge5;
            halfEdge5.face = null;
            halfEdge5.next = halfEdge3;
            halfEdge5.origin = null;
            halfEdge5.twin = halfEdge4;
            this.edges.add(halfEdge4);
            this.edges.add(halfEdge5);
            vertex.leaving = halfEdge4;
            vertex.point = object;
            this.vertices.add(vertex);
            if (halfEdge2 != null) {
                halfEdge2.next = halfEdge4;
            }
            if (halfEdge3 != null) {
                halfEdge3.origin = vertex;
            }
            halfEdge2 = halfEdge4;
            halfEdge3 = halfEdge5;
        }
        halfEdge2.next = halfEdge = this.edges.get(0);
        object = this.edges.get(1);
        ((HalfEdge)object).next = halfEdge3;
        halfEdge3.origin = this.vertices.get(0);
        face.edge = halfEdge;
    }

    public void addHalfEdges(Vertex vertex, Vertex vertex2) {
        Face face = new Face();
        HalfEdge halfEdge = new HalfEdge();
        HalfEdge halfEdge2 = new HalfEdge();
        Face face2 = this.getReferenceFace(vertex, vertex2);
        HalfEdge halfEdge3 = this.getPreviousEdge(vertex, face2);
        HalfEdge halfEdge4 = this.getPreviousEdge(vertex2, face2);
        face.edge = halfEdge;
        face2.edge = halfEdge2;
        halfEdge.face = face;
        halfEdge.next = halfEdge4.next;
        halfEdge.origin = vertex;
        halfEdge.twin = halfEdge2;
        halfEdge2.face = face2;
        halfEdge2.next = halfEdge3.next;
        halfEdge2.origin = vertex2;
        halfEdge2.twin = halfEdge;
        halfEdge3.next = halfEdge;
        halfEdge4.next = halfEdge2;
        HalfEdge halfEdge5 = halfEdge.next;
        while (halfEdge5 != halfEdge) {
            halfEdge5.face = face;
            halfEdge5 = halfEdge5.next;
        }
        this.edges.add(halfEdge);
        this.edges.add(halfEdge2);
        this.faces.add(face);
    }

    protected HalfEdge getPreviousEdge(Vertex vertex, Face face) {
        HalfEdge halfEdge = vertex.leaving.twin;
        HalfEdge halfEdge2 = vertex.leaving.twin.next.twin;
        while (halfEdge2 != halfEdge) {
            if (halfEdge2.face == face) {
                return halfEdge2;
            }
            halfEdge2 = halfEdge2.next.twin;
        }
        return halfEdge2;
    }

    protected Face getReferenceFace(Vertex vertex, Vertex vertex2) {
        if (vertex.leaving.face == vertex2.leaving.face) {
            return vertex.leaving.face;
        }
        HalfEdge halfEdge = vertex.leaving.twin.next.twin;
        while (halfEdge != vertex.leaving.twin) {
            HalfEdge halfEdge2 = vertex2.leaving.twin.next.twin;
            while (halfEdge2 != vertex2.leaving.twin) {
                if (halfEdge.face == halfEdge2.face) {
                    return halfEdge.face;
                }
                halfEdge2 = halfEdge2.next.twin;
            }
            halfEdge = halfEdge.next.twin;
        }
        return vertex.leaving.face;
    }

    public void removeHalfEdges(int n) {
        HalfEdge halfEdge = this.edges.get(n);
        this.removeHalfEdges(n, halfEdge);
    }

    public void removeHalfEdges(HalfEdge halfEdge) {
        int n = this.edges.indexOf(halfEdge);
        this.removeHalfEdges(n, halfEdge);
    }

    protected void removeHalfEdges(int n, HalfEdge halfEdge) {
        HalfEdge halfEdge2;
        Face face = halfEdge.twin.face;
        HalfEdge halfEdge3 = halfEdge.getPrevious();
        HalfEdge halfEdge4 = halfEdge.twin.getPrevious();
        HalfEdge halfEdge5 = halfEdge.next;
        halfEdge3.next = halfEdge2 = halfEdge.twin.next;
        halfEdge4.next = halfEdge5;
        face.edge = halfEdge5;
        HalfEdge halfEdge6 = halfEdge5;
        while (halfEdge6 != halfEdge2) {
            halfEdge6.face = face;
            halfEdge6 = halfEdge6.next;
        }
        this.faces.remove(halfEdge.face);
        this.edges.remove(n);
        this.edges.remove(n);
    }

    public List<Convex> getConvexDecomposition() {
        ArrayList<Convex> arrayList = new ArrayList<Convex>();
        int n = this.faces.size();
        for (int i = 0; i < n; ++i) {
            Face face = this.faces.get(i);
            int n2 = face.getEdgeCount();
            HalfEdge halfEdge = face.edge;
            Vector2[] vector2Array = new Vector2[n2];
            vector2Array[0] = halfEdge.origin.point;
            halfEdge = halfEdge.next;
            int n3 = 1;
            while (halfEdge != face.edge) {
                vector2Array[n3++] = halfEdge.origin.point;
                halfEdge = halfEdge.next;
            }
            if (vector2Array.length < 3) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
            }
            Polygon polygon = Geometry.createPolygon(vector2Array);
            arrayList.add(polygon);
        }
        return arrayList;
    }

    public List<Triangle> getTriangulation() {
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        int n = this.faces.size();
        for (int i = 0; i < n; ++i) {
            Face face = this.faces.get(i);
            int n2 = face.getEdgeCount();
            HalfEdge halfEdge = face.edge;
            Vector2[] vector2Array = new Vector2[n2];
            vector2Array[0] = halfEdge.origin.point;
            halfEdge = halfEdge.next;
            int n3 = 1;
            while (halfEdge != face.edge) {
                vector2Array[n3++] = halfEdge.origin.point;
                halfEdge = halfEdge.next;
            }
            if (vector2Array.length != 3) {
                throw new IllegalArgumentException(Messages.getString("geometry.decompose.crossingEdges"));
            }
            Triangle triangle = Geometry.createTriangle(vector2Array[0], vector2Array[1], vector2Array[2]);
            arrayList.add(triangle);
        }
        return arrayList;
    }

    public List<MonotonePolygon<Vertex>> getYMonotonePolygons() {
        int n = this.faces.size();
        ArrayList<MonotonePolygon<Vertex>> arrayList = new ArrayList<MonotonePolygon<Vertex>>(n);
        for (int i = 0; i < n; ++i) {
            MonotoneVertex monotoneVertex;
            Object object;
            Face face = this.faces.get(i);
            int n2 = face.getEdgeCount();
            HalfEdge halfEdge = face.edge;
            MonotoneVertex monotoneVertex2 = new MonotoneVertex();
            monotoneVertex2.data = halfEdge.origin;
            halfEdge = halfEdge.next;
            MonotoneVertex monotoneVertex3 = monotoneVertex2;
            MonotoneVertex monotoneVertex4 = null;
            MonotoneVertex monotoneVertex5 = monotoneVertex2;
            while (halfEdge != face.edge) {
                monotoneVertex4 = new MonotoneVertex();
                monotoneVertex4.data = halfEdge.origin;
                monotoneVertex4.prev = monotoneVertex3;
                monotoneVertex3.next = monotoneVertex4;
                object = ((Vertex)monotoneVertex4.data).point;
                monotoneVertex = ((Vertex)monotoneVertex5.data).point;
                double d = ((Vector2)object).y - ((Vector2)((Object)monotoneVertex)).y;
                if (d == 0.0) {
                    d = ((Vector2)object).x - ((Vector2)((Object)monotoneVertex)).x;
                    if (d < 0.0) {
                        monotoneVertex5 = monotoneVertex4;
                    }
                } else if (d > 0.0) {
                    monotoneVertex5 = monotoneVertex4;
                }
                halfEdge = halfEdge.next;
                monotoneVertex3 = monotoneVertex4;
            }
            monotoneVertex2.prev = monotoneVertex4;
            monotoneVertex4.next = monotoneVertex2;
            object = new ArrayList(n2);
            object.add(monotoneVertex5);
            monotoneVertex5.chain = MonotoneChain.Type.LEFT;
            monotoneVertex = monotoneVertex5.next;
            MonotoneVertex monotoneVertex6 = monotoneVertex5.prev;
            for (int j = 1; j < n2; ++j) {
                Vector2 vector2 = ((Vertex)monotoneVertex.data).point;
                Vector2 vector22 = ((Vertex)monotoneVertex6.data).point;
                if (vector2.y > vector22.y) {
                    object.add(monotoneVertex);
                    monotoneVertex.chain = MonotoneChain.Type.LEFT;
                    monotoneVertex = monotoneVertex.next;
                    continue;
                }
                object.add(monotoneVertex6);
                monotoneVertex6.chain = MonotoneChain.Type.RIGHT;
                monotoneVertex6 = monotoneVertex6.prev;
            }
            ((MonotoneVertex)object.get((int)(n2 - 1))).chain = MonotoneChain.Type.RIGHT;
            arrayList.add(new MonotonePolygon(MonotonePolygon.Type.Y, object));
        }
        return arrayList;
    }

    public void triangulateMonotoneY(MonotonePolygon<Vertex> monotonePolygon) {
        ArrayList arrayList = new ArrayList();
        List list = monotonePolygon.vertices;
        arrayList.add(list.get(0));
        arrayList.add(list.get(1));
        int n = 2;
        while (!arrayList.isEmpty()) {
            MonotoneVertex monotoneVertex = list.get(n);
            MonotoneVertex monotoneVertex2 = (MonotoneVertex)arrayList.get(0);
            MonotoneVertex monotoneVertex3 = (MonotoneVertex)arrayList.get(arrayList.size() - 1);
            if (monotoneVertex.isAdjacent(monotoneVertex2) && !monotoneVertex.isAdjacent(monotoneVertex3)) {
                while (arrayList.size() > 1) {
                    MonotoneVertex monotoneVertex4 = (MonotoneVertex)arrayList.remove(arrayList.size() - 1);
                    this.addHalfEdges((Vertex)monotoneVertex.data, (Vertex)monotoneVertex4.data);
                }
                arrayList.clear();
                arrayList.add(monotoneVertex3);
                arrayList.add(monotoneVertex);
            } else if (monotoneVertex.isAdjacent(monotoneVertex3) && !monotoneVertex.isAdjacent(monotoneVertex2)) {
                double d = 0.0;
                for (int i = arrayList.size(); i > 1; --i) {
                    Vector2 vector2;
                    Vector2 vector22;
                    MonotoneVertex monotoneVertex5 = (MonotoneVertex)arrayList.get(i - 1);
                    MonotoneVertex monotoneVertex6 = (MonotoneVertex)arrayList.get(i - 2);
                    Vector2 vector23 = ((Vertex)monotoneVertex.data).point;
                    Vector2 vector24 = ((Vertex)monotoneVertex5.data).point;
                    Vector2 vector25 = ((Vertex)monotoneVertex6.data).point;
                    if (monotoneVertex.chain == MonotoneChain.Type.LEFT || monotoneVertex.chain == MonotoneChain.Type.BOTTOM) {
                        vector22 = vector24.to(vector25);
                        vector2 = vector24.to(vector23);
                        d = vector22.cross(vector2);
                    } else {
                        vector22 = vector23.to(vector24);
                        vector2 = vector25.to(vector24);
                        d = vector22.cross(vector2);
                    }
                    if (!(d < Epsilon.E)) break;
                    this.addHalfEdges((Vertex)monotoneVertex.data, (Vertex)monotoneVertex6.data);
                    arrayList.remove(i - 1);
                }
                arrayList.add(monotoneVertex);
            } else if (monotoneVertex.isAdjacent(monotoneVertex3) && monotoneVertex.isAdjacent(monotoneVertex2)) {
                arrayList.remove(arrayList.size() - 1);
                while (arrayList.size() > 1) {
                    MonotoneVertex monotoneVertex7 = (MonotoneVertex)arrayList.remove(arrayList.size() - 1);
                    this.addHalfEdges((Vertex)monotoneVertex.data, (Vertex)monotoneVertex7.data);
                }
                break;
            }
            ++n;
        }
    }

    public void hertelMehlhorn() {
        int n = this.vertices.size();
        int n2 = n * 2;
        while (n2 < this.edges.size()) {
            HalfEdge halfEdge = this.edges.get(n2);
            Vertex vertex = halfEdge.getPrevious().origin;
            Vertex vertex2 = halfEdge.origin;
            Vertex vertex3 = halfEdge.twin.next.next.origin;
            if (this.isReflex(vertex, vertex2, vertex3)) {
                n2 += 2;
                continue;
            }
            vertex = halfEdge.twin.getPrevious().origin;
            vertex2 = halfEdge.twin.origin;
            vertex3 = halfEdge.next.next.origin;
            if (this.isReflex(vertex, vertex2, vertex3)) {
                n2 += 2;
                continue;
            }
            this.removeHalfEdges(n2, halfEdge);
        }
    }

    protected boolean isReflex(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        Vector2 vector2;
        Vector2 vector22 = vertex.point;
        Vector2 vector23 = vertex2.point;
        Vector2 vector24 = vertex3.point;
        Vector2 vector25 = vector22.to(vector23);
        double d = vector25.cross(vector2 = vector23.to(vector24));
        return d < 0.0;
    }

    public class Face {
        protected HalfEdge edge;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Face[Edge=").append(this.edge).append("]");
            return stringBuilder.toString();
        }

        public int getEdgeCount() {
            HalfEdge halfEdge = this.edge;
            int n = 0;
            if (halfEdge != null) {
                ++n;
                while (halfEdge.next != this.edge) {
                    ++n;
                    halfEdge = halfEdge.next;
                }
            }
            return n;
        }
    }

    public class HalfEdge {
        protected Vertex origin;
        protected HalfEdge twin;
        protected HalfEdge next;
        protected Face face;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HalfEdge[Origin=").append(this.origin).append("|Next=").append(this.next.origin).append("]");
            return stringBuilder.toString();
        }

        public Vertex getOrigin() {
            return this.origin;
        }

        public Vertex getDestination() {
            return this.next.origin;
        }

        public HalfEdge getTwin() {
            return this.twin;
        }

        public HalfEdge getNext() {
            return this.next;
        }

        public HalfEdge getPrevious() {
            HalfEdge halfEdge = this.twin.next.twin;
            while (halfEdge.next != this) {
                halfEdge = halfEdge.next.twin;
            }
            return halfEdge;
        }

        public Face getFace() {
            return this.face;
        }
    }

    public class Vertex {
        protected Vector2 point;
        protected HalfEdge leaving;

        public String toString() {
            return this.point.toString();
        }

        public Vector2 getPoint() {
            return this.point;
        }

        public HalfEdge getLeaving() {
            return this.leaving;
        }

        public HalfEdge getEdgeTo(Vertex vertex) {
            if (this.leaving != null) {
                if (this.leaving.twin.origin == vertex) {
                    return this.leaving;
                }
                HalfEdge halfEdge = this.leaving.twin.next;
                while (halfEdge != this.leaving) {
                    if (halfEdge.twin.origin == vertex) {
                        return halfEdge;
                    }
                    halfEdge = halfEdge.twin.next;
                }
            }
            return null;
        }
    }
}

