/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.geometry.hull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.hull.HullGenerator;
import org.dyn4j.resources.Messages;

public class GrahamScan
implements HullGenerator {
    @Override
    public Vector2[] generate(Vector2 ... vector2Array) {
        Object object;
        if (vector2Array == null) {
            throw new NullPointerException(Messages.getString("geometry.hull.nullArray"));
        }
        int n = vector2Array.length;
        if (n == 1 || n == 2) {
            return vector2Array;
        }
        Object object2 = vector2Array[0];
        for (int i = 1; i < n; ++i) {
            object = vector2Array[i];
            if (object == null) {
                throw new NullPointerException(Messages.getString("geometry.hull.nullPoints"));
            }
            if (((Vector2)object).y < ((Vector2)object2).y) {
                object2 = object;
                continue;
            }
            if (((Vector2)object).y != ((Vector2)object2).y || !(((Vector2)object).x < ((Vector2)object2).x)) continue;
            object2 = object;
        }
        PointComparator pointComparator = new PointComparator((Vector2)object2);
        Arrays.sort(vector2Array, pointComparator);
        object = new ArrayList();
        object.add(vector2Array[0]);
        object.add(vector2Array[1]);
        int n2 = 2;
        while (n2 < n) {
            Vector2 vector2;
            int n3 = object.size();
            if (n3 == 1) {
                object.add(vector2Array[n2]);
                ++n2;
                continue;
            }
            Vector2 vector22 = vector2Array[n2];
            Vector2 vector23 = (Vector2)object.get(n3 - 2);
            double d = Segment.getLocation(vector22, vector23, vector2 = (Vector2)object.get(n3 - 1));
            if (d > 0.0) {
                object.add(vector22);
                ++n2;
                continue;
            }
            object.remove(n3 - 1);
        }
        Vector2[] vector2Array2 = new Vector2[object.size()];
        object.toArray(vector2Array2);
        return vector2Array2;
    }

    private class PointComparator
    implements Comparator<Vector2> {
        private final Vector2 x = new Vector2(1.0, 0.0);
        private Vector2 reference;

        public PointComparator(Vector2 vector2) {
            this.reference = vector2;
        }

        @Override
        public int compare(Vector2 vector2, Vector2 vector22) {
            Vector2 vector23 = this.reference.to(vector2);
            Vector2 vector24 = this.reference.to(vector22);
            return (int)Math.signum(vector24.getAngleBetween(this.x) - vector23.getAngleBetween(this.x));
        }
    }
}

