/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.context.Application;
import br.com.etyllica.core.GameCore;
import br.com.etyllica.core.InnerCore;
import br.com.etyllica.core.engine.Engine;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.graphics.FullScreenWindow;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.graphics.Monitor;
import br.com.etyllica.core.loader.Loader;
import br.com.etyllica.core.loop.FrameSkippingLoop;
import br.com.etyllica.core.loop.GameLoop;
import br.com.etyllica.effects.GenericFullScreenEffect;
import br.com.etyllica.gui.Window;
import br.com.etyllica.util.io.IOHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SharedCore
implements Runnable,
GameCore,
ComponentListener {
    private int width;
    private int height;
    private Set<Loader> loaders;
    private GraphicsConfiguration configuration;
    private Component component;
    private Window window;
    private VolatileImage volatileImage;
    private String path = "";
    private Graphic graphic;
    private FullScreenWindow telaCheia = null;
    private Engine engine;
    private InnerCore innerCore;
    private List<Monitor> monitors = new ArrayList<Monitor>();
    private boolean running = true;
    private GameLoop gameLoop;
    private boolean locked = false;

    public SharedCore(Component component, int n, int n2) {
        this.component = component;
        this.configuration = component.getGraphicsConfiguration();
        this.width = n;
        this.height = n2;
        this.window = new Window(0, 0, n, n2);
        this.initGraphics(n, n2);
        this.innerCore = new InnerCore();
        this.initMonitors();
        this.gameLoop = new FrameSkippingLoop(this);
    }

    private void initGraphics(int n, int n2) {
        this.locked = true;
        this.graphic = new Graphic(n, n2);
        this.defineSize(n, n2);
        this.locked = false;
    }

    private void initMonitors() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray.length > 0) {
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                Rectangle rectangle = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
                int n = rectangle.x;
                int n2 = rectangle.y;
                int n3 = rectangle.width;
                int n4 = rectangle.height;
                this.monitors.add(new Monitor(n, n2, n3, n4));
            }
        } else {
            this.monitors.add(new Monitor(0, 0, this.width, this.height));
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        String string2;
        this.path = string2 = IOHandler.fixPath(string);
    }

    public void initDefault() {
        for (Loader loader : this.loaders) {
            loader.setUrl(this.path);
            loader.start();
        }
    }

    public void enableFullScreen() {
        Monitor monitor = this.monitors.get(0);
        Point point = this.component.getLocation();
        for (Monitor monitor2 : this.monitors) {
            if (!CollisionDetector.colideRectPoint(monitor2, (double)point.x, (double)point.y)) continue;
            monitor = monitor2;
        }
        if (!this.innerCore.fullScreenEnable) {
            this.telaCheia = new FullScreenWindow(this.innerCore, monitor);
            this.innerCore.fullScreenEnable = true;
        }
        this.innerCore.addEffect(new GenericFullScreenEffect(0, 0, this.width, this.height));
    }

    public void disableFullScreen() {
        this.telaCheia.dispose();
        this.innerCore.fullScreenEnable = false;
    }

    public void startCore(Application application) {
        this.window.setApplication(application);
        this.innerCore.replaceWindow(this.window);
        this.component.setFocusTraversalKeysEnabled(false);
        this.component.setFocusable(true);
        this.component.requestFocus();
        this.hideDefaultCursor();
        this.component.addMouseMotionListener(this.innerCore.mouse);
        this.component.addMouseWheelListener(this.innerCore.mouse);
        this.component.addMouseListener(this.innerCore.mouse);
        this.component.addKeyListener(this.innerCore.keyboard);
    }

    private VolatileImage createBackBuffer(int n, int n2) {
        return this.createBackBuffer(n, n2, 1);
    }

    private VolatileImage createBackBuffer(int n, int n2, int n3) {
        return this.configuration.createCompatibleVolatileImage(n, n2, n3);
    }

    public void defineSize(int n, int n2) {
        this.component.setSize(n, n2);
        this.volatileImage = this.createBackBuffer(n, n2);
        if (this.volatileImage != null) {
            this.graphic.setVolatileImage(this.volatileImage);
        }
    }

    public void validateVolatileImage() {
        int n = this.volatileImage.validate(this.configuration);
        if (n == 2) {
            this.volatileImage = this.createBackBuffer(this.width, this.height);
            this.graphic.setVolatileImage(this.volatileImage);
        }
    }

    public void hideDefaultCursor() {
        int[] nArray = new int[256];
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, nArray, 0, 16)), new Point(0, 0), "invisibleCursor");
        this.component.setCursor(cursor);
    }

    public void paint(Graphics graphics) {
        if (this.locked) {
            return;
        }
        this.validateVolatileImage();
        this.innerCore.draw(this.graphic);
        if (this.graphic.getVimg() == null) {
            return;
        }
        if (!this.innerCore.fullScreenEnable) {
            graphics.drawImage(this.graphic.getVimg(), this.window.getContext().getX(), this.window.getContext().getY(), this.component);
        } else {
            this.telaCheia.draw(this.graphic.getVimg());
        }
        graphics.dispose();
    }

    public int getW() {
        return this.width;
    }

    public void setW(int n) {
        this.width = n;
    }

    public int getH() {
        return this.height;
    }

    public void setH(int n) {
        this.height = n;
    }

    public void setLoaders(Set<Loader> set) {
        this.loaders = set;
    }

    @Override
    public void update(double d) {
        long l = System.currentTimeMillis();
        this.innerCore.update(l);
        this.updateEngine(d);
    }

    @Override
    public void render() {
        this.engine.draw();
    }

    public void hideCursor() {
        this.innerCore.hideCursor();
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void startEngine() {
        this.component.setVisible(true);
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.gameLoop.loop();
    }

    private void updateEngine(double d) {
        GUIEvent gUIEvent = this.innerCore.getSuperEvent();
        this.engine.updateSuperEvent(gUIEvent);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setFps(int n) {
        this.innerCore.setFps(n);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        Rectangle rectangle = component.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        this.initGraphics(n, n2);
        this.innerCore.resizeApplication(n, n2);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

