/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.drawer;

import br.com.etyllica.core.Configuration;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseState;
import br.com.etyllica.core.input.mouse.MouseStateListener;
import br.com.etyllica.theme.mouse.ArrowTheme;
import br.com.etyllica.theme.mouse.ArrowThemeListener;
import br.com.etyllica.theme.mouse.MouseArrow;
import java.awt.BasicStroke;
import java.awt.Color;

public class ArrowDrawer
implements MouseStateListener,
ArrowThemeListener {
    private int x = 0;
    private int y = 0;
    private static final BasicStroke strokeOne = new BasicStroke(1.0f);
    private static final BasicStroke strokeThree = new BasicStroke(3.0f);
    private static final BasicStroke strokeFive = new BasicStroke(5.0f);
    protected ArrowTheme arrowTheme;
    protected MouseArrow arrow;
    protected int arc = 0;
    protected boolean overText = false;
    private boolean overClickable = false;

    public boolean isOverClickable() {
        return this.overClickable;
    }

    public void setOverClickable(boolean bl) {
        this.overClickable = bl;
    }

    public void setCoordinates(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.arrow.setCoordinates(n, n2);
    }

    public void draw(Graphic graphic) {
        graphic.getGraphics().setStroke(strokeOne);
        this.arrow.draw(graphic);
        if (Configuration.getInstance().isTimerClick() && this.overClickable) {
            this.drawTimerArc(graphic);
        }
    }

    private void drawTimerArc(Graphic graphic) {
        graphic.setColor(Color.WHITE);
        graphic.getGraphics().setStroke(strokeFive);
        int n = 26;
        graphic.drawArc(this.x - n + 2, this.y - n + 2, n * 2, n * 2, 0, 360);
        graphic.setColor(Color.BLUE);
        graphic.getGraphics().setStroke(strokeThree);
        graphic.drawArc(this.x - n + 2, this.y - n + 2, n * 2, n * 2, 0, this.arc);
        graphic.getGraphics().setStroke(strokeOne);
        graphic.getGraphics().setStroke(strokeOne);
    }

    @Override
    public void changeState(MouseState mouseState) {
        switch (mouseState) {
            case ARROW_HORIZONTAL: {
                this.arrow = this.arrowTheme.getHorizontalArrow();
                break;
            }
            case ARROW_VERTICAL: {
                this.arrow = this.arrowTheme.getVerticalArrow();
                break;
            }
            case ARROW_NE_SW: {
                this.arrow = this.arrowTheme.getDiagonalArrow();
                break;
            }
            case ARROW_NW_SE: {
                this.arrow = this.arrowTheme.getInvertedDiagonalArrow();
                break;
            }
            case CLICK: {
                this.arrow = this.arrowTheme.getClickArrow();
                break;
            }
            case LINK: {
                this.arrow = this.arrowTheme.getLinkArrow();
                break;
            }
            case HELP: {
                this.arrow = this.arrowTheme.getHelpArrow();
                break;
            }
            case MOVE: {
                this.arrow = this.arrowTheme.getMoveArrow();
                break;
            }
            case TEXT: {
                this.arrow = this.arrowTheme.getTextArrow();
                break;
            }
            case WAIT: {
                this.arrow = this.arrowTheme.getWaitArrow();
                break;
            }
            default: {
                this.arrow = this.arrowTheme.getNormalArrow();
            }
        }
    }

    @Override
    public void updateArrowTheme(ArrowTheme arrowTheme) {
        this.arrowTheme = arrowTheme;
        this.changeState(MouseState.NORMAL);
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int n) {
        this.arc = n;
    }
}

