/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.engine;

import br.com.etyllica.core.SharedCore;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.loader.FontLoader;
import br.com.etyllica.core.loader.Loader;
import br.com.etyllica.core.loader.image.ImageLoader;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;

public class SharedEngine {
    private Component component;
    private SharedCore core;
    private Set<Loader> loaders = new HashSet<Loader>();

    public SharedEngine(Component component, int n, int n2) {
        this.component = component;
        this.core = new SharedCore(component, n, n2);
    }

    public void updateSuperEvent(GUIEvent gUIEvent) {
        if (gUIEvent == GUIEvent.ENABLE_FULL_SCREEN) {
            this.core.enableFullScreen();
        } else if (gUIEvent == GUIEvent.DISABLE_FULL_SCREEN) {
            this.core.disableFullScreen();
        } else if (gUIEvent == GUIEvent.REQUEST_FOCUS && !this.component.hasFocus()) {
            this.component.requestFocus();
        }
    }

    public SharedCore getCore() {
        return this.core;
    }

    public void initDefault() {
        this.initLoaders();
        this.core.initDefault();
    }

    public void initLoaders() {
        this.addLoader(ImageLoader.getInstance());
        this.addLoader(FontLoader.getInstance());
        this.core.setLoaders(this.loaders);
    }

    public Set<Loader> getLoaders() {
        return this.loaders;
    }

    public void addLoader(Loader loader) {
        this.loaders.add(loader);
    }

    public void hideCursor() {
        this.core.hideCursor();
    }
}

