/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.input.mouse;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.event.PointerState;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.layer.AnimatedLayer;
import br.com.etyllica.layer.ImageLayer;
import br.com.etyllica.util.RingBuffer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.event.MouseInputListener;

public class Mouse
implements MouseMotionListener,
MouseInputListener,
MouseWheelListener {
    protected int x = 0;
    protected int y = 0;
    protected int z = 0;
    protected int clicks = 0;
    protected boolean doubleClick = false;
    protected boolean dragged = false;
    protected int dragButton = 0;
    protected int dragX = 0;
    protected int dragY = 0;
    private RingBuffer<PointerEvent> events = new RingBuffer<PointerEvent>(PointerEvent.class);

    public Mouse(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.events.setMinimumSlots(4);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int n) {
        this.z = n;
    }

    public void setCoordinates(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    private void addEvent(int n, PointerState pointerState) {
        this.addEvent(n, pointerState, 0);
    }

    private void addEvent(int n, PointerState pointerState, int n2) {
        this.addEvent(n, pointerState, 0, n2);
    }

    private void addEvent(int n, PointerState pointerState, int n2, int n3) {
        MouseButton mouseButton = MouseButton.MOUSE_NONE;
        switch (n) {
            case 1: {
                mouseButton = MouseButton.MOUSE_BUTTON_LEFT;
                break;
            }
            case 2: {
                mouseButton = MouseButton.MOUSE_BUTTON_MIDDLE;
                break;
            }
            case 3: {
                mouseButton = MouseButton.MOUSE_BUTTON_RIGHT;
            }
        }
        this.events.getSlot().set(mouseButton, pointerState, this.x, this.y, n2, n3);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        PointerState pointerState = PointerState.CLICK;
        if (mouseEvent.getClickCount() == 2) {
            pointerState = PointerState.DOUBLE_CLICK;
        } else if (mouseEvent.getClickCount() > 2) {
            pointerState = PointerState.MULTIPLE_CLICK;
        }
        this.setCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.addEvent(mouseEvent.getButton(), pointerState, mouseEvent.getClickCount());
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.addEvent(mouseEvent.getButton(), PointerState.PRESSED);
        this.pressDragButton(mouseEvent.getButton());
        mouseEvent.consume();
    }

    private void pressDragButton(int n) {
        if (this.dragButton == 0) {
            this.dragButton = n;
        }
    }

    private void releaseDragButton(int n) {
        if (this.dragButton == n) {
            this.dragged = false;
            this.dragButton = 0;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.addEvent(mouseEvent.getButton(), PointerState.RELEASED);
        this.releaseDragButton(mouseEvent.getButton());
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.addMouseMoveEvent(this.x, this.y);
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragged) {
            this.dragX = mouseEvent.getX();
            this.dragY = mouseEvent.getY();
            this.dragged = true;
        }
        int n = mouseEvent.getX() - this.dragX;
        int n2 = mouseEvent.getY() - this.dragY;
        this.setCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.addEvent(this.dragButton, PointerState.DRAGGED, n, n2);
        mouseEvent.consume();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        MouseButton mouseButton = MouseButton.MOUSE_WHEEL_DOWN;
        if (mouseWheelEvent.getWheelRotation() < 0) {
            mouseButton = MouseButton.MOUSE_WHEEL_UP;
        }
        this.events.getSlot().set(mouseButton, PointerState.PRESSED, this.x, this.y, mouseWheelEvent.getWheelRotation());
    }

    public boolean sobMouseCircular(ImageLayer imageLayer) {
        float f = imageLayer.getW() / 2;
        return this.sobMouseCircular((float)imageLayer.getX() + f, (float)imageLayer.getY() + f, f);
    }

    public boolean sobMouseCircular(float f, float f2, float f3) {
        return CollisionDetector.colideCirclePoint(f, f2, f3, this.x, this.y);
    }

    public boolean sobMouseIso(ImageLayer imageLayer) {
        return CollisionDetector.colideIsometricPoint(imageLayer, this.x, this.y);
    }

    public boolean sobMouse(float f, float f2, float f3, float f4) {
        if ((float)this.x < f || (float)this.x > f + f3) {
            return false;
        }
        return !((float)this.y < f2) && !((float)this.y > f2 + f4);
    }

    public boolean sobMouse(AnimatedLayer animatedLayer) {
        return this.sobMouse(animatedLayer.getX(), animatedLayer.getY(), animatedLayer.getTileW(), animatedLayer.getTileH());
    }

    public synchronized List<PointerEvent> getEvents() {
        return this.events.getList();
    }

    public void addMouseMoveEvent(int n, int n2) {
        this.events.getSlot().set(MouseButton.MOUSE_NONE, PointerState.MOVE, n, n2);
    }

    public void clearEvents() {
        this.events.pack();
    }

    public void addEvent(PointerEvent pointerEvent) {
        this.events.getSlot().copy(pointerEvent);
    }
}

