/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.button.DefaultButton;
import br.com.etyllica.gui.theme.Theme;
import br.com.etyllica.theme.ThemeManager;

public class CheckBox
extends DefaultButton {
    protected boolean checked = false;

    public CheckBox(int n, int n2) {
        super(n, n2, 22, 22);
    }

    public CheckBox(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    protected void leftClick() {
        this.swapChecked();
    }

    private void swapChecked() {
        this.checked = !this.checked;
    }

    @Override
    public void draw(Graphic graphic) {
        Theme theme = ThemeManager.getInstance().getTheme();
        super.draw(graphic);
        if (this.checked) {
            if (theme.isShadow()) {
                graphic.setColor(theme.getShadowColor());
                graphic.drawLine(this.x + 3, this.y + 3, this.x + this.w / 2 + 1, this.y + this.h / 2 + 1);
                graphic.drawLine(this.x + this.w / 2 + 1, this.y + this.h / 2 + 1, this.x + this.w + 5 + 1, this.y - 5 + 1);
            }
            graphic.setColor(theme.getTextColor());
            graphic.drawLine(this.x + 2, this.y + 2, this.x + this.w / 2, this.y + this.h / 2);
            graphic.drawLine(this.x + this.w / 2, this.y + this.h / 2, this.x + this.w + 5, this.y - 5);
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
    }
}

