/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.button.DefaultButton;
import br.com.etyllica.gui.icon.DownArrow;
import br.com.etyllica.gui.icon.UpArrow;
import br.com.etyllica.gui.panel.ScrollBackground;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class ScrollerPanel
extends View {
    private float lastComponentH = 0.0f;
    private View component;
    private int buttonSize = 20;
    private int scrollAmount = 10;
    private float scrollFactor = 1.0f;
    private float offset = 0.0f;
    private float knobPosition = 0.0f;
    private DefaultButton upButton;
    private DefaultButton downButton;
    private DefaultButton knob;
    private ScrollBackground track;

    public ScrollerPanel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.upButton = new DefaultButton(n3 - this.buttonSize, 0, this.buttonSize, this.buttonSize);
        this.upButton.setLabel(new UpArrow(n + this.buttonSize / 4, n2 + this.buttonSize / 5, (float)(this.buttonSize / 2)));
        this.upButton.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "scrollUp"));
        this.upButton.setVisible(false);
        this.downButton = new DefaultButton(n3 - this.buttonSize, n4 - this.buttonSize, this.buttonSize, this.buttonSize);
        this.downButton.setLabel(new DownArrow(n + this.buttonSize / 4, n2 + this.buttonSize / 5, (float)(this.buttonSize / 2)));
        this.downButton.addAction(GUIEvent.MOUSE_LEFT_BUTTON_UP, new Action(this, "scrollDown"));
        this.downButton.setVisible(false);
        this.track = new ScrollBackground(n3 - this.buttonSize, this.buttonSize, this.buttonSize, n4 - this.buttonSize * 2);
        this.track.setVisible(false);
        this.add(this.track);
        this.add(this.upButton);
        this.add(this.downButton);
    }

    @Override
    public void draw(Graphic graphic) {
        graphic.setColor(Color.WHITE);
        graphic.fillRect(this.x, this.y, this.w, this.h);
        BufferedImage bufferedImage = graphic.getBimg();
        if (this.component != null) {
            if (this.lastComponentH != (float)this.component.getH()) {
                this.resetScroll();
                this.lastComponentH = this.component.getH();
            }
            this.component.draw(graphic);
        }
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        if (this.mouseOver) {
            int n;
            if (pointerEvent.isButtonDown(MouseButton.MOUSE_WHEEL_DOWN)) {
                for (n = 0; n < pointerEvent.getAmount(); ++n) {
                    this.scrollDown();
                }
            }
            if (pointerEvent.isButtonDown(MouseButton.MOUSE_WHEEL_UP)) {
                for (n = pointerEvent.getAmount(); n < 0; ++n) {
                    this.scrollUp();
                }
            }
            if (!this.knob.isMouseOver() || pointerEvent.isButtonDown(MouseButton.MOUSE_BUTTON_LEFT)) {
                // empty if block
            }
        }
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        if (keyEvent.isKeyDown(9)) {
            return GUIEvent.NEXT_COMPONENT;
        }
        return GUIEvent.NONE;
    }

    public void setComponent(View view) {
        this.component = view;
        this.lastComponentH = view.getH();
        this.knobPosition = this.buttonSize;
        this.resetScroll();
    }

    private void resetScroll() {
        boolean bl = false;
        if (this.component.getH() > this.h) {
            this.scrollFactor = (float)this.h / (float)this.component.getH();
            bl = true;
        }
        this.offset = (float)this.scrollAmount * this.scrollFactor;
        this.remove(this.knob);
        this.knob = new DefaultButton(this.w - this.buttonSize, (int)this.knobPosition, this.buttonSize, (int)((float)this.h * this.scrollFactor) - this.buttonSize * 2 + 1);
        this.knob.setVisible(false);
        this.add(this.knob);
        if (bl) {
            this.showButtons();
        }
    }

    private void showButtons() {
        this.track.setVisible(true);
        this.upButton.setVisible(true);
        this.downButton.setVisible(true);
        this.knob.setVisible(true);
    }

    public void scrollDown() {
        float f = this.h - this.component.getH();
        if ((float)this.component.getY() - f > 0.0f) {
            this.component.setOffsetY(-this.scrollAmount);
            this.knobPosition += this.offset;
            this.knob.setY((int)this.knobPosition);
        }
    }

    public void scrollUp() {
        if (this.component.getY() < 0) {
            this.component.setOffsetY(this.scrollAmount);
            this.knobPosition -= this.offset;
            this.knob.setY((int)this.knobPosition);
        }
    }
}

