/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.textfield.TextFieldValidator;
import br.com.etyllica.gui.theme.Theme;
import br.com.etyllica.theme.ThemeManager;
import java.awt.Color;
import java.awt.FontMetrics;

public class TextField
extends View {
    private final int TEXT_BACKSPACE = 8;
    private final int TEXT_TAB = 9;
    private final int TEXT_ENTER = 10;
    private final int TEXT_ESC = 27;
    private final int TEXT_DELETE = 127;
    protected String text = "";
    private int cursor = 0;
    private int fixMark = -1;
    private int minMark = 0;
    private int maxMark = 0;
    private int maxLength = 0;
    private TextFieldValidator validator;
    private boolean shift = false;
    private boolean control = false;

    public TextField(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.clearField();
    }

    public void clearField() {
        this.cursor = 0;
        this.fixMark = -1;
        this.minMark = 0;
        this.maxMark = 0;
        this.text = "";
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        if (keyEvent.getChar() != '\u0000') {
            this.updateChar(keyEvent.getChar());
        }
        GUIEvent gUIEvent = this.updatePressed(keyEvent);
        GUIEvent gUIEvent2 = this.updateReleased(keyEvent);
        this.minMark = this.getMinMark();
        this.maxMark = this.getMaxMark();
        if (gUIEvent != GUIEvent.NONE) {
            return gUIEvent;
        }
        if (gUIEvent2 != GUIEvent.NONE) {
            return gUIEvent2;
        }
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        if (pointerEvent.isButtonDown(MouseButton.MOUSE_BUTTON_LEFT)) {
            if (this.mouseOver) {
                return GUIEvent.GAIN_FOCUS;
            }
            return GUIEvent.LOST_FOCUS;
        }
        if (this.mouseOver) {
            if (!this.onFocus) {
                return GUIEvent.MOUSE_OVER;
            }
            return GUIEvent.MOUSE_OVER_WITH_FOCUS;
        }
        if (!this.mouseOver) {
            return GUIEvent.MOUSE_OUT;
        }
        return GUIEvent.NONE;
    }

    private GUIEvent updatePressed(KeyEvent keyEvent) {
        if (!this.shift) {
            if (keyEvent.isKeyDown(316) || keyEvent.isKeyDown(216)) {
                this.shift = true;
                this.fixMark = this.cursor;
            } else if (keyEvent.isKeyDown(37) || keyEvent.isKeyDown(39)) {
                this.fixMark = -1;
            }
        }
        if (keyEvent.isKeyDown(35)) {
            this.cursor = this.text.length();
        } else if (keyEvent.isKeyDown(36)) {
            this.cursor = 0;
        }
        if (!this.control && (keyEvent.isKeyDown(317) || keyEvent.isKeyDown(217))) {
            this.control = true;
        }
        if (keyEvent.isKeyDown(37)) {
            if (this.control) {
                this.esquerdaControl();
            } else {
                this.esquerdaNormal();
            }
        } else if (keyEvent.isKeyDown(39)) {
            if (this.control) {
                this.direitaControl();
            } else {
                this.direitaNormal();
            }
        }
        if (keyEvent.isKeyDown(9)) {
            return GUIEvent.NEXT_COMPONENT;
        }
        return GUIEvent.NONE;
    }

    private GUIEvent updateReleased(KeyEvent keyEvent) {
        if (this.control && (keyEvent.isKeyDown(317) || keyEvent.isKeyDown(217))) {
            this.control = false;
        }
        if (this.shift && (keyEvent.isKeyDown(316) || keyEvent.isKeyDown(216))) {
            this.shift = false;
        }
        return GUIEvent.NONE;
    }

    @Override
    public void draw(Graphic graphic) {
        int n;
        Theme theme = ThemeManager.getInstance().getTheme();
        String string = this.getText();
        int n2 = theme.getFontSize();
        FontMetrics fontMetrics = graphic.getGraphics().getFontMetrics();
        float f = this.w - fontMetrics.stringWidth(string);
        if (this.onFocus) {
            graphic.setColor(theme.getTextFieldColor());
        } else {
            graphic.setColor(theme.getTextFieldWithoutFocusColor());
        }
        if (this.mouseOver) {
            graphic.setColor(theme.getTextFieldOnMouseColor());
        }
        graphic.drawRect(this.x, this.y, this.w, this.h);
        graphic.setColor(theme.getTextColor());
        if (this.minMark == 0 && this.maxMark == 0) {
            if (f > 0.0f) {
                graphic.drawShadow(this.x, this.y + this.h / 2 + n2 / 2, string);
            } else {
                graphic.drawShadow((float)this.x + f, (float)(this.y + this.h / 2 + n2 / 2), string);
            }
        } else {
            n = fontMetrics.stringWidth(string.substring(0, this.minMark));
            int n3 = fontMetrics.stringWidth(string.substring(this.minMark, this.maxMark));
            graphic.setColor(theme.getSelectionTextColor());
            graphic.fillRect(this.x + n + 2, this.y + 2, n3, this.h - 3);
            graphic.setColor(theme.getTextColor());
            graphic.drawShadow(this.x, this.y + this.h / 2 + n2 / 2, string.substring(0, this.minMark));
            graphic.setColor(theme.getTextSelectedColor());
            graphic.drawShadow(this.x + n, this.y + this.h / 2 + n2 / 2, string.substring(this.minMark, this.maxMark), Color.WHITE);
            graphic.setColor(theme.getTextColor());
            graphic.drawShadow(this.x + n + n3, this.y + this.h / 2 + n2 / 2, string.substring(this.maxMark, string.length()), Color.WHITE);
        }
        if (this.onFocus) {
            n = fontMetrics.stringWidth(string.substring(0, this.cursor));
            n += this.x + 1;
            if (f > 0.0f) {
                graphic.drawLine(n + 1, this.y + 2, n + 1, this.y + this.h - 2);
            } else {
                graphic.drawLine(f + (float)n, (float)(this.y + 2), f + (float)n, (float)(this.y + this.h - 2));
            }
        }
    }

    @Override
    public void update(GUIEvent gUIEvent) {
        switch (gUIEvent) {
            case GAIN_FOCUS: {
                this.onFocus = true;
                break;
            }
            case LOST_FOCUS: {
                this.onFocus = false;
                break;
            }
            case MOUSE_OVER_WITH_FOCUS: 
            case MOUSE_OVER: {
                this.mouseOver = true;
                break;
            }
            case MOUSE_OUT: {
                this.mouseOver = false;
                break;
            }
        }
    }

    public String getText() {
        this.text = this.text.replace("\n", "").replace("\r", "");
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    private void esquerdaNormal() {
        if (this.cursor > 0) {
            --this.cursor;
        }
    }

    private void esquerdaControl() {
        if (this.cursor > 0) {
            int n;
            for (n = this.cursor - 2; n > 0; --n) {
                if (this.text.charAt(n) != ' ') continue;
                ++n;
                break;
            }
            this.cursor = n;
        }
    }

    private void direitaControl() {
        int n;
        for (n = this.cursor + 1; n < this.text.length() && this.text.charAt(n) != ' '; ++n) {
        }
        this.cursor = n;
    }

    private void direitaNormal() {
        if (this.cursor < this.text.length()) {
            ++this.cursor;
        }
    }

    private void apagaBackSpace() {
        if (this.fixMark == -1 && this.cursor > 0) {
            if (this.cursor < this.text.length()) {
                String string = this.text.substring(0, this.cursor - 1);
                String string2 = this.text.substring(this.cursor, this.text.length());
                this.text = string + string2;
            } else if (this.cursor > 0) {
                this.text = this.text.substring(0, this.cursor - 1);
            }
            this.esquerdaNormal();
        } else {
            this.deleteMark();
        }
    }

    private void apagaDelete() {
        if (this.fixMark == -1) {
            if (this.cursor < this.text.length()) {
                String string = this.text.substring(0, this.cursor);
                String string2 = this.text.substring(this.cursor + 1, this.text.length());
                this.text = string + string2;
            }
        } else {
            this.deleteMark();
        }
    }

    private void deleteMark() {
        String string = this.text.substring(0, this.getMinMark());
        String string2 = this.text.substring(this.getMaxMark(), this.text.length());
        this.text = string + string2;
        this.cursor = this.getMinMark();
        this.fixMark = -1;
    }

    private void updateChar(char c) {
        if (c == '\b') {
            this.apagaBackSpace();
        } else if (c == '\u007f') {
            this.apagaDelete();
        } else if (c != '\n' && c != '\t' && c != '\u001b') {
            if (this.maxLength > 0) {
                if (this.text.length() < this.maxLength) {
                    this.addChar(c);
                }
            } else {
                this.addChar(c);
            }
        }
    }

    private void addChar(char c) {
        if (this.cursor < this.text.length()) {
            String string = this.text.substring(0, this.cursor);
            string = string + c;
            String string2 = this.text.substring(this.cursor, this.text.length());
            this.text = string + string2;
        } else {
            this.text = this.text + c;
        }
        this.fixMark = -1;
        ++this.cursor;
    }

    private int getMinMark() {
        if (this.fixMark < 0) {
            return 0;
        }
        if (this.cursor < this.fixMark) {
            return this.cursor;
        }
        return this.fixMark;
    }

    private int getMaxMark() {
        if (this.fixMark < 0) {
            return 0;
        }
        if (this.cursor < this.fixMark) {
            return this.fixMark;
        }
        return this.cursor;
    }
}

