/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.button;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.button.DefaultButton;
import br.com.etyllica.gui.theme.Theme;
import java.awt.Polygon;

public class PolygonalButton
extends DefaultButton {
    protected Polygon polygon = new Polygon();

    public PolygonalButton(int n, int n2) {
        super(n, n2, 0, 0);
        this.polygon.addPoint(n, n2);
    }

    @Override
    public void draw(Graphic graphic) {
        Theme theme = this.getTheme();
        if (!this.mouseOver) {
            graphic.setColor(theme.getButtonColor());
        } else if (this.lastEvent == GUIEvent.MOUSE_LEFT_BUTTON_DOWN) {
            graphic.setColor(theme.getButtonOnClick());
        } else {
            graphic.setColor(theme.getButtonOnMouse());
        }
        graphic.fillPolygon(this.polygon);
        this.drawLabel(graphic);
    }

    public void addPoint(int n, int n2) {
        this.polygon.addPoint(n, n2);
    }

    @Override
    public boolean onMouse(int n, int n2) {
        return this.polygon.contains(n, n2);
    }
}

