/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.selection;

import br.com.etyllica.collision.CollisionDetector;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.core.input.mouse.MouseState;
import br.com.etyllica.core.input.mouse.MouseStateChanger;
import br.com.etyllica.gui.selection.ResizerListener;
import br.com.etyllica.gui.selection.ResizerPoint;
import br.com.etyllica.gui.stroke.DashedStroke;
import br.com.etyllica.layer.GeometricLayer;
import java.awt.BasicStroke;
import java.awt.Color;

public class Resizer {
    private GeometricLayer selected;
    private ResizerPoint selectedArea;
    private ResizerPoint[] points;
    private MouseStateChanger changer;
    private ResizerListener listener;
    private int buttonSize = 30;
    private final DashedStroke dash = new DashedStroke();
    private final BasicStroke resetStroke = new BasicStroke(1.0f);
    private boolean dragged = false;
    private int initialX = 0;
    private int initialY = 0;
    private int initialW = 0;
    private int initialH = 0;
    private int lastIndex = 0;
    private int keyboardSpeed = 1;
    private boolean changed = false;

    public Resizer(MouseStateChanger mouseStateChanger) {
        this.changer = mouseStateChanger;
        this.points = new ResizerPoint[9];
        for (int i = 0; i < 8; ++i) {
            this.points[i] = new ResizerPoint(0, 0, 1, 1);
        }
        this.selectedArea = new ResizerPoint(0, 0, 1, 1);
        this.selectedArea.setState(MouseState.MOVE);
        this.points[8] = this.selectedArea;
        this.points[0].setState(MouseState.ARROW_NW_SE);
        this.points[1].setState(MouseState.ARROW_VERTICAL);
        this.points[2].setState(MouseState.ARROW_NE_SW);
        this.points[3].setState(MouseState.ARROW_HORIZONTAL);
        this.points[4].setState(MouseState.ARROW_HORIZONTAL);
        this.points[5].setState(MouseState.ARROW_NE_SW);
        this.points[6].setState(MouseState.ARROW_VERTICAL);
        this.points[7].setState(MouseState.ARROW_NW_SE);
        this.points[8].setState(MouseState.MOVE);
    }

    public void reselect() {
        this.select(this.selected);
    }

    public void deselect() {
        this.selected = null;
        this.changer.changeMouseState(MouseState.NORMAL);
    }

    public void select(GeometricLayer geometricLayer) {
        if (!this.isSelected()) {
            this.deselect();
        }
        this.selected = geometricLayer;
        this.selectedArea.copy(geometricLayer);
        int n = 0;
        for (int i = 0; i < 9; ++i) {
            int n2 = i % 3;
            int n3 = i / 3;
            if (n2 == 1 && n3 == 1) {
                n = -1;
                continue;
            }
            int n4 = geometricLayer.getX() + n2 * (geometricLayer.getW() / 2) - this.buttonSize / 2;
            int n5 = geometricLayer.getY() + n3 * (geometricLayer.getH() / 2) - this.buttonSize / 2;
            this.points[i + n].setBounds(n4, n5, this.buttonSize, this.buttonSize);
        }
    }

    public void draw(Graphic graphic) {
        if (!this.isSelected()) {
            return;
        }
        graphic.setColor(Color.BLACK);
        graphic.setStroke(this.dash);
        graphic.drawRect(this.selected);
        for (int i = 0; i < 8; ++i) {
            this.points[i].draw(graphic);
        }
        graphic.setStroke(this.resetStroke);
    }

    public void handleEvent(PointerEvent pointerEvent) {
        if (this.selected == null) {
            return;
        }
        int n = pointerEvent.getX();
        int n2 = pointerEvent.getY();
        this.changed = false;
        if (!this.dragged) {
            for (int i = 0; i < 9; ++i) {
                if (!CollisionDetector.colideRectPoint(this.points[i], (double)n, (double)n2)) continue;
                this.lastIndex = i;
                this.changer.changeMouseState(this.points[i].getState());
                this.changed = true;
                this.handleDragEvent(pointerEvent);
                break;
            }
        }
        if (pointerEvent.isButtonUp(MouseButton.MOUSE_BUTTON_LEFT)) {
            this.dragged = false;
        } else if (this.dragged && pointerEvent.isDraggedButton(MouseButton.MOUSE_BUTTON_LEFT)) {
            this.resizeEvent(this.lastIndex, pointerEvent);
            this.notifyListener();
            this.reselect();
        }
        if (!this.changed && pointerEvent.isClicked(MouseButton.MOUSE_BUTTON_LEFT)) {
            this.deselect();
        }
        if (!this.changed) {
            this.changer.changeMouseState(MouseState.NORMAL);
        }
    }

    private void resizeEvent(int n, PointerEvent pointerEvent) {
        switch (n) {
            case 0: {
                this.resizeUp(pointerEvent);
                this.resizeLeft(pointerEvent);
                break;
            }
            case 1: {
                this.resizeUp(pointerEvent);
                break;
            }
            case 2: {
                this.resizeUp(pointerEvent);
                this.resizeRight(pointerEvent);
                break;
            }
            case 3: {
                this.resizeLeft(pointerEvent);
                break;
            }
            case 4: {
                this.resizeRight(pointerEvent);
                break;
            }
            case 5: {
                this.resizeDown(pointerEvent);
                this.resizeLeft(pointerEvent);
                break;
            }
            case 6: {
                this.resizeDown(pointerEvent);
                break;
            }
            case 7: {
                this.resizeDown(pointerEvent);
                this.resizeRight(pointerEvent);
                break;
            }
            default: {
                this.moveSelected(pointerEvent);
            }
        }
    }

    private void handleDragEvent(PointerEvent pointerEvent) {
        if (!this.dragged && pointerEvent.isDraggedButton(MouseButton.MOUSE_BUTTON_LEFT)) {
            this.setInitialValues();
            this.dragged = true;
        }
        if (pointerEvent.isButtonUp(MouseButton.MOUSE_BUTTON_LEFT)) {
            this.dragged = false;
        }
    }

    private void setInitialValues() {
        this.initialX = this.selected.getX();
        this.initialY = this.selected.getY();
        this.initialW = this.selected.getW();
        this.initialH = this.selected.getH();
    }

    private void moveSelected(PointerEvent pointerEvent) {
        this.selected.setX(this.initialX + pointerEvent.getAmountX());
        this.selected.setY(this.initialY + pointerEvent.getAmountY());
    }

    private void resizeUp(PointerEvent pointerEvent) {
        this.selected.setY(this.initialY + pointerEvent.getAmountY());
        this.selected.setH(this.initialH - pointerEvent.getAmountY());
    }

    private void resizeDown(PointerEvent pointerEvent) {
        this.selected.setH(this.initialH + pointerEvent.getAmountY());
    }

    private void resizeLeft(PointerEvent pointerEvent) {
        this.selected.setX(this.initialX + pointerEvent.getAmountX());
        this.selected.setW(this.initialW - pointerEvent.getAmountX());
    }

    private void resizeRight(PointerEvent pointerEvent) {
        this.selected.setW(this.initialW + pointerEvent.getAmountX());
    }

    public boolean isDragged() {
        return this.dragged || this.changed;
    }

    public boolean isSelected() {
        return this.selected != null;
    }

    public GeometricLayer getSelectedLayer() {
        return this.selected;
    }

    public void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isKeyDown(38)) {
            this.selected.setOffsetY(-this.keyboardSpeed);
            this.notifyListener();
            this.reselect();
        } else if (keyEvent.isKeyDown(40)) {
            this.selected.setOffsetY(this.keyboardSpeed);
            this.notifyListener();
            this.reselect();
        }
        if (keyEvent.isKeyDown(37)) {
            this.selected.setOffsetX(-this.keyboardSpeed);
            this.notifyListener();
            this.reselect();
        } else if (keyEvent.isKeyDown(39)) {
            this.selected.setOffsetX(this.keyboardSpeed);
            this.notifyListener();
            this.reselect();
        }
    }

    private void notifyListener() {
        if (this.listener == null) {
            return;
        }
        this.listener.onResize(this.selected.getX(), this.selected.getY(), this.selected.getW(), this.selected.getH());
    }

    public ResizerListener getListener() {
        return this.listener;
    }

    public void setListener(ResizerListener resizerListener) {
        this.listener = resizerListener;
    }
}

