/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.animation.listener.OnAnimationFinishListener;
import br.com.etyllica.animation.listener.OnFrameChangeListener;
import br.com.etyllica.layer.ImageLayer;

public class AnimatedLayer
extends ImageLayer {
    protected int tileW = 0;
    protected int tileH = 0;
    protected int needleX = 0;
    protected int needleY = 0;
    protected boolean once = false;
    protected boolean stopped = true;
    protected boolean animateHorizontally = true;
    protected boolean lockOnce = false;
    private int inc = 1;
    protected int frames = 1;
    protected int currentFrame = 0;
    protected int speed = 500;
    protected long startedAt = 0L;
    protected long changedAt = 0L;
    protected OnAnimationFinishListener onAnimationFinishListener;
    protected OnFrameChangeListener onFrameChangeListener;

    public AnimatedLayer(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public AnimatedLayer(int n, int n2, int n3, int n4, String string) {
        super(n, n2, string);
        this.tileW = n3;
        this.tileH = n4;
    }

    public AnimatedLayer(int n, int n2, int n3, int n4) {
        super(n, n2);
        this.tileW = n3;
        this.tileH = n4;
    }

    public void restartAnimation() {
        this.xImage = this.needleX;
        this.yImage = this.needleY;
        this.currentFrame = 0;
    }

    public void setAnimateHorizontally(boolean bl) {
        this.animateHorizontally = bl;
    }

    public int getTileW() {
        return this.tileW;
    }

    public int getTileH() {
        return this.tileH;
    }

    public void setTileW(int n) {
        this.tileW = n;
    }

    public void setTileH(int n) {
        this.tileH = n;
    }

    public void setTileCoordinates(int n, int n2) {
        this.setTileW(n);
        this.setTileH(n2);
    }

    public void animateWithFrame(int n) {
        this.setFrame(n);
        if (n == this.frames - 1) {
            this.notifyAnimationFinishListener(0L);
        }
    }

    public void animate(long l) {
        if (this.stopped) {
            this.startedAt = l;
            this.changedAt = l;
            this.stopped = false;
            this.restartAnimation();
        }
        if (l >= this.changedAt + (long)this.speed) {
            this.changedAt = l;
            boolean bl = this.nextFrame();
            this.notifyFrameChangeListener(l);
            if (!bl) {
                this.notifyAnimationFinishListener(l);
            }
        }
    }

    protected void notifyAnimationFinishListener(long l) {
        if (this.onAnimationFinishListener != null) {
            this.onAnimationFinishListener.onAnimationFinish(l);
        }
    }

    private void notifyFrameChangeListener(long l) {
        if (this.onFrameChangeListener != null) {
            this.onFrameChangeListener.onFrameChange(l);
        }
    }

    public void animate() {
        this.nextFrame();
        this.stopped = false;
    }

    public void stopAnimation() {
        this.stopped = true;
    }

    public void animaOnce() {
        this.visible = true;
        this.lockOnce = false;
        this.once = true;
        this.stopped = false;
        this.currentFrame = 0;
        if (this.animateHorizontally) {
            this.xImage = 0;
        } else {
            this.yImage = 0;
        }
    }

    public boolean nextFrame() {
        boolean bl = true;
        if (this.currentFrame < this.frames - 1 && this.currentFrame >= 0) {
            this.currentFrame += this.inc;
        } else {
            if (this.once) {
                this.visible = false;
                this.lockOnce = true;
            } else {
                this.currentFrame = 0;
            }
            bl = false;
        }
        if (!this.stopped) {
            this.setFrame(this.currentFrame);
        }
        return bl;
    }

    private void setFrame(int n) {
        if (this.animateHorizontally) {
            this.setXImage(this.needleX + this.tileW * n);
        } else {
            this.setYImage(this.needleY + this.tileH * n);
        }
    }

    @Override
    public int utilWidth() {
        return this.tileW;
    }

    @Override
    public int utilHeight() {
        return this.tileH;
    }

    public void setStopped(boolean bl) {
        this.stopped = bl;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setFrames(int n) {
        this.frames = n;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public boolean getAnimateHorizontally() {
        return this.animateHorizontally;
    }

    public void setLockOnce(boolean bl) {
        this.lockOnce = bl;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public int getNeedleX() {
        return this.needleX;
    }

    public void setNeedleX(int n) {
        this.needleX = n;
    }

    public int getNeedleY() {
        return this.needleY;
    }

    public void setNeedleY(int n) {
        this.needleY = n;
    }

    public OnAnimationFinishListener getListener() {
        return this.onAnimationFinishListener;
    }

    public void setOnAnimationFinishListener(OnAnimationFinishListener onAnimationFinishListener) {
        this.onAnimationFinishListener = onAnimationFinishListener;
    }

    public void setOnFrameChangeListener(OnFrameChangeListener onFrameChangeListener) {
        this.onFrameChangeListener = onFrameChangeListener;
    }
}

