/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.linear.graph;

import br.com.etyllica.linear.Point2D;
import br.com.etyllica.linear.graph.Edge;
import br.com.etyllica.linear.graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericComplexGraph<E extends Edge> {
    protected Set<Node> nodes = new LinkedHashSet<Node>();
    protected Map<Node, List<E>> edges = new HashMap<Node, List<E>>();

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node> set) {
        this.nodes = set;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addNode(Point2D point2D) {
        this.nodes.add(new Node(point2D.getX(), point2D.getY()));
    }

    public Map<Node, List<E>> getAllEdges() {
        return this.edges;
    }

    public List<E> getEdges(Node node) {
        if (this.edges.containsKey(node)) {
            return this.edges.get(node);
        }
        return new ArrayList();
    }

    public void addEdge(E e) {
        this.addNodesFromEdge((Edge)e);
        Node node = ((Edge)e).getOrigin();
        if (!this.edges.containsKey(node)) {
            this.edges.put(node, new ArrayList());
        }
        this.edges.get(node).add(0, e);
    }

    private void addNodesFromEdge(Edge edge) {
        Node node;
        Node node2 = edge.getOrigin();
        if (!this.nodes.contains(node2)) {
            this.nodes.add(node2);
        }
        if (!this.nodes.contains(node = edge.getDestination())) {
            this.nodes.add(node);
        }
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
    }
}

