/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.linear.vector;

public class Vec3D {
    public double[] v = new double[3];
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;

    public Vec3D() {
        this(0.0, 0.0, 0.0);
    }

    public Vec3D(double d, double d2, double d3) {
        this.v[0] = d;
        this.v[1] = d2;
        this.v[2] = d3;
    }

    public void copy(Vec3D vec3D) {
        this.v[0] = vec3D.v[0];
        this.v[1] = vec3D.v[1];
        this.v[2] = vec3D.v[2];
    }

    public void copy(double d, double d2, double d3) {
        this.v[0] = d;
        this.v[1] = d2;
        this.v[2] = d3;
    }

    public static Vec3D add(Vec3D vec3D, Vec3D vec3D2) {
        double d = vec3D.v[0] + vec3D2.v[0];
        double d2 = vec3D.v[1] + vec3D2.v[1];
        double d3 = vec3D.v[2] + vec3D2.v[2];
        Vec3D vec3D3 = new Vec3D(d, d2, d3);
        return vec3D3;
    }

    public static Vec3D sub(Vec3D vec3D, Vec3D vec3D2) {
        double d = vec3D.v[0] - vec3D2.v[0];
        double d2 = vec3D.v[1] - vec3D2.v[1];
        double d3 = vec3D.v[2] - vec3D2.v[2];
        Vec3D vec3D3 = new Vec3D(d, d2, d3);
        return vec3D3;
    }

    public static Vec3D mult(Vec3D vec3D, Vec3D vec3D2) {
        double d = vec3D.v[0] * vec3D2.v[0];
        double d2 = vec3D.v[1] * vec3D2.v[1];
        double d3 = vec3D.v[2] * vec3D2.v[2];
        Vec3D vec3D3 = new Vec3D(d, d2, d3);
        return vec3D3;
    }

    public static Vec3D addScalar(Vec3D vec3D, double d) {
        double d2 = vec3D.v[0] + d;
        double d3 = vec3D.v[1] + d;
        double d4 = vec3D.v[2] + d;
        Vec3D vec3D2 = new Vec3D(d2, d3, d4);
        return vec3D2;
    }

    public static Vec3D multScalar(Vec3D vec3D, double d) {
        double d2 = vec3D.v[0] * d;
        double d3 = vec3D.v[1] * d;
        double d4 = vec3D.v[2] * d;
        Vec3D vec3D2 = new Vec3D(d2, d3, d4);
        return vec3D2;
    }

    public static double dot(Vec3D vec3D, Vec3D vec3D2) {
        return vec3D.v[0] * vec3D2.v[0] + vec3D.v[1] * vec3D2.v[1] + vec3D.v[2] * vec3D2.v[2];
    }

    public static Vec3D cross(Vec3D vec3D, Vec3D vec3D2) {
        return new Vec3D(vec3D.v[1] * vec3D2.v[2] - vec3D.v[2] * vec3D2.v[1], vec3D.v[2] * vec3D2.v[0] - vec3D.v[0] * vec3D2.v[2], vec3D.v[0] * vec3D2.v[1] - vec3D.v[1] * vec3D2.v[0]);
    }

    public static void cross(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        vec3D3.v[0] = vec3D.v[1] * vec3D2.v[2] - vec3D.v[2] * vec3D2.v[1];
        vec3D3.v[1] = vec3D.v[2] * vec3D2.v[0] - vec3D.v[0] * vec3D2.v[2];
        vec3D3.v[2] = vec3D.v[0] * vec3D2.v[1] - vec3D.v[1] * vec3D2.v[0];
    }

    public double normalize() {
        double d = Math.sqrt(this.square());
        if (d > 0.0) {
            this.v[0] = this.v[0] / d;
            this.v[1] = this.v[1] / d;
            this.v[2] = this.v[2] / d;
        }
        return d;
    }

    public double length() {
        return Math.sqrt(this.square());
    }

    public static Vec3D inverse(Vec3D vec3D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (vec3D.v[0] != 0.0) {
            d = 1.0 / vec3D.v[0];
        }
        if (vec3D.v[1] != 0.0) {
            d2 = 1.0 / vec3D.v[1];
        }
        if (vec3D.v[2] != 0.0) {
            d3 = 1.0 / vec3D.v[2];
        }
        return new Vec3D(d, d2, d3);
    }

    public double square() {
        return this.v[0] * this.v[0] + this.v[1] * this.v[1] + this.v[2] * this.v[2];
    }

    public int minIndex() {
        return this.v[0] < this.v[1] ? (this.v[0] < this.v[2] ? 0 : 2) : (this.v[1] < this.v[2] ? 1 : 2);
    }

    public void setX(double d) {
        this.v[0] = d;
    }

    public void setY(double d) {
        this.v[1] = d;
    }

    public void setZ(double d) {
        this.v[2] = d;
    }

    public double getX() {
        return this.v[0];
    }

    public double getY() {
        return this.v[1];
    }

    public double getZ() {
        return this.v[2];
    }
}

