/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.particle;

import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.layer.Layer;
import br.com.etyllica.particle.Particle;
import java.util.ArrayList;
import java.util.List;

public abstract class Emitter
extends Layer
implements Updatable {
    protected List<Particle> particles = new ArrayList<Particle>();
    private int maxParticles = 15;
    private long lastUpdate = 0L;
    private long lastParticleUpdate = 0L;
    private long delay = 40L;
    private long particleDelay = 1500L;

    public Emitter(int n, int n2) {
        super(n, n2);
    }

    public Emitter(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public void update(long l) {
        long l2 = l - this.lastUpdate;
        if (l - this.lastParticleUpdate >= this.particleDelay) {
            if (this.particles.size() >= this.maxParticles) {
                this.particles.remove(0);
            }
            this.particles.add(this.createParticle(l));
            this.lastParticleUpdate = l;
        }
        if (l2 >= this.delay) {
            for (Particle particle : this.particles) {
                particle.update(l);
            }
            this.lastUpdate = l;
        }
    }

    protected abstract Particle createParticle(long var1);

    @Override
    public void draw(Graphic graphic) {
        this.drawEmitter(graphic);
        this.drawParticles(graphic);
    }

    public void drawParticles(Graphic graphic) {
        for (Particle particle : this.particles) {
            particle.draw(graphic);
        }
    }

    public abstract void drawEmitter(Graphic var1);
}

