/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.theme;

import br.com.etyllica.gui.theme.Theme;
import br.com.etyllica.theme.EtyllicTheme;
import br.com.etyllica.theme.mouse.ArrowTheme;
import br.com.etyllica.theme.mouse.ArrowThemeListener;
import br.com.etyllica.theme.mouse.ThemeListener;

public class ThemeManager {
    private Theme theme = new EtyllicTheme();
    private ArrowTheme arrowTheme;
    private ThemeListener themeListener = null;
    private ArrowThemeListener arrowThemeListener = null;
    private static ThemeManager instance = null;

    public static ThemeManager getInstance() {
        if (instance == null) {
            instance = new ThemeManager();
        }
        return instance;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.notifyThemeListener();
    }

    public ArrowTheme getArrowTheme() {
        return this.arrowTheme;
    }

    public void setArrowTheme(ArrowTheme arrowTheme) {
        this.arrowTheme = arrowTheme;
        this.notifyArrowListener();
    }

    private void notifyArrowListener() {
        if (this.arrowThemeListener == null) {
            return;
        }
        this.arrowThemeListener.updateArrowTheme(this.arrowTheme);
    }

    public void setThemeListener(ThemeListener themeListener) {
        this.themeListener = themeListener;
    }

    private void notifyThemeListener() {
        if (this.themeListener == null) {
            return;
        }
        this.themeListener.updateTheme(this.theme);
    }

    public ThemeListener getThemeListener() {
        return this.themeListener;
    }

    public void setArrowThemeListener(ArrowThemeListener arrowThemeListener) {
        this.arrowThemeListener = arrowThemeListener;
    }
}

