/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.theme.dalt.arrow;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.theme.Theme;
import br.com.etyllica.theme.ThemeManager;
import br.com.etyllica.theme.mouse.MouseArrow;
import br.com.etyllica.theme.mouse.PolygonalArrow;
import java.awt.Color;

public class NormalArrow
extends PolygonalArrow
implements MouseArrow {
    protected int cursorX = 0;
    protected int cursorY = 0;
    protected int size = 24;
    private Color color = null;
    private Color borderColor = null;

    public NormalArrow(int n) {
        this.size = n;
        this.defPoints();
    }

    protected void defPoints() {
        this.addPoint(0, 0);
        this.addPoint(0, (int)((double)this.size * 0.8));
        this.addPoint((int)((double)this.size * 0.18), (int)((double)this.size * 0.62));
        this.addPoint((int)((double)this.size * 0.28), (int)((double)this.size * 0.88));
        this.addPoint((int)((double)this.size * 0.42), (int)((double)this.size * 0.82));
        this.addPoint((int)((double)this.size * 0.3), (int)((double)this.size * 0.55));
        this.addPoint((int)((double)this.size * 0.49), (int)((double)this.size * 0.57));
    }

    @Override
    public void setCoordinates(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        this.polygon.translate(n3 - this.cursorX, n4 - this.cursorY);
        this.cursorX = n3;
        this.cursorY = n4;
    }

    @Override
    public void draw(Graphic graphic) {
        Theme theme = ThemeManager.getInstance().getTheme();
        if (this.color == null) {
            graphic.setColor(theme.getMouseArrowColor());
        } else {
            graphic.setColor(this.color);
        }
        graphic.fillPolygon(this.polygon);
        if (this.borderColor == null) {
            graphic.setColor(theme.getMouseArrowBorderColor());
        } else {
            graphic.setColor(this.borderColor);
        }
        graphic.drawPolygon(this.polygon);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }
}

