/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util;

import java.util.ArrayList;
import java.util.List;

public class RingBuffer<T> {
    private List<T> copyList;
    private List<T> list;
    private Class<T> cls;
    private int usedSlot = 0;
    private int minimumSlots = 0;

    public RingBuffer(Class<T> clazz) {
        this.cls = clazz;
        this.list = new ArrayList<T>();
        this.copyList = new ArrayList<T>();
    }

    public T getSlot() {
        T t;
        if (this.usedSlot < this.list.size()) {
            t = this.list.get(this.usedSlot);
        } else {
            t = this.create();
            this.list.add(t);
        }
        ++this.usedSlot;
        return t;
    }

    public void pack() {
        int n = this.usedSlot + 1;
        if (this.list.size() > n && this.list.size() > this.minimumSlots) {
            this.removeLast(this.list.size() - this.usedSlot);
        }
        this.usedSlot = 0;
    }

    private void removeLast(int n) {
        if (n > this.list.size()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.list.remove(0);
        }
    }

    private T create() {
        try {
            return this.cls.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public List<T> getList() {
        this.copyList.clear();
        this.copyList.addAll(this.list.subList(0, this.usedSlot));
        return this.copyList;
    }

    public int getMinimumSlots() {
        return this.minimumSlots;
    }

    public void setMinimumSlots(int n) {
        this.minimumSlots = n;
    }

    public int size() {
        return this.list.size();
    }
}

