/*
 * Decompiled with CFR 0.152.
 */
package br.com.tide.arcade.player;

import br.com.tide.ActivePlayer;
import br.com.tide.PlayerState;
import br.com.tide.arcade.player.ArcadePlayerListener;
import br.com.tide.input.ControllerListener;

public class ArcadePlayer
extends ActivePlayer
implements ControllerListener {
    protected ArcadePlayerListener listener;

    public ArcadePlayer() {
    }

    public ArcadePlayer(ArcadePlayerListener arcadePlayerListener) {
        this.listener = arcadePlayerListener;
    }

    public void walkLeft() {
        this.x -= this.currentSpeed;
        this.listener.onWalkLeft(this);
        this.states.add(PlayerState.WALK_LEFT);
    }

    public void stopWalkLeft() {
        this.states.remove((Object)PlayerState.WALK_LEFT);
        this.listener.onStopWalkLeft(this);
    }

    public void walkRight() {
        this.x += this.currentSpeed;
        this.listener.onWalkRight(this);
        this.states.add(PlayerState.WALK_RIGHT);
    }

    public void stopWalkRight() {
        this.states.remove((Object)PlayerState.WALK_RIGHT);
        this.listener.onStopWalkRight(this);
    }

    public void walkUp() {
        this.y -= this.currentSpeed;
        this.listener.onWalkUp(this);
        this.states.add(PlayerState.WALK_UP);
    }

    public void stopWalkUp() {
        this.states.remove((Object)PlayerState.WALK_UP);
        this.listener.onStopWalkUp(this);
    }

    public void walkDown() {
        this.y += this.currentSpeed;
        this.listener.onWalkDown(this);
        this.states.add(PlayerState.WALK_DOWN);
    }

    public void stopWalkDown() {
        this.states.remove((Object)PlayerState.WALK_DOWN);
        this.listener.onStopWalkDown(this);
    }

    public void stopWalk() {
        this.states.remove((Object)PlayerState.WALK_UP);
        this.states.remove((Object)PlayerState.WALK_DOWN);
        this.states.remove((Object)PlayerState.WALK_LEFT);
        this.states.remove((Object)PlayerState.WALK_RIGHT);
    }

    @Override
    public void attack() {
        super.attack();
        this.listener.onAttack(this);
    }

    public boolean isWalking() {
        return this.states.contains((Object)PlayerState.WALK_RIGHT) || this.states.contains((Object)PlayerState.WALK_LEFT) || this.states.contains((Object)PlayerState.WALK_UP) || this.states.contains((Object)PlayerState.WALK_DOWN);
    }

    @Override
    public void onUpButtonPressed() {
        this.walkUp();
    }

    @Override
    public void onUpButtonReleased() {
        this.stopWalkUp();
    }

    @Override
    public void onDownButtonPressed() {
        this.walkDown();
    }

    @Override
    public void onDownButtonReleased() {
        this.stopWalkDown();
    }

    @Override
    public void onRightButtonPressed() {
        this.walkRight();
    }

    @Override
    public void onRightButtonReleased() {
        this.stopWalkRight();
    }

    @Override
    public void onLeftButtonPressed() {
        this.walkLeft();
    }

    @Override
    public void onLeftButtonReleased() {
        this.stopWalkLeft();
    }

    @Override
    public void onAButtonPressed() {
        this.attack();
    }

    @Override
    public void onAButtonReleased() {
        this.stopAttack();
        this.stand();
    }

    @Override
    public void onBButtonPressed() {
        this.specialAttack();
    }

    @Override
    public void onBButtonReleased() {
        this.onStopSpecialAttack();
        this.stand();
    }

    @Override
    public void onCButtonPressed() {
    }

    @Override
    public void onCButtonReleased() {
    }

    @Override
    public void onXButtonPressed() {
    }

    @Override
    public void onXButtonReleased() {
    }

    @Override
    public void onYButtonPressed() {
    }

    @Override
    public void onYButtonReleased() {
    }

    @Override
    public void onZButtonPressed() {
    }

    @Override
    public void onZButtonReleased() {
    }
}

