# Amxx Channel


Serves as the [package_control_channel](https://github.com/wbond/package_control_channel) but hosts
a complete channel generated by the
[channelmanager](https://github.com/evandrocoan/SublimeChannelManager) for the
[AmxxSimpleIde](https://github.com/evandrocoan/AmxxSimpleIde).

These files are automatically generated by the `Channel Manager`. So any modification to these files
will be overridden when the `Channel Manager` generates a new version of these files based on the
[AmxxSimpleIde](https://github.com/evandrocoan/AmxxSimpleIde) `.gitmodules` file. Any new
information required to be used here need to be parsed from the `.gitmodules` by the `Sublime
Channel Manager`.

After installing this, you need to run its installer if you want to install the channel packages, or
the uninstaller, if you want to uninstall everything, after or before installing the channel
packages.

You can find they on the menu `Preferences -> Packages Settings -> Amxx Channel -> Run Stable
Installation` or the `Run Uninstallation` if want to uninstall it.


## Installation

### By Package Control

1. Download & Install **`Sublime Text 3`** (https://www.sublimetext.com/3)
1. Go to the menu **`Tools -> Install Package Control`**, then,
    wait few seconds until the installation finishes up
1. Now,
    Go to the menu **`Preferences -> Package Control`**
1. Type **`Add Channel`** on the opened quick panel and press <kbd>Enter</kbd>
1. Then,
    input the following address and press <kbd>Enter</kbd>
    ```
    https://raw.githubusercontent.com/evandrocoan/StudioChannel/master/channel.json
    ```
1. Go to the menu **`Tools -> Command Palette...
    (Ctrl+Shift+P)`**
1. Type **`Preferences:
    Package Control Settings – User`** on the opened quick panel and press <kbd>Enter</kbd>
1. Then,
    find the following setting on your **`Package Control.sublime-settings`** file:
    ```js
    "channels":
    [
        "https://packagecontrol.io/channel_v3.json",
        "https://raw.githubusercontent.com/evandrocoan/StudioChannel/master/channel.json",
    ],
    ```
1. And,
    change it to the following, i.e.,
    put the **`https://raw.githubusercontent...`** line as first:
    ```js
    "channels":
    [
        "https://raw.githubusercontent.com/evandrocoan/StudioChannel/master/channel.json",
        "https://packagecontrol.io/channel_v3.json",
    ],
    ```
    * The **`https://raw.githubusercontent...`** line must to be added before the **`https://packagecontrol.io...`** one, otherwise,
      you will not install this forked version of the package,
      but the original available on the Package Control default channel **`https://packagecontrol.io...`**
1. Now,
    go to the menu **`Preferences -> Package Control`**
1. Type **`Install Package`** on the opened quick panel and press <kbd>Enter</kbd>
1. Then,
    search for **`AmxxChannel`** and press <kbd>Enter</kbd>

See also:

1. [ITE - Integrated Toolset Environment](https://github.com/evandrocoan/ITE)
1. [Package control docs](https://packagecontrol.io/docs/usage) for details.


## Channel Manager

This package responsible to install the channel packages, by installing the `PackagesManager` and
uninstalling `Package Control`, then installing the `Channel Manager` and calling it to install the
Channel packages.

Also, will be responsible by the removal of `AmxxSimpleIde`, by calling the Channel Manager
uninstaller, then installing back `Package Control` and removing `PackagesManager`.


Related threads:

1. https://packagecontrol.io/docs#Package_Developers DOCS - End Users
1. [Forum$29121](https://forum.sublimetext.com/t/how-to-create-the-channel-v3-json-from-the-repository-package-control-channel/29121) How to create the channel_v3.json from the repository package_control_channel?


