# colors chosen by according to http://seaborn.pydata.org/tutorial/color_palettes.html
# https://github.com/mwaskom/seaborn/blob/master/seaborn/palettes.py
# as proposed in https://github.com/JuliaPlots/Plots.jl/issues/2510

loadcolorscheme(:seaborn_bright, [
RGB{Float64}(0.00784313725490196,0.24313725490196078,1.0),
RGB{Float64}(1.0,0.48627450980392156,0.0),
RGB{Float64}(0.10196078431372549,0.788235294117647,0.2196078431372549),
RGB{Float64}(0.9098039215686274,0.0,0.043137254901960784),
RGB{Float64}(0.5450980392156862,0.16862745098039217,0.8862745098039215),
RGB{Float64}(0.6235294117647059,0.2823529411764706,0.0),
RGB{Float64}(0.9450980392156862,0.2980392156862745,0.7568627450980392),
RGB{Float64}(0.6392156862745098,0.6392156862745098,0.6392156862745098),
RGB{Float64}(1.0,0.7686274509803922,0.0),
RGB{Float64}(0.0,0.8431372549019608,1.0),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_bright6, [
RGB{Float64}(0.00784313725490196,0.24313725490196078,1.0),
RGB{Float64}(0.10196078431372549,0.788235294117647,0.2196078431372549),
RGB{Float64}(0.9098039215686274,0.0,0.043137254901960784),
RGB{Float64}(0.5450980392156862,0.16862745098039217,0.8862745098039215),
RGB{Float64}(1.0,0.7686274509803922,0.0),
RGB{Float64}(0.0,0.8431372549019608,1.0),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_deep, [
   RGB{Float64}(0.2980392156862745,0.4470588235294118,0.6901960784313725),
   RGB{Float64}(0.8666666666666667,0.5176470588235295,0.3215686274509804),
   RGB{Float64}(0.3333333333333333,0.6588235294117647,0.40784313725490196),
   RGB{Float64}(0.7686274509803922,0.3058823529411765,0.3215686274509804),
   RGB{Float64}(0.5058823529411764,0.4470588235294118,0.7019607843137254),
   RGB{Float64}(0.5764705882352941,0.47058823529411764,0.3764705882352941),
   RGB{Float64}(0.8549019607843137,0.5450980392156862,0.7647058823529411),
   RGB{Float64}(0.5490196078431373,0.5490196078431373,0.5490196078431373),
   RGB{Float64}(0.8,0.7254901960784313,0.4549019607843137),
   RGB{Float64}(0.39215686274509803,0.7098039215686275,0.803921568627451),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_deep6, [
   RGB{Float64}(0.2980392156862745,0.4470588235294118,0.6901960784313725),
   RGB{Float64}(0.3333333333333333,0.6588235294117647,0.40784313725490196),
   RGB{Float64}(0.7686274509803922,0.3058823529411765,0.3215686274509804),
   RGB{Float64}(0.5058823529411764,0.4470588235294118,0.7019607843137254),
   RGB{Float64}(0.8,0.7254901960784313,0.4549019607843137),
   RGB{Float64}(0.39215686274509803,0.7098039215686275,0.803921568627451),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_dark, [
RGB{Float64}(0.0,0.10980392156862745,0.4980392156862745),
RGB{Float64}(0.6941176470588235,0.25098039215686274,0.050980392156862744),
RGB{Float64}(0.07058823529411765,0.44313725490196076,0.10980392156862745),
RGB{Float64}(0.5490196078431373,0.03137254901960784,0.0),
RGB{Float64}(0.34901960784313724,0.11764705882352941,0.44313725490196076),
RGB{Float64}(0.34901960784313724,0.1843137254901961,0.050980392156862744),
RGB{Float64}(0.6352941176470588,0.20784313725490197,0.5098039215686274),
RGB{Float64}(0.23529411764705882,0.23529411764705882,0.23529411764705882),
RGB{Float64}(0.7215686274509804,0.5215686274509804,0.0392156862745098),
RGB{Float64}(0.0,0.38823529411764707,0.4549019607843137),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_dark6, [
RGB{Float64}(0.0,0.10980392156862745,0.4980392156862745),
RGB{Float64}(0.07058823529411765,0.44313725490196076,0.10980392156862745),
RGB{Float64}(0.5490196078431373,0.03137254901960784,0.0),
RGB{Float64}(0.34901960784313724,0.11764705882352941,0.44313725490196076),
RGB{Float64}(0.7215686274509804,0.5215686274509804,0.0392156862745098),
RGB{Float64}(0.0,0.38823529411764707,0.4549019607843137),
], "seaborn", "sequential")

loadcolorscheme(:seaborn_colorblind, [
RGB{Float64}(0.00392156862745098,0.45098039215686275,0.6980392156862745),
RGB{Float64}(0.8705882352941177,0.5607843137254902,0.0196078431372549),
RGB{Float64}(0.00784313725490196,0.6196078431372549,0.45098039215686275),
RGB{Float64}(0.8352941176470589,0.3686274509803922,0.0),
RGB{Float64}(0.8,0.47058823529411764,0.7372549019607844),
RGB{Float64}(0.792156862745098,0.5686274509803921,0.3803921568627451),
RGB{Float64}(0.984313725490196,0.6862745098039216,0.8941176470588236),
RGB{Float64}(0.5803921568627451,0.5803921568627451,0.5803921568627451),
RGB{Float64}(0.9254901960784314,0.8823529411764706,0.2),
RGB{Float64}(0.33725490196078434,0.7058823529411765,0.9137254901960784),
], "seaborn", "sequential, cvd friendly color blind friendly")

loadcolorscheme(:seaborn_colorblind6, [
RGB{Float64}(0.00392156862745098,0.45098039215686275,0.6980392156862745),
RGB{Float64}(0.00784313725490196,0.6196078431372549,0.45098039215686275),
RGB{Float64}(0.8352941176470589,0.3686274509803922,0.0),
RGB{Float64}(0.8,0.47058823529411764,0.7372549019607844),
RGB{Float64}(0.9254901960784314,0.8823529411764706,0.2),
RGB{Float64}(0.33725490196078434,0.7058823529411765,0.9137254901960784),
], "seaborn", "sequential, cvd friendly color blind friendly")

loadcolorscheme(:seaborn_muted, [
   RGB{Float64}(0.2823529411764706,0.47058823529411764,0.8156862745098039),
   RGB{Float64}(0.9333333333333333,0.5215686274509804,0.2901960784313726),
   RGB{Float64}(0.41568627450980394,0.8,0.39215686274509803),
   RGB{Float64}(0.8392156862745098,0.37254901960784315,0.37254901960784315),
   RGB{Float64}(0.5843137254901961,0.4235294117647059,0.7058823529411765),
   RGB{Float64}(0.5490196078431373,0.3803921568627451,0.23529411764705882),
   RGB{Float64}(0.8627450980392157,0.49411764705882355,0.7529411764705882),
   RGB{Float64}(0.4745098039215686,0.4745098039215686,0.4745098039215686),
   RGB{Float64}(0.8352941176470589,0.7333333333333333,0.403921568627451),
   RGB{Float64}(0.5098039215686274,0.7764705882352941,0.8862745098039215),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_muted6, [
   RGB{Float64}(0.2823529411764706,0.47058823529411764,0.8156862745098039),
   RGB{Float64}(0.41568627450980394,0.8,0.39215686274509803),
   RGB{Float64}(0.8392156862745098,0.37254901960784315,0.37254901960784315),
   RGB{Float64}(0.5843137254901961,0.4235294117647059,0.7058823529411765),
   RGB{Float64}(0.8352941176470589,0.7333333333333333,0.403921568627451),
   RGB{Float64}(0.5098039215686274,0.7764705882352941,0.8862745098039215),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_pastel, [
   RGB{Float64}(0.6313725490196078,0.788235294117647,0.9568627450980393),
   RGB{Float64}(1.0,0.7058823529411765,0.5098039215686274),
   RGB{Float64}(0.5529411764705883,0.8980392156862745,0.6313725490196078),
   RGB{Float64}(1.0,0.6235294117647059,0.6078431372549019),
   RGB{Float64}(0.8156862745098039,0.7333333333333333,1.0),
   RGB{Float64}(0.8705882352941177,0.7333333333333333,0.6078431372549019),
   RGB{Float64}(0.9803921568627451,0.6901960784313725,0.8941176470588236),
   RGB{Float64}(0.8117647058823529,0.8117647058823529,0.8117647058823529),
   RGB{Float64}(1.0,0.996078431372549,0.6392156862745098),
   RGB{Float64}(0.7254901960784313,0.9490196078431372,0.9411764705882353),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_pastel6, [
   RGB{Float64}(0.6313725490196078,0.788235294117647,0.9568627450980393),
   RGB{Float64}(0.5529411764705883,0.8980392156862745,0.6313725490196078),
   RGB{Float64}(1.0,0.6235294117647059,0.6078431372549019),
   RGB{Float64}(0.8156862745098039,0.7333333333333333,1.0),
   RGB{Float64}(1.0,0.996078431372549,0.6392156862745098),
   RGB{Float64}(0.7254901960784313,0.9490196078431372,0.9411764705882353),
  ], "seaborn", "sequential")

loadcolorscheme(:seaborn_rocket_gradient, [
      RGB{Float64}(0.01060815, 0.01808215, 0.10018654),
                                   RGB{Float64}(0.01428972, 0.02048237, 0.10374486),
                                   RGB{Float64}(0.01831941, 0.0229766, 0.10738511),
                                   RGB{Float64}(0.02275049, 0.02554464, 0.11108639),
                                   RGB{Float64}(0.02759119, 0.02818316, 0.11483751),
                                   RGB{Float64}(0.03285175, 0.03088792, 0.11863035),
                                   RGB{Float64}(0.03853466, 0.03365771, 0.12245873),
                                   RGB{Float64}(0.04447016, 0.03648425, 0.12631831),
                                   RGB{Float64}(0.05032105, 0.03936808, 0.13020508),
                                   RGB{Float64}(0.05611171, 0.04224835, 0.13411624),
                                   RGB{Float64}(0.0618531, 0.04504866, 0.13804929),
                                   RGB{Float64}(0.06755457, 0.04778179, 0.14200206),
                                   RGB{Float64}(0.0732236, 0.05045047, 0.14597263),
                                   RGB{Float64}(0.0788708, 0.05305461, 0.14995981),
                                   RGB{Float64}(0.08450105, 0.05559631, 0.15396203),
                                   RGB{Float64}(0.09011319, 0.05808059, 0.15797687),
                                   RGB{Float64}(0.09572396, 0.06050127, 0.16200507),
                                   RGB{Float64}(0.10132312, 0.06286782, 0.16604287),
                                   RGB{Float64}(0.10692823, 0.06517224, 0.17009175),
                                   RGB{Float64}(0.1125315, 0.06742194, 0.17414848),
                                   RGB{Float64}(0.11813947, 0.06961499, 0.17821272),
                                   RGB{Float64}(0.12375803, 0.07174938, 0.18228425),
                                   RGB{Float64}(0.12938228, 0.07383015, 0.18636053),
                                   RGB{Float64}(0.13501631, 0.07585609, 0.19044109),
                                   RGB{Float64}(0.14066867, 0.0778224, 0.19452676),
                                   RGB{Float64}(0.14633406, 0.07973393, 0.1986151),
                                   RGB{Float64}(0.15201338, 0.08159108, 0.20270523),
                                   RGB{Float64}(0.15770877, 0.08339312, 0.20679668),
                                   RGB{Float64}(0.16342174, 0.0851396, 0.21088893),
                                   RGB{Float64}(0.16915387, 0.08682996, 0.21498104),
                                   RGB{Float64}(0.17489524, 0.08848235, 0.2190294),
                                   RGB{Float64}(0.18065495, 0.09009031, 0.22303512),
                                   RGB{Float64}(0.18643324, 0.09165431, 0.22699705),
                                   RGB{Float64}(0.19223028, 0.09317479, 0.23091409),
                                   RGB{Float64}(0.19804623, 0.09465217, 0.23478512),
                                   RGB{Float64}(0.20388117, 0.09608689, 0.23860907),
                                   RGB{Float64}(0.20973515, 0.09747934, 0.24238489),
                                   RGB{Float64}(0.21560818, 0.09882993, 0.24611154),
                                   RGB{Float64}(0.22150014, 0.10013944, 0.2497868),
                                   RGB{Float64}(0.22741085, 0.10140876, 0.25340813),
                                   RGB{Float64}(0.23334047, 0.10263737, 0.25697736),
                                   RGB{Float64}(0.23928891, 0.10382562, 0.2604936),
                                   RGB{Float64}(0.24525608, 0.10497384, 0.26395596),
                                   RGB{Float64}(0.25124182, 0.10608236, 0.26736359),
                                   RGB{Float64}(0.25724602, 0.10715148, 0.27071569),
                                   RGB{Float64}(0.26326851, 0.1081815, 0.27401148),
                                   RGB{Float64}(0.26930915, 0.1091727, 0.2772502),
                                   RGB{Float64}(0.27536766, 0.11012568, 0.28043021),
                                   RGB{Float64}(0.28144375, 0.11104133, 0.2835489),
                                   RGB{Float64}(0.2875374, 0.11191896, 0.28660853),
                                   RGB{Float64}(0.29364846, 0.11275876, 0.2896085),
                                   RGB{Float64}(0.29977678, 0.11356089, 0.29254823),
                                   RGB{Float64}(0.30592213, 0.11432553, 0.29542718),
                                   RGB{Float64}(0.31208435, 0.11505284, 0.29824485),
                                   RGB{Float64}(0.31826327, 0.1157429, 0.30100076),
                                   RGB{Float64}(0.32445869, 0.11639585, 0.30369448),
                                   RGB{Float64}(0.33067031, 0.11701189, 0.30632563),
                                   RGB{Float64}(0.33689808, 0.11759095, 0.3088938),
                                   RGB{Float64}(0.34314168, 0.11813362, 0.31139721),
                                   RGB{Float64}(0.34940101, 0.11863987, 0.3138355),
                                   RGB{Float64}(0.355676, 0.11910909, 0.31620996),
                                   RGB{Float64}(0.36196644, 0.1195413, 0.31852037),
                                   RGB{Float64}(0.36827206, 0.11993653, 0.32076656),
                                   RGB{Float64}(0.37459292, 0.12029443, 0.32294825),
                                   RGB{Float64}(0.38092887, 0.12061482, 0.32506528),
                                   RGB{Float64}(0.38727975, 0.12089756, 0.3271175),
                                   RGB{Float64}(0.39364518, 0.12114272, 0.32910494),
                                   RGB{Float64}(0.40002537, 0.12134964, 0.33102734),
                                   RGB{Float64}(0.40642019, 0.12151801, 0.33288464),
                                   RGB{Float64}(0.41282936, 0.12164769, 0.33467689),
                                   RGB{Float64}(0.41925278, 0.12173833, 0.33640407),
                                   RGB{Float64}(0.42569057, 0.12178916, 0.33806605),
                                   RGB{Float64}(0.43214263, 0.12179973, 0.33966284),
                                   RGB{Float64}(0.43860848, 0.12177004, 0.34119475),
                                   RGB{Float64}(0.44508855, 0.12169883, 0.34266151),
                                   RGB{Float64}(0.45158266, 0.12158557, 0.34406324),
                                   RGB{Float64}(0.45809049, 0.12142996, 0.34540024),
                                   RGB{Float64}(0.46461238, 0.12123063, 0.34667231),
                                   RGB{Float64}(0.47114798, 0.12098721, 0.34787978),
                                   RGB{Float64}(0.47769736, 0.12069864, 0.34902273),
                                   RGB{Float64}(0.48426077, 0.12036349, 0.35010104),
                                   RGB{Float64}(0.49083761, 0.11998161, 0.35111537),
                                   RGB{Float64}(0.49742847, 0.11955087, 0.35206533),
                                   RGB{Float64}(0.50403286, 0.11907081, 0.35295152),
                                   RGB{Float64}(0.51065109, 0.11853959, 0.35377385),
                                   RGB{Float64}(0.51728314, 0.1179558, 0.35453252),
                                   RGB{Float64}(0.52392883, 0.11731817, 0.35522789),
                                   RGB{Float64}(0.53058853, 0.11662445, 0.35585982),
                                   RGB{Float64}(0.53726173, 0.11587369, 0.35642903),
                                   RGB{Float64}(0.54394898, 0.11506307, 0.35693521),
                                   RGB{Float64}(0.5506426, 0.11420757, 0.35737863),
                                   RGB{Float64}(0.55734473, 0.11330456, 0.35775059),
                                   RGB{Float64}(0.56405586, 0.11235265, 0.35804813),
                                   RGB{Float64}(0.57077365, 0.11135597, 0.35827146),
                                   RGB{Float64}(0.5774991, 0.11031233, 0.35841679),
                                   RGB{Float64}(0.58422945, 0.10922707, 0.35848469),
                                   RGB{Float64}(0.59096382, 0.10810205, 0.35847347),
                                   RGB{Float64}(0.59770215, 0.10693774, 0.35838029),
                                   RGB{Float64}(0.60444226, 0.10573912, 0.35820487),
                                   RGB{Float64}(0.61118304, 0.10450943, 0.35794557),
                                   RGB{Float64}(0.61792306, 0.10325288, 0.35760108),
                                   RGB{Float64}(0.62466162, 0.10197244, 0.35716891),
                                   RGB{Float64}(0.63139686, 0.10067417, 0.35664819),
                                   RGB{Float64}(0.63812122, 0.09938212, 0.35603757),
                                   RGB{Float64}(0.64483795, 0.0980891, 0.35533555),
                                   RGB{Float64}(0.65154562, 0.09680192, 0.35454107),
                                   RGB{Float64}(0.65824241, 0.09552918, 0.3536529),
                                   RGB{Float64}(0.66492652, 0.09428017, 0.3526697),
                                   RGB{Float64}(0.67159578, 0.09306598, 0.35159077),
                                   RGB{Float64}(0.67824099, 0.09192342, 0.3504148),
                                   RGB{Float64}(0.684863, 0.09085633, 0.34914061),
                                   RGB{Float64}(0.69146268, 0.0898675, 0.34776864),
                                   RGB{Float64}(0.69803757, 0.08897226, 0.3462986),
                                   RGB{Float64}(0.70457834, 0.0882129, 0.34473046),
                                   RGB{Float64}(0.71108138, 0.08761223, 0.3430635),
                                   RGB{Float64}(0.7175507, 0.08716212, 0.34129974),
                                   RGB{Float64}(0.72398193, 0.08688725, 0.33943958),
                                   RGB{Float64}(0.73035829, 0.0868623, 0.33748452),
                                   RGB{Float64}(0.73669146, 0.08704683, 0.33543669),
                                   RGB{Float64}(0.74297501, 0.08747196, 0.33329799),
                                   RGB{Float64}(0.74919318, 0.08820542, 0.33107204),
                                   RGB{Float64}(0.75535825, 0.08919792, 0.32876184),
                                   RGB{Float64}(0.76145589, 0.09050716, 0.32637117),
                                   RGB{Float64}(0.76748424, 0.09213602, 0.32390525),
                                   RGB{Float64}(0.77344838, 0.09405684, 0.32136808),
                                   RGB{Float64}(0.77932641, 0.09634794, 0.31876642),
                                   RGB{Float64}(0.78513609, 0.09892473, 0.31610488),
                                   RGB{Float64}(0.79085854, 0.10184672, 0.313391),
                                   RGB{Float64}(0.7965014, 0.10506637, 0.31063031),
                                   RGB{Float64}(0.80205987, 0.10858333, 0.30783),
                                   RGB{Float64}(0.80752799, 0.11239964, 0.30499738),
                                   RGB{Float64}(0.81291606, 0.11645784, 0.30213802),
                                   RGB{Float64}(0.81820481, 0.12080606, 0.29926105),
                                   RGB{Float64}(0.82341472, 0.12535343, 0.2963705),
                                   RGB{Float64}(0.82852822, 0.13014118, 0.29347474),
                                   RGB{Float64}(0.83355779, 0.13511035, 0.29057852),
                                   RGB{Float64}(0.83850183, 0.14025098, 0.2876878),
                                   RGB{Float64}(0.84335441, 0.14556683, 0.28480819),
                                   RGB{Float64}(0.84813096, 0.15099892, 0.281943),
                                   RGB{Float64}(0.85281737, 0.15657772, 0.27909826),
                                   RGB{Float64}(0.85742602, 0.1622583, 0.27627462),
                                   RGB{Float64}(0.86196552, 0.16801239, 0.27346473),
                                   RGB{Float64}(0.86641628, 0.17387796, 0.27070818),
                                   RGB{Float64}(0.87079129, 0.17982114, 0.26797378),
                                   RGB{Float64}(0.87507281, 0.18587368, 0.26529697),
                                   RGB{Float64}(0.87925878, 0.19203259, 0.26268136),
                                   RGB{Float64}(0.8833417, 0.19830556, 0.26014181),
                                   RGB{Float64}(0.88731387, 0.20469941, 0.25769539),
                                   RGB{Float64}(0.89116859, 0.21121788, 0.2553592),
                                   RGB{Float64}(0.89490337, 0.21785614, 0.25314362),
                                   RGB{Float64}(0.8985026, 0.22463251, 0.25108745),
                                   RGB{Float64}(0.90197527, 0.23152063, 0.24918223),
                                   RGB{Float64}(0.90530097, 0.23854541, 0.24748098),
                                   RGB{Float64}(0.90848638, 0.24568473, 0.24598324),
                                   RGB{Float64}(0.911533, 0.25292623, 0.24470258),
                                   RGB{Float64}(0.9144225, 0.26028902, 0.24369359),
                                   RGB{Float64}(0.91717106, 0.26773821, 0.24294137),
                                   RGB{Float64}(0.91978131, 0.27526191, 0.24245973),
                                   RGB{Float64}(0.92223947, 0.28287251, 0.24229568),
                                   RGB{Float64}(0.92456587, 0.29053388, 0.24242622),
                                   RGB{Float64}(0.92676657, 0.29823282, 0.24285536),
                                   RGB{Float64}(0.92882964, 0.30598085, 0.24362274),
                                   RGB{Float64}(0.93078135, 0.31373977, 0.24468803),
                                   RGB{Float64}(0.93262051, 0.3215093, 0.24606461),
                                   RGB{Float64}(0.93435067, 0.32928362, 0.24775328),
                                   RGB{Float64}(0.93599076, 0.33703942, 0.24972157),
                                   RGB{Float64}(0.93752831, 0.34479177, 0.25199928),
                                   RGB{Float64}(0.93899289, 0.35250734, 0.25452808),
                                   RGB{Float64}(0.94036561, 0.36020899, 0.25734661),
                                   RGB{Float64}(0.94167588, 0.36786594, 0.2603949),
                                   RGB{Float64}(0.94291042, 0.37549479, 0.26369821),
                                   RGB{Float64}(0.94408513, 0.3830811, 0.26722004),
                                   RGB{Float64}(0.94520419, 0.39062329, 0.27094924),
                                   RGB{Float64}(0.94625977, 0.39813168, 0.27489742),
                                   RGB{Float64}(0.94727016, 0.4055909, 0.27902322),
                                   RGB{Float64}(0.94823505, 0.41300424, 0.28332283),
                                   RGB{Float64}(0.94914549, 0.42038251, 0.28780969),
                                   RGB{Float64}(0.95001704, 0.42771398, 0.29244728),
                                   RGB{Float64}(0.95085121, 0.43500005, 0.29722817),
                                   RGB{Float64}(0.95165009, 0.44224144, 0.30214494),
                                   RGB{Float64}(0.9524044, 0.44944853, 0.3072105),
                                   RGB{Float64}(0.95312556, 0.45661389, 0.31239776),
                                   RGB{Float64}(0.95381595, 0.46373781, 0.31769923),
                                   RGB{Float64}(0.95447591, 0.47082238, 0.32310953),
                                   RGB{Float64}(0.95510255, 0.47787236, 0.32862553),
                                   RGB{Float64}(0.95569679, 0.48489115, 0.33421404),
                                   RGB{Float64}(0.95626788, 0.49187351, 0.33985601),
                                   RGB{Float64}(0.95681685, 0.49882008, 0.34555431),
                                   RGB{Float64}(0.9573439, 0.50573243, 0.35130912),
                                   RGB{Float64}(0.95784842, 0.51261283, 0.35711942),
                                   RGB{Float64}(0.95833051, 0.51946267, 0.36298589),
                                   RGB{Float64}(0.95879054, 0.52628305, 0.36890904),
                                   RGB{Float64}(0.95922872, 0.53307513, 0.3748895),
                                   RGB{Float64}(0.95964538, 0.53983991, 0.38092784),
                                   RGB{Float64}(0.96004345, 0.54657593, 0.3870292),
                                   RGB{Float64}(0.96042097, 0.55328624, 0.39319057),
                                   RGB{Float64}(0.96077819, 0.55997184, 0.39941173),
                                   RGB{Float64}(0.9611152, 0.5666337, 0.40569343),
                                   RGB{Float64}(0.96143273, 0.57327231, 0.41203603),
                                   RGB{Float64}(0.96173392, 0.57988594, 0.41844491),
                                   RGB{Float64}(0.96201757, 0.58647675, 0.42491751),
                                   RGB{Float64}(0.96228344, 0.59304598, 0.43145271),
                                   RGB{Float64}(0.96253168, 0.5995944, 0.43805131),
                                   RGB{Float64}(0.96276513, 0.60612062, 0.44471698),
                                   RGB{Float64}(0.96298491, 0.6126247, 0.45145074),
                                   RGB{Float64}(0.96318967, 0.61910879, 0.45824902),
                                   RGB{Float64}(0.96337949, 0.6255736, 0.46511271),
                                   RGB{Float64}(0.96355923, 0.63201624, 0.47204746),
                                   RGB{Float64}(0.96372785, 0.63843852, 0.47905028),
                                   RGB{Float64}(0.96388426, 0.64484214, 0.4861196),
                                   RGB{Float64}(0.96403203, 0.65122535, 0.4932578),
                                   RGB{Float64}(0.96417332, 0.65758729, 0.50046894),
                                   RGB{Float64}(0.9643063, 0.66393045, 0.5077467),
                                   RGB{Float64}(0.96443322, 0.67025402, 0.51509334),
                                   RGB{Float64}(0.96455845, 0.67655564, 0.52251447),
                                   RGB{Float64}(0.96467922, 0.68283846, 0.53000231),
                                   RGB{Float64}(0.96479861, 0.68910113, 0.53756026),
                                   RGB{Float64}(0.96492035, 0.69534192, 0.5451917),
                                   RGB{Float64}(0.96504223, 0.7015636, 0.5528892),
                                   RGB{Float64}(0.96516917, 0.70776351, 0.5606593),
                                   RGB{Float64}(0.96530224, 0.71394212, 0.56849894),
                                   RGB{Float64}(0.96544032, 0.72010124, 0.57640375),
                                   RGB{Float64}(0.96559206, 0.72623592, 0.58438387),
                                   RGB{Float64}(0.96575293, 0.73235058, 0.59242739),
                                   RGB{Float64}(0.96592829, 0.73844258, 0.60053991),
                                   RGB{Float64}(0.96612013, 0.74451182, 0.60871954),
                                   RGB{Float64}(0.96632832, 0.75055966, 0.61696136),
                                   RGB{Float64}(0.96656022, 0.75658231, 0.62527295),
                                   RGB{Float64}(0.96681185, 0.76258381, 0.63364277),
                                   RGB{Float64}(0.96709183, 0.76855969, 0.64207921),
                                   RGB{Float64}(0.96739773, 0.77451297, 0.65057302),
                                   RGB{Float64}(0.96773482, 0.78044149, 0.65912731),
                                   RGB{Float64}(0.96810471, 0.78634563, 0.66773889),
                                   RGB{Float64}(0.96850919, 0.79222565, 0.6764046),
                                   RGB{Float64}(0.96893132, 0.79809112, 0.68512266),
                                   RGB{Float64}(0.96935926, 0.80395415, 0.69383201),
                                   RGB{Float64}(0.9698028, 0.80981139, 0.70252255),
                                   RGB{Float64}(0.97025511, 0.81566605, 0.71120296),
                                   RGB{Float64}(0.97071849, 0.82151775, 0.71987163),
                                   RGB{Float64}(0.97120159, 0.82736371, 0.72851999),
                                   RGB{Float64}(0.97169389, 0.83320847, 0.73716071),
                                   RGB{Float64}(0.97220061, 0.83905052, 0.74578903),
                                   RGB{Float64}(0.97272597, 0.84488881, 0.75440141),
                                   RGB{Float64}(0.97327085, 0.85072354, 0.76299805),
                                   RGB{Float64}(0.97383206, 0.85655639, 0.77158353),
                                   RGB{Float64}(0.97441222, 0.86238689, 0.78015619),
                                   RGB{Float64}(0.97501782, 0.86821321, 0.78871034),
                                   RGB{Float64}(0.97564391, 0.87403763, 0.79725261),
                                   RGB{Float64}(0.97628674, 0.87986189, 0.8057883),
                                   RGB{Float64}(0.97696114, 0.88568129, 0.81430324),
                                   RGB{Float64}(0.97765722, 0.89149971, 0.82280948),
                                   RGB{Float64}(0.97837585, 0.89731727, 0.83130786),
                                   RGB{Float64}(0.97912374, 0.90313207, 0.83979337),
                                   RGB{Float64}(0.979891, 0.90894778, 0.84827858),
                                   RGB{Float64}(0.98067764, 0.91476465, 0.85676611),
                                   RGB{Float64}(0.98137749, 0.92061729, 0.86536915)]
                                   , "seaborn", "sequential, rocket")

loadcolorscheme(:seaborn_icefire_gradient, [
     RGB{Float64}(0.73936227, 0.90443867, 0.85757238),
                                    RGB{Float64}(0.72888063, 0.89639109, 0.85488394),
                                    RGB{Float64}(0.71834255, 0.88842162, 0.8521605),
                                    RGB{Float64}(0.70773866, 0.88052939, 0.849422),
                                    RGB{Float64}(0.69706215, 0.87271313, 0.84668315),
                                    RGB{Float64}(0.68629021, 0.86497329, 0.84398721),
                                    RGB{Float64}(0.67543654, 0.85730617, 0.84130969),
                                    RGB{Float64}(0.66448539, 0.84971123, 0.83868005),
                                    RGB{Float64}(0.65342679, 0.84218728, 0.83611512),
                                    RGB{Float64}(0.64231804, 0.83471867, 0.83358584),
                                    RGB{Float64}(0.63117745, 0.827294, 0.83113431),
                                    RGB{Float64}(0.62000484, 0.81991069, 0.82876741),
                                    RGB{Float64}(0.60879435, 0.81256797, 0.82648905),
                                    RGB{Float64}(0.59754118, 0.80526458, 0.82430414),
                                    RGB{Float64}(0.58624247, 0.79799884, 0.82221573),
                                    RGB{Float64}(0.57489525, 0.7907688, 0.82022901),
                                    RGB{Float64}(0.56349779, 0.78357215, 0.81834861),
                                    RGB{Float64}(0.55204294, 0.77640827, 0.81657563),
                                    RGB{Float64}(0.54052516, 0.76927562, 0.81491462),
                                    RGB{Float64}(0.52894085, 0.76217215, 0.81336913),
                                    RGB{Float64}(0.51728854, 0.75509528, 0.81194156),
                                    RGB{Float64}(0.50555676, 0.74804469, 0.81063503),
                                    RGB{Float64}(0.49373871, 0.7410187, 0.80945242),
                                    RGB{Float64}(0.48183174, 0.73401449, 0.80839675),
                                    RGB{Float64}(0.46982587, 0.72703075, 0.80747097),
                                    RGB{Float64}(0.45770893, 0.72006648, 0.80667756),
                                    RGB{Float64}(0.44547249, 0.71311941, 0.80601991),
                                    RGB{Float64}(0.43318643, 0.70617126, 0.80549278),
                                    RGB{Float64}(0.42110294, 0.69916972, 0.80506683),
                                    RGB{Float64}(0.40925101, 0.69211059, 0.80473246),
                                    RGB{Float64}(0.3976693, 0.68498786, 0.80448272),
                                    RGB{Float64}(0.38632002, 0.67781125, 0.80431024),
                                    RGB{Float64}(0.37523981, 0.67057537, 0.80420832),
                                    RGB{Float64}(0.36442578, 0.66328229, 0.80417474),
                                    RGB{Float64}(0.35385939, 0.65593699, 0.80420591),
                                    RGB{Float64}(0.34358916, 0.64853177, 0.8043),
                                    RGB{Float64}(0.33355526, 0.64107876, 0.80445484),
                                    RGB{Float64}(0.32383062, 0.63356578, 0.80467091),
                                    RGB{Float64}(0.31434372, 0.62600624, 0.8049475),
                                    RGB{Float64}(0.30516161, 0.618389, 0.80528692),
                                    RGB{Float64}(0.29623491, 0.61072284, 0.80569021),
                                    RGB{Float64}(0.28759072, 0.60300319, 0.80616055),
                                    RGB{Float64}(0.27923924, 0.59522877, 0.80669803),
                                    RGB{Float64}(0.27114651, 0.5874047, 0.80730545),
                                    RGB{Float64}(0.26337153, 0.57952055, 0.80799113),
                                    RGB{Float64}(0.25588696, 0.57157984, 0.80875922),
                                    RGB{Float64}(0.248686, 0.56358255, 0.80961366),
                                    RGB{Float64}(0.24180668, 0.55552289, 0.81055123),
                                    RGB{Float64}(0.23526251, 0.54739477, 0.8115939),
                                    RGB{Float64}(0.22921445, 0.53918506, 0.81267292),
                                    RGB{Float64}(0.22397687, 0.53086094, 0.8137141),
                                    RGB{Float64}(0.21977058, 0.52241482, 0.81457651),
                                    RGB{Float64}(0.21658989, 0.51384321, 0.81528511),
                                    RGB{Float64}(0.21452772, 0.50514155, 0.81577278),
                                    RGB{Float64}(0.21372783, 0.49630865, 0.81589566),
                                    RGB{Float64}(0.21409503, 0.48734861, 0.81566163),
                                    RGB{Float64}(0.2157176, 0.47827123, 0.81487615),
                                    RGB{Float64}(0.21842857, 0.46909168, 0.81351614),
                                    RGB{Float64}(0.22211705, 0.45983212, 0.81146983),
                                    RGB{Float64}(0.22665681, 0.45052233, 0.80860217),
                                    RGB{Float64}(0.23176013, 0.44119137, 0.80494325),
                                    RGB{Float64}(0.23727775, 0.43187704, 0.80038017),
                                    RGB{Float64}(0.24298285, 0.42261123, 0.79493267),
                                    RGB{Float64}(0.24865068, 0.41341842, 0.78869164),
                                    RGB{Float64}(0.25423116, 0.40433127, 0.78155831),
                                    RGB{Float64}(0.25950239, 0.39535521, 0.77376848),
                                    RGB{Float64}(0.2644736, 0.38651212, 0.76524809),
                                    RGB{Float64}(0.26901584, 0.37779582, 0.75621942),
                                    RGB{Float64}(0.27318141, 0.36922056, 0.746605),
                                    RGB{Float64}(0.27690355, 0.3607736, 0.73659374),
                                    RGB{Float64}(0.28023585, 0.35244234, 0.72622103),
                                    RGB{Float64}(0.28306009, 0.34438449, 0.71500731),
                                    RGB{Float64}(0.28535896, 0.33660243, 0.70303975),
                                    RGB{Float64}(0.28708711, 0.32912157, 0.69034504),
                                    RGB{Float64}(0.28816354, 0.32200604, 0.67684067),
                                    RGB{Float64}(0.28862749, 0.31519824, 0.66278813),
                                    RGB{Float64}(0.28847904, 0.30869064, 0.6482815),
                                    RGB{Float64}(0.28770912, 0.30250126, 0.63331265),
                                    RGB{Float64}(0.28640325, 0.29655509, 0.61811374),
                                    RGB{Float64}(0.28458943, 0.29082155, 0.60280913),
                                    RGB{Float64}(0.28233561, 0.28527482, 0.58742866),
                                    RGB{Float64}(0.27967038, 0.2798938, 0.57204225),
                                    RGB{Float64}(0.27665361, 0.27465357, 0.55667809),
                                    RGB{Float64}(0.27332564, 0.2695165, 0.54145387),
                                    RGB{Float64}(0.26973851, 0.26447054, 0.52634916),
                                    RGB{Float64}(0.2659204, 0.25949691, 0.511417),
                                    RGB{Float64}(0.26190145, 0.25458123, 0.49668768),
                                    RGB{Float64}(0.2577151, 0.24971691, 0.48214874),
                                    RGB{Float64}(0.25337618, 0.24490494, 0.46778758),
                                    RGB{Float64}(0.24890842, 0.24013332, 0.45363816),
                                    RGB{Float64}(0.24433654, 0.23539226, 0.4397245),
                                    RGB{Float64}(0.23967922, 0.23067729, 0.4260591),
                                    RGB{Float64}(0.23495608, 0.22598894, 0.41262952),
                                    RGB{Float64}(0.23018113, 0.22132414, 0.39945577),
                                    RGB{Float64}(0.22534609, 0.21670847, 0.38645794),
                                    RGB{Float64}(0.22048761, 0.21211723, 0.37372555),
                                    RGB{Float64}(0.2156198, 0.20755389, 0.36125301),
                                    RGB{Float64}(0.21074637, 0.20302717, 0.34903192),
                                    RGB{Float64}(0.20586893, 0.19855368, 0.33701661),
                                    RGB{Float64}(0.20101757, 0.19411573, 0.32529173),
                                    RGB{Float64}(0.19619947, 0.18972425, 0.31383846),
                                    RGB{Float64}(0.19140726, 0.18540157, 0.30260777),
                                    RGB{Float64}(0.1866769, 0.1811332, 0.29166583),
                                    RGB{Float64}(0.18201285, 0.17694992, 0.28088776),
                                    RGB{Float64}(0.17745228, 0.17282141, 0.27044211),
                                    RGB{Float64}(0.17300684, 0.16876921, 0.26024893),
                                    RGB{Float64}(0.16868273, 0.16479861, 0.25034479),
                                    RGB{Float64}(0.16448691, 0.16091728, 0.24075373),
                                    RGB{Float64}(0.16043195, 0.15714351, 0.23141745),
                                    RGB{Float64}(0.15652427, 0.15348248, 0.22238175),
                                    RGB{Float64}(0.15277065, 0.14994111, 0.21368395),
                                    RGB{Float64}(0.14918274, 0.14653431, 0.20529486),
                                    RGB{Float64}(0.14577095, 0.14327403, 0.19720829),
                                    RGB{Float64}(0.14254381, 0.14016944, 0.18944326),
                                    RGB{Float64}(0.13951035, 0.13723063, 0.18201072),
                                    RGB{Float64}(0.13667798, 0.13446606, 0.17493774),
                                    RGB{Float64}(0.13405762, 0.13188822, 0.16820842),
                                    RGB{Float64}(0.13165767, 0.12950667, 0.16183275),
                                    RGB{Float64}(0.12948748, 0.12733187, 0.15580631),
                                    RGB{Float64}(0.12755435, 0.1253723, 0.15014098),
                                    RGB{Float64}(0.12586516, 0.12363617, 0.1448459),
                                    RGB{Float64}(0.12442647, 0.12213143, 0.13992571),
                                    RGB{Float64}(0.12324241, 0.12086419, 0.13539995),
                                    RGB{Float64}(0.12232067, 0.11984278, 0.13124644),
                                    RGB{Float64}(0.12166209, 0.11907077, 0.12749671),
                                    RGB{Float64}(0.12126982, 0.11855309, 0.12415079),
                                    RGB{Float64}(0.12114244, 0.11829179, 0.1212385),
                                    RGB{Float64}(0.12127766, 0.11828837, 0.11878534),
                                    RGB{Float64}(0.12284806, 0.1179729, 0.11772022),
                                    RGB{Float64}(0.12619498, 0.11721796, 0.11770203),
                                    RGB{Float64}(0.129968, 0.11663788, 0.11792377),
                                    RGB{Float64}(0.13410011, 0.11625146, 0.11839138),
                                    RGB{Float64}(0.13855459, 0.11606618, 0.11910584),
                                    RGB{Float64}(0.14333775, 0.11607038, 0.1200606),
                                    RGB{Float64}(0.148417, 0.11626929, 0.12125453),
                                    RGB{Float64}(0.15377389, 0.11666192, 0.12268364),
                                    RGB{Float64}(0.15941427, 0.11723486, 0.12433911),
                                    RGB{Float64}(0.16533376, 0.11797856, 0.12621303),
                                    RGB{Float64}(0.17152547, 0.11888403, 0.12829735),
                                    RGB{Float64}(0.17797765, 0.11994436, 0.13058435),
                                    RGB{Float64}(0.18468769, 0.12114722, 0.13306426),
                                    RGB{Float64}(0.19165663, 0.12247737, 0.13572616),
                                    RGB{Float64}(0.19884415, 0.12394381, 0.1385669),
                                    RGB{Float64}(0.20627181, 0.12551883, 0.14157124),
                                    RGB{Float64}(0.21394877, 0.12718055, 0.14472604),
                                    RGB{Float64}(0.22184572, 0.12893119, 0.14802579),
                                    RGB{Float64}(0.22994394, 0.13076731, 0.15146314),
                                    RGB{Float64}(0.23823937, 0.13267611, 0.15502793),
                                    RGB{Float64}(0.24676041, 0.13462172, 0.15870321),
                                    RGB{Float64}(0.25546457, 0.13661751, 0.16248722),
                                    RGB{Float64}(0.26433628, 0.13865956, 0.16637301),
                                    RGB{Float64}(0.27341345, 0.14070412, 0.17034221),
                                    RGB{Float64}(0.28264773, 0.14277192, 0.1743957),
                                    RGB{Float64}(0.29202272, 0.14486161, 0.17852793),
                                    RGB{Float64}(0.30159648, 0.14691224, 0.1827169),
                                    RGB{Float64}(0.31129002, 0.14897583, 0.18695213),
                                    RGB{Float64}(0.32111555, 0.15103351, 0.19119629),
                                    RGB{Float64}(0.33107961, 0.1530674, 0.19543758),
                                    RGB{Float64}(0.34119892, 0.15504762, 0.1996803),
                                    RGB{Float64}(0.35142388, 0.15701131, 0.20389086),
                                    RGB{Float64}(0.36178937, 0.1589124, 0.20807639),
                                    RGB{Float64}(0.37229381, 0.16073993, 0.21223189),
                                    RGB{Float64}(0.38288348, 0.16254006, 0.2163249),
                                    RGB{Float64}(0.39359592, 0.16426336, 0.22036577),
                                    RGB{Float64}(0.40444332, 0.16588767, 0.22434027),
                                    RGB{Float64}(0.41537995, 0.16745325, 0.2282297),
                                    RGB{Float64}(0.42640867, 0.16894939, 0.23202755),
                                    RGB{Float64}(0.43754706, 0.17034847, 0.23572899),
                                    RGB{Float64}(0.44878564, 0.1716535, 0.23932344),
                                    RGB{Float64}(0.4601126, 0.17287365, 0.24278607),
                                    RGB{Float64}(0.47151732, 0.17401641, 0.24610337),
                                    RGB{Float64}(0.48300689, 0.17506676, 0.2492737),
                                    RGB{Float64}(0.49458302, 0.17601892, 0.25227688),
                                    RGB{Float64}(0.50623876, 0.17687777, 0.255096),
                                    RGB{Float64}(0.5179623, 0.17765528, 0.2577162),
                                    RGB{Float64}(0.52975234, 0.17835232, 0.2601134),
                                    RGB{Float64}(0.54159776, 0.17898292, 0.26226847),
                                    RGB{Float64}(0.55348804, 0.17956232, 0.26416003),
                                    RGB{Float64}(0.56541729, 0.18010175, 0.26575971),
                                    RGB{Float64}(0.57736669, 0.180631, 0.26704888),
                                    RGB{Float64}(0.58932081, 0.18117827, 0.26800409),
                                    RGB{Float64}(0.60127582, 0.18175888, 0.26858488),
                                    RGB{Float64}(0.61319563, 0.1824336, 0.2687872),
                                    RGB{Float64}(0.62506376, 0.18324015, 0.26858301),
                                    RGB{Float64}(0.63681202, 0.18430173, 0.26795276),
                                    RGB{Float64}(0.64842603, 0.18565472, 0.26689463),
                                    RGB{Float64}(0.65988195, 0.18734638, 0.26543435),
                                    RGB{Float64}(0.67111966, 0.18948885, 0.26357955),
                                    RGB{Float64}(0.68209194, 0.19216636, 0.26137175),
                                    RGB{Float64}(0.69281185, 0.19535326, 0.25887063),
                                    RGB{Float64}(0.70335022, 0.19891271, 0.25617971),
                                    RGB{Float64}(0.71375229, 0.20276438, 0.25331365),
                                    RGB{Float64}(0.72401436, 0.20691287, 0.25027366),
                                    RGB{Float64}(0.73407638, 0.21145051, 0.24710661),
                                    RGB{Float64}(0.74396983, 0.21631913, 0.24380715),
                                    RGB{Float64}(0.75361506, 0.22163653, 0.24043996),
                                    RGB{Float64}(0.7630579, 0.22731637, 0.23700095),
                                    RGB{Float64}(0.77222228, 0.23346231, 0.23356628),
                                    RGB{Float64}(0.78115441, 0.23998404, 0.23013825),
                                    RGB{Float64}(0.78979746, 0.24694858, 0.22678822),
                                    RGB{Float64}(0.79819286, 0.25427223, 0.22352658),
                                    RGB{Float64}(0.80630444, 0.26198807, 0.22040877),
                                    RGB{Float64}(0.81417437, 0.27001406, 0.21744645),
                                    RGB{Float64}(0.82177364, 0.27837336, 0.21468316),
                                    RGB{Float64}(0.82915955, 0.28696963, 0.21210766),
                                    RGB{Float64}(0.83628628, 0.2958499, 0.20977813),
                                    RGB{Float64}(0.84322168, 0.30491136, 0.20766435),
                                    RGB{Float64}(0.84995458, 0.31415945, 0.2057863),
                                    RGB{Float64}(0.85648867, 0.32358058, 0.20415327),
                                    RGB{Float64}(0.86286243, 0.33312058, 0.20274969),
                                    RGB{Float64}(0.86908321, 0.34276705, 0.20157271),
                                    RGB{Float64}(0.87512876, 0.3525416, 0.20064949),
                                    RGB{Float64}(0.88100349, 0.36243385, 0.19999078),
                                    RGB{Float64}(0.8866469, 0.37249496, 0.1997976),
                                    RGB{Float64}(0.89203964, 0.38273475, 0.20013431),
                                    RGB{Float64}(0.89713496, 0.39318156, 0.20121514),
                                    RGB{Float64}(0.90195099, 0.40380687, 0.20301555),
                                    RGB{Float64}(0.90648379, 0.41460191, 0.20558847),
                                    RGB{Float64}(0.9106967, 0.42557857, 0.20918529),
                                    RGB{Float64}(0.91463791, 0.43668557, 0.21367954),
                                    RGB{Float64}(0.91830723, 0.44790913, 0.21916352),
                                    RGB{Float64}(0.92171507, 0.45922856, 0.22568002),
                                    RGB{Float64}(0.92491786, 0.4705936, 0.23308207),
                                    RGB{Float64}(0.92790792, 0.48200153, 0.24145932),
                                    RGB{Float64}(0.93073701, 0.49341219, 0.25065486),
                                    RGB{Float64}(0.93343918, 0.5048017, 0.26056148),
                                    RGB{Float64}(0.93602064, 0.51616486, 0.27118485),
                                    RGB{Float64}(0.93850535, 0.52748892, 0.28242464),
                                    RGB{Float64}(0.94092933, 0.53875462, 0.29416042),
                                    RGB{Float64}(0.94330011, 0.5499628, 0.30634189),
                                    RGB{Float64}(0.94563159, 0.56110987, 0.31891624),
                                    RGB{Float64}(0.94792955, 0.57219822, 0.33184256),
                                    RGB{Float64}(0.95020929, 0.5832232, 0.34508419),
                                    RGB{Float64}(0.95247324, 0.59419035, 0.35859866),
                                    RGB{Float64}(0.95471709, 0.60510869, 0.37236035),
                                    RGB{Float64}(0.95698411, 0.61595766, 0.38629631),
                                    RGB{Float64}(0.95923863, 0.62676473, 0.40043317),
                                    RGB{Float64}(0.9615041, 0.6375203, 0.41474106),
                                    RGB{Float64}(0.96371553, 0.64826619, 0.42928335),
                                    RGB{Float64}(0.96591497, 0.65899621, 0.44380444),
                                    RGB{Float64}(0.96809871, 0.66971662, 0.45830232),
                                    RGB{Float64}(0.9702495, 0.6804394, 0.47280492),
                                    RGB{Float64}(0.9723881, 0.69115622, 0.48729272),
                                    RGB{Float64}(0.97450723, 0.70187358, 0.50178034),
                                    RGB{Float64}(0.9766108, 0.712592, 0.51626837),
                                    RGB{Float64}(0.97871716, 0.72330511, 0.53074053),
                                    RGB{Float64}(0.98082222, 0.73401769, 0.54520694),
                                    RGB{Float64}(0.9829001, 0.74474445, 0.5597019),
                                    RGB{Float64}(0.98497466, 0.75547635, 0.57420239),
                                    RGB{Float64}(0.98705581, 0.76621129, 0.58870185),
                                    RGB{Float64}(0.98913325, 0.77695637, 0.60321626),
                                    RGB{Float64}(0.99119918, 0.78771716, 0.61775821),
                                    RGB{Float64}(0.9932672, 0.79848979, 0.63231691),
                                    RGB{Float64}(0.99535958, 0.80926704, 0.64687278),
                                    RGB{Float64}(0.99740544, 0.82008078, 0.66150571),
                                    RGB{Float64}(0.9992197, 0.83100723, 0.6764127)],
                                    "seaborn", "sequential, ice fire gradient")
