module Gitlab
  # @private
  class API < Request
    # @private
    attr_accessor *Configuration::VALID_OPTIONS_KEYS

    # Creates a new API.
    # @raise [Error:MissingCredentials]
    def initialize(options={})
      options = Gitlab.options.merge(options)
      Configuration::VALID_OPTIONS_KEYS.each do |key|
        send("#{key}=", options[key])
      end
      set_request_defaults @endpoint, @private_token
    end
  end
end
