package bitbucket

import (
	"github.com/gabrie30/ghorg/internal/repo"
	bitbucket "github.com/ktrysmt/go-bitbucket"

	"os"
)

// GetOrgRepos gets org repos
func GetOrgRepos(targetOrg string) ([]repo.Data, error) {

	client := bitbucket.NewBasicAuth(os.Getenv("GHORG_BITBUCKET_USERNAME"), os.Getenv("GHORG_BITBUCKET_APP_PASSWORD"))
	cloneData := []repo.Data{}

	resp, err := client.Teams.Repositories(targetOrg)
	if err != nil {
		return []repo.Data{}, err
	}
	values := resp.(map[string]interface{})["values"].([]interface{})
	if err != nil {
		return nil, err
	}
	for _, a := range values {
		clone := a.(map[string]interface{})
		links := clone["links"].(map[string]interface{})["clone"].([]interface{})
		for _, l := range links {
			link := l.(map[string]interface{})["href"]
			linkType := l.(map[string]interface{})["name"]
			r := repo.Data{}
			if os.Getenv("GHORG_CLONE_PROTOCOL") == "ssh" && linkType == "ssh" {
				r.URL = link.(string)
				r.CloneURL = link.(string)
				cloneData = append(cloneData, r)
			} else if os.Getenv("GHORG_CLONE_PROTOCOL") == "https" && linkType == "https" {
				r.URL = link.(string)
				r.CloneURL = link.(string)
				cloneData = append(cloneData, r)
			}
		}
	}

	return cloneData, nil
}

// GetUserRepos gets user repos from bitbucket
func GetUserRepos(targetUser string) ([]repo.Data, error) {

	client := bitbucket.NewBasicAuth(os.Getenv("GHORG_BITBUCKET_USERNAME"), os.Getenv("GHORG_BITBUCKET_APP_PASSWORD"))
	cloneData := []repo.Data{}

	resp, err := client.Users.Repositories(targetUser)
	if err != nil {
		return []repo.Data{}, err
	}
	values := resp.(map[string]interface{})["values"].([]interface{})
	if err != nil {
		return nil, err
	}
	for _, a := range values {
		clone := a.(map[string]interface{})
		links := clone["links"].(map[string]interface{})["clone"].([]interface{})
		for _, l := range links {
			link := l.(map[string]interface{})["href"]
			linkType := l.(map[string]interface{})["name"]

			r := repo.Data{}
			if os.Getenv("GHORG_CLONE_PROTOCOL") == "ssh" && linkType == "ssh" {
				r.URL = link.(string)
				r.CloneURL = link.(string)
				cloneData = append(cloneData, r)
			} else if os.Getenv("GHORG_CLONE_PROTOCOL") == "https" && linkType == "https" {
				r.URL = link.(string)
				r.CloneURL = link.(string)
				cloneData = append(cloneData, r)
			}
		}
	}

	return cloneData, nil
}
