/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephCOSIDriverLister helps list CephCOSIDrivers.
// All objects returned here must be treated as read-only.
type CephCOSIDriverLister interface {
	// List lists all CephCOSIDrivers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephCOSIDriver, err error)
	// CephCOSIDrivers returns an object that can list and get CephCOSIDrivers.
	CephCOSIDrivers(namespace string) CephCOSIDriverNamespaceLister
	CephCOSIDriverListerExpansion
}

// cephCOSIDriverLister implements the CephCOSIDriverLister interface.
type cephCOSIDriverLister struct {
	indexer cache.Indexer
}

// NewCephCOSIDriverLister returns a new CephCOSIDriverLister.
func NewCephCOSIDriverLister(indexer cache.Indexer) CephCOSIDriverLister {
	return &cephCOSIDriverLister{indexer: indexer}
}

// List lists all CephCOSIDrivers in the indexer.
func (s *cephCOSIDriverLister) List(selector labels.Selector) (ret []*v1.CephCOSIDriver, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephCOSIDriver))
	})
	return ret, err
}

// CephCOSIDrivers returns an object that can list and get CephCOSIDrivers.
func (s *cephCOSIDriverLister) CephCOSIDrivers(namespace string) CephCOSIDriverNamespaceLister {
	return cephCOSIDriverNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephCOSIDriverNamespaceLister helps list and get CephCOSIDrivers.
// All objects returned here must be treated as read-only.
type CephCOSIDriverNamespaceLister interface {
	// List lists all CephCOSIDrivers in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephCOSIDriver, err error)
	// Get retrieves the CephCOSIDriver from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephCOSIDriver, error)
	CephCOSIDriverNamespaceListerExpansion
}

// cephCOSIDriverNamespaceLister implements the CephCOSIDriverNamespaceLister
// interface.
type cephCOSIDriverNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephCOSIDrivers in the indexer for a given namespace.
func (s cephCOSIDriverNamespaceLister) List(selector labels.Selector) (ret []*v1.CephCOSIDriver, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephCOSIDriver))
	})
	return ret, err
}

// Get retrieves the CephCOSIDriver from the indexer for a given namespace and name.
func (s cephCOSIDriverNamespaceLister) Get(name string) (*v1.CephCOSIDriver, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephcosidriver"), name)
	}
	return obj.(*v1.CephCOSIDriver), nil
}
