/*
Copyright 2020 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Package k8sutil for Kubernetes helpers.
package k8sutil

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGetServiceMonitor(t *testing.T) {
	name := "rook-ceph-mgr"
	namespace := "rook-ceph"
	servicemonitor := GetServiceMonitor(name, namespace)
	assert.Equal(t, name, servicemonitor.GetName())
	assert.Equal(t, namespace, servicemonitor.GetNamespace())
	assert.NotNil(t, servicemonitor.GetLabels())
	assert.NotNil(t, servicemonitor.Spec.NamespaceSelector.MatchNames)
	assert.NotNil(t, servicemonitor.Spec.Selector.MatchLabels)
	assert.NotNil(t, servicemonitor.Spec.Endpoints)
}
