﻿section: component
id: inputgroup
description: 多个输入单元格
icon: icon-layout
filter: shuruzu srz
---

# 输入组

## 基本类型

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control" placeholder="用户名">
        <span class="input-group-addon">@gmail.com</span>
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-addon">@</span>
        <input type="text" class="form-control" placeholder="用户名">
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-addon">@</span>
        <input type="text" class="form-control" placeholder="用户名">
        <span class="input-group-addon"><i class="icon icon-heart"></i></span>
      </div>
    </div>
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control" placeholder="用户名">
        <span class="input-group-addon fix-border"><i class="icon icon-star"></i></span>
        <input type="text" class="form-control" placeholder="密码">
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-addon"><i class="icon-user"></i></span>
        <input type="text" class="form-control" placeholder="用户名">
        <span class="input-group-addon fix-border"><i class="icon-key"></i></span>
        <input type="text" class="form-control" placeholder="密码">
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-addon"><i class="icon-user"></i></span>
        <input type="text" class="form-control" placeholder="用户名">
        <span class="input-group-addon fix-border"><i class="icon-key"></i></span>
        <input type="text" class="form-control" placeholder="密码">
        <span class="input-group-addon"><i class="icon-ok"></i></span>
      </div>
    </div>
  </div>
</div>

```html
<div class="input-group">
  <span class="input-group-addon">@</span>
  <input type="text" class="form-control" placeholder="用户名">
  <span class="input-group-addon"><i class="icon icon-heart"></i></span>
</div>
```

<div class="alert alert-warning">
  <h4>消除双边框</h4>
  <p>当按钮处于两个文本框中间时，需要在<code>.input-group-addon</code>上添加样式修复工具类<code>.fix-border</code>。</p>
</div>

## 连续分段的文本框

有时可能需要连续分段的文本框。这时需要在两个相邻的`.form-control`元素之间添加一个空的`.input-group-addon`，并同时添加工具栏

<div class="alert alert-warning">
  <h4>兼容IE浏览器</h4>
  <p>因为IE8不支持<code>:empty</code>选择器，为兼容IE8浏览器，需要在<code>.input-group-addon</code>上添加额外的样式修复工具类<code>.fix-padding</code>。</p>
</div>

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <span class="input-group-addon">姓名</span>
        <input type="text" class="form-control" placeholder="姓氏">
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="名字">
      </div>
    </div>
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control" placeholder="省份">
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="城市">
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="县/市">
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="社区/乡/镇">
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="街道 门牌号">
      </div>
    </div>
  </div>
</div>

```html
<div class="input-group">
  <span class="input-group-addon">姓名</span>
  <input type="text" class="form-control" placeholder="姓氏">
  <span class="input-group-addon fix-border fix-padding"></span>
  <input type="text" class="form-control" placeholder="名字">
</div>
```

## 单选框和复选框

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <span class="input-group-addon">
          <input type="checkbox">
        </span>
        <input type="text" class="form-control">
      </div>
    </div>
    <div class="col-md-6">
      <div class="input-group">
        <span class="input-group-addon">
          <input type="radio">
        </span>
        <input type="text" class="form-control">
      </div>
    </div>
  </div>
</div>

```html
<!-- 复选框 -->
<div class="input-group">
  <span class="input-group-addon">
    <input type="checkbox">
  </span>
  <input type="text" class="form-control">
</div>
```

```html
<!-- 单选框 -->
<div class="input-group">
  <span class="input-group-addon">
    <input type="radio">
  </span>
  <input type="text" class="form-control">
</div>
```

## 带按钮

<div class="alert alert-warning">
  <h4>消除双边框</h4>
  <p>当按钮处于两个文本框中间时，需要在<code>.input-group-btn</code>上添加样式修复工具类<code>.fix-border</code>。</p>
</div>

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control">
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
        <input type="text" class="form-control">
      </div>
    </div>
    <div class="col-md-6">
      <div class="input-group">
        <span class="input-group-addon"><i class="icon-search"></i></span>
        <input type="text" class="form-control">
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
      </div>
      <br>
      <div class="input-group">
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
        <input type="text" class="form-control">
        <span class="input-group-btn fix-border">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
        <input type="text" class="form-control">
      </div>
    </div>
  </div>
</div>

```html
<div class="input-group">
  <input type="text" class="form-control">
  <span class="input-group-btn">
    <button class="btn btn-default" type="button">搜索</button>
  </span>
</div>
```

## 带下拉菜单的按钮

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <div class="input-group-btn">
          <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">选项 <span class="caret"></span></button>
          <ul class="dropdown-menu" role="menu">
            <li><a href="#">选项</a></li>
            <li><a href="#">另一个选项</a></li>
            <li><a href="#">更多选项</a></li>
            <li class="divider"></li>
            <li><a href="#">特别内容</a></li>
          </ul>
        </div><!-- /btn-group -->
        <input type="text" class="form-control">
      </div><!-- /input-group -->
    </div><!-- /.col-md-6 -->
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control">
        <div class="input-group-btn">
          <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">选项 <span class="caret"></span></button>
          <ul class="dropdown-menu pull-right" role="menu">
            <li><a href="#">选项</a></li>
            <li><a href="#">另一个选项</a></li>
            <li><a href="#">更多选项</a></li>
            <li class="divider"></li>
            <li><a href="#">特别内容</a></li>
          </ul>
        </div><!-- /btn-group -->
      </div><!-- /input-group -->
    </div><!-- /.col-md-6 -->
  </div>
</div>

```html
<div class="input-group">
  <input type="text" class="form-control">
  <div class="input-group-btn">
    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">选项 <span class="caret"></span></button>
    <ul class="dropdown-menu pull-right" role="menu">
      <li><a href="#">选项</a></li>
      <li><a href="#">另一个选项</a></li>
      <li><a href="#">更多选项</a></li>
      <li class="divider"></li>
      <li><a href="#">特别内容</a></li>
    </ul>
  </div>
</div>
```

## 使用Select

<div class="alert alert-danger">
  <h4>浏览器兼容性问题</h4>
  <p>通常并不推荐在输入框组中使用select元素。这样可能会带来难以处理的兼容性问题。推荐使用 <strong>Dropdown</strong> 或者 <strong>Chosen</strong>来代替下拉列表。</p>
</div>

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <select class="form-control">
          <option value="eat">吃饭</option>
          <option value="sleep">睡觉</option>
          <option value="code">写代码</option>
        </select>
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">搜索</button>
        </span>
      </div>
    </div>
    <div class="col-md-6">
      <div class="input-group">
        <span class="input-group-addon">地址</span>
        <select class="form-control">
          <option value="1">省份</option>
          <option value="2">北京</option>
          <option value="3">上海</option>
          <option value="3">广州</option>
        </select>
        <span class="input-group-addon fix-border fix-padding"></span>
        <select class="form-control">
          <option value="1">市/县</option>
          <option value="1">...</option>
        </select>
        <span class="input-group-addon fix-border fix-padding"></span>
        <input type="text" class="form-control" placeholder="社区/乡/镇">
        <span class="input-group-btn">
          <button class="btn btn-default" type="button">确认</button>
        </span>
      </div>
    </div>
  </div>
</div>

```html
<div class="input-group">
  <select class="form-control">
    <option value="eat">吃饭</option>
    <option value="sleep">睡觉</option>
    <option value="code">写代码</option>
  </select>
  <span class="input-group-btn">
    <button class="btn btn-default" type="button">搜索</button>
  </span>
</div>
```

## 分段按钮

<div class="example">
  <div class="row">
    <div class="col-md-6">
      <div class="input-group">
        <div class="input-group-btn">
          <button type="button" class="btn btn-default" tabindex="-1">主要选项</button>
          <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" tabindex="-1">
            <span class="caret"></span>
            <span class="sr-only">更多选项</span>
          </button>
          <ul class="dropdown-menu" role="menu">
            <li><a href="#">选项</a></li>
            <li><a href="#">另一个选项</a></li>
            <li><a href="#">更多选项</a></li>
            <li class="divider"></li>
            <li><a href="#">特别内容</a></li>
          </ul>
        </div>
        <input type="text" class="form-control">
      </div><!-- /.input-group -->
    </div><!-- /.col-md-6 -->
    <div class="col-md-6">
      <div class="input-group">
        <input type="text" class="form-control">
        <div class="input-group-btn">
          <button type="button" class="btn btn-default" tabindex="-1">主要选项</button>
          <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" tabindex="-1">
            <span class="caret"></span>
            <span class="sr-only">更多选项</span>
          </button>
          <ul class="dropdown-menu pull-right" role="menu">
            <li><a href="#">选项</a></li>
            <li><a href="#">另一个选项</a></li>
            <li><a href="#">更多选项</a></li>
            <li class="divider"></li>
            <li><a href="#">特别内容</a></li>
          </ul>
        </div>
      </div><!-- /.input-group -->
    </div><!-- /.col-md-6 -->
  </div>
</div>

```html
<div class="input-group">
  <input type="text" class="form-control">
  <div class="input-group-btn">
    <button type="button" class="btn btn-default" tabindex="-1">主要选项</button>
    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" tabindex="-1">
      <span class="caret"></span>
      <span class="sr-only">更多选项</span>
    </button>
    <ul class="dropdown-menu pull-right" role="menu">
      <li><a href="#">选项</a></li>
      <li><a href="#">另一个选项</a></li>
      <li><a href="#">更多选项</a></li>
      <li class="divider"></li>
      <li><a href="#">特别内容</a></li>
    </ul>
  </div>
</div>
```
