# Orchestra

[![PyPI version](https://badge.fury.io/py/orchestra.svg?maxAge=2592000)](https://badge.fury.io/py/orchestra)
[![Documentation Status](https://readthedocs.org/projects/orchestra/badge/?version=latest)](http://orchestra.readthedocs.org/en/stable/?badge=latest)
[![Circle CI](https://circleci.com/gh/b12io/orchestra.svg?maxAge=2592000&style=shield)](https://circleci.com/gh/b12io/orchestra)
[![Coverage Status](https://coveralls.io/repos/github/b12io/orchestra/badge.svg?maxAge=2592000&branch=master)](https://coveralls.io/github/b12io/orchestra?branch=master)
[![Apache License](https://img.shields.io/pypi/l/orchestra.svg?maxAge=2592000)](https://github.com/b12io/orchestra/blob/master/LICENSE)
[![Gitter](https://img.shields.io/gitter/room/nwjs/nw.js.svg?maxAge=2592000)](https://gitter.im/b12io/orchestra)

Orchestra is a Robotic Process Automation system for orchestrating project teams of experts and machines.
Projects can include everything from design teams working on a client's project
to newsrooms bringing together reporters, photographers, and editors for a
story. In Orchestra workflows, you can assign senior experts to review other
experts in order to provide feedback and iteratively refine the work.
Orchestra also brings machines and automation onto projects: a crawler can
collect content from the web before an expert combs through it, or a classifier
can filter out bad data so an analyst spends less time in the noise.  New
workflows can be added with some simple python glue and an html interface.

To learn more about Orchestra with some examples and a getting
started guide, or to reach out to the Orchestra team, take
a look at some of these resources:

* [Orchestra website](http://orchestra.b12.io)
* [A blog post introducing Orchestra v0.1.0 to the world](https://blog.b12.io/introducing-orchestra-23bace45d4a7)
* [Subscribe to the Orchestra mailing list](https://groups.google.com/forum/#!forum/orchestra-devel)

# About B12
[B12](http://b12.io/) has open sourced Orchestra as part
of our goal to build a brighter future of work.

We are a startup based in NYC that is passionate about improving how people do
creative and analytical work. We have a strong team of engineers and designers
who have worked extensively on systems that help people work productively
online. We believe that the products and experiences we design should be considerate of their greater social context and impact. 

# Acknowledgements
Thank you to all of the experts who have completed work on
early versions of Orchestra to get it where it is today.

A very special thank you to [Robert Jördens](https://github.com/jordens) for
generously providing us with the `orchestra` package name on PyPi.
