# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-06-15 16:06
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields
import orchestra.models.core.mixins
import orchestra.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ('orchestra', '0075_add_sanity_checks'),
    ]

    operations = [
        migrations.CreateModel(
            name='TodoListTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True,
                                        primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(
                    default=django.utils.timezone.now)),
                ('is_deleted', models.BooleanField(default=False)),
                ('slug', models.CharField(max_length=200, unique=True)),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField()),
                ('todos', jsonfield.fields.JSONField(default={'items': []})),
                ('creator', models.ForeignKey(blank=True, null=True,
                                              on_delete=django.db.models.deletion.SET_NULL, related_name='creator', to='orchestra.Worker')),
            ],
            bases=(orchestra.models.core.mixins.TodoListTemplateMixin,
                   orchestra.utils.models.DeleteMixin, models.Model),
        ),
        migrations.AddField(
            model_name='todo',
            name='activity_log',
            field=jsonfield.fields.JSONField(default={'actions': []}),
        ),
        migrations.AddField(
            model_name='todo',
            name='parent_todo',
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parent', to='orchestra.Todo'),
        ),
        migrations.AddField(
            model_name='todo',
            name='skipped_datetime',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='todo',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='template', to='orchestra.TodoListTemplate'),
        ),
    ]
