/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.google.cast.CastContext;
import com.google.cast.CastDevice;
import com.google.cast.Logger;
import com.google.cast.MessageStream;
import com.google.cast.WebSocket;
import com.google.cast.c;
import com.google.cast.h;
import com.google.cast.o;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ApplicationChannel {
    private Map<String, MessageStream> a;
    private WebSocket b;
    private int c;
    private a d;
    private Handler e;
    private Logger f;
    private h g;
    private CastDevice h;
    private CastContext i;
    private long j;
    private long k;
    private Runnable l;
    private Runnable m;

    ApplicationChannel(CastContext castContext, int bufferSize, long pingIntervalMs, a listener, Handler handler, CastDevice castDevice) {
        this.i = castContext;
        this.c = bufferSize;
        this.k = pingIntervalMs * 2L;
        this.d = listener;
        this.e = handler;
        this.h = castDevice;
        this.a = new HashMap<String, MessageStream>();
        this.l = new Runnable(){

            @Override
            public void run() {
                ApplicationChannel.this.c();
            }
        };
        this.m = new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("type", (Object)"pong");
                    ApplicationChannel.this.a("cm", jSONObject);
                }
                catch (JSONException jSONException) {
                }
                catch (IOException iOException) {
                    ApplicationChannel.this.a(-1);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
        this.f = new Logger("ApplicationChannel");
        this.g = new h(){

            @Override
            public void a(String string, JSONObject jSONObject) throws IOException {
                ApplicationChannel.this.a(string, jSONObject);
            }

            @Override
            public int a() {
                return ApplicationChannel.this.getSendBufferAvailableBytes();
            }
        };
        this.b = new WebSocket("https://www.google.com", "", this.c);
        this.b.a(new WebSocket.Listener(){

            @Override
            public void onConnected() {
                if (ApplicationChannel.this.k != 0L) {
                    ApplicationChannel.this.j = SystemClock.uptimeMillis();
                    ApplicationChannel.this.e.postDelayed(ApplicationChannel.this.l, 1000L);
                }
                ApplicationChannel.this.e.post(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationChannel.this.d.a(ApplicationChannel.this);
                    }
                });
            }

            @Override
            public void onConnectionFailed(final int error) {
                ApplicationChannel.this.j = 0L;
                ApplicationChannel.this.e.post(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationChannel.this.d.a(ApplicationChannel.this, ApplicationChannel.this.b(error));
                    }
                });
            }

            @Override
            public void onMessageReceived(String message, boolean isFinal) {
                if (!isFinal) {
                    ApplicationChannel.this.a(null, message);
                } else {
                    ApplicationChannel.this.a(message);
                }
            }

            @Override
            public void onMessageReceived(byte[] message, boolean isFinal) {
                ApplicationChannel.this.a(null, message);
            }

            @Override
            public void onContinuationMessageReceived(String message, boolean isFinal) {
                ApplicationChannel.this.a(null, message);
            }

            @Override
            public void onContinuationMessageReceived(byte[] message, boolean isFinal) {
                ApplicationChannel.this.a(null, message);
            }

            @Override
            public void onDisconnected(final int error, int closeCode) {
                ApplicationChannel.this.f.d("onDisconnected(); error=%d", error);
                ApplicationChannel.this.e.post(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationChannel.this.a(ApplicationChannel.this.b(error));
                    }
                });
            }
        });
    }

    private void a(int n2) {
        this.b();
        this.b = null;
        this.detachAllMessageStreams();
        this.d.b(this, n2);
    }

    void a(Uri uri) throws IOException {
        this.b.a(uri);
    }

    private void a(String string, JSONObject jSONObject) throws IOException, IllegalStateException {
        if (this.b == null || !this.b.b()) {
            throw new IllegalStateException("Socket is not connected anymore");
        }
        String string2 = null;
        try {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put(0, (Object)string);
            jSONArray.put(1, (Object)jSONObject);
            string2 = jSONArray.toString();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.b.a(string2);
    }

    public int getSendBufferAvailableBytes() {
        if (this.b == null || !this.b.b()) {
            return -1;
        }
        return this.b.d();
    }

    public int getSendBufferPendingBytes() {
        if (this.b == null || !this.b.b()) {
            return -1;
        }
        return this.b.e();
    }

    public int getBufferSize() {
        return this.c;
    }

    void a() {
        this.f.d("disconnect()", new Object[0]);
        this.b();
        this.detachAllMessageStreams();
        if (this.b != null) {
            try {
                this.b.a();
            }
            catch (IOException iOException) {
                this.f.e("Error while disconnecting socket", iOException);
            }
            this.b = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachMessageStream(MessageStream stream) {
        o.a();
        String string = stream.getNamespace();
        Map<String, MessageStream> map = this.a;
        synchronized (map) {
            if (this.a.containsKey(string)) {
                throw new IllegalArgumentException("MessageStream with namespace " + string + " already registered");
            }
            this.a.put(string, stream);
            stream.a(this.g);
        }
        if ("ramp".equals(stream.getNamespace())) {
            com.google.cast.c.a(this.i.getApplicationContext(), this.h);
        }
        stream.onAttached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachMessageStream(MessageStream stream) {
        o.a();
        boolean bl = false;
        Map<String, MessageStream> map = this.a;
        synchronized (map) {
            bl = this.a.remove(stream.getNamespace()) != null;
        }
        if (bl) {
            stream.a(null);
            stream.onDetached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachAllMessageStreams() {
        ArrayList<MessageStream> arrayList;
        o.a();
        Map<String, MessageStream> map = this.a;
        synchronized (map) {
            arrayList = new ArrayList<MessageStream>(this.a.values());
            this.a.clear();
        }
        for (MessageStream messageStream : arrayList) {
            messageStream.a(null);
            messageStream.onDetached();
        }
    }

    private void b() {
        if (this.k != 0L) {
            this.e.removeCallbacks(this.l);
            this.e.removeCallbacks(this.m);
            this.j = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string) {
        try {
            JSONArray jSONArray = new JSONArray(string);
            if (jSONArray.length() != 2) {
                this.a(null, string);
                return;
            }
            MessageStream messageStream = null;
            String string2 = jSONArray.getString(0);
            JSONObject jSONObject = jSONArray.getJSONObject(1);
            if (string2.equals("cm")) {
                String string3 = jSONObject.getString("type");
                if (string3.equals("ping")) {
                    this.j = SystemClock.uptimeMillis();
                    this.e.post(this.m);
                }
                return;
            }
            Object object = this.a;
            synchronized (object) {
                messageStream = this.a.get(string2);
            }
            if (messageStream == null) {
                this.a(string2, string);
                return;
            }
            object = messageStream;
            this.e.post(new Runnable((MessageStream)object, jSONObject){
                final /* synthetic */ MessageStream a;
                final /* synthetic */ JSONObject b;
                {
                    this.a = messageStream;
                    this.b = jSONObject;
                }

                @Override
                public void run() {
                    this.a.onMessageReceived(this.b);
                }
            });
        }
        catch (JSONException jSONException) {
            this.a(null, string, jSONException);
        }
    }

    private void a(String string, String string2, Throwable throwable) {
        this.f.d(throwable, "Received unsupported text message with namespace %s: %s", string, string2);
    }

    private void a(String string, String string2) {
        this.f.d("Received unsupported text message with namespace %s: %s", string, string2);
    }

    private void a(String string, byte[] byArray) {
        this.f.d("Received unsupported binary message with namespace: %s", string);
    }

    private int b(int n2) {
        switch (n2) {
            case -2: 
            case 0: {
                return 0;
            }
            case -3: {
                return -2;
            }
        }
        return -1;
    }

    private void c() {
        long l2 = SystemClock.uptimeMillis();
        if (l2 - this.j >= this.k) {
            this.f.d("timeout waiting for ping; force-closing channel", new Object[0]);
            this.b.a(-3);
        } else {
            this.e.postDelayed(this.l, 1000L);
        }
    }

    static interface a {
        public void a(ApplicationChannel var1);

        public void a(ApplicationChannel var1, int var2);

        public void b(ApplicationChannel var1, int var2);
    }
}

