/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.google.cast.ApplicationChannel;
import com.google.cast.ApplicationMetadata;
import com.google.cast.CastContext;
import com.google.cast.CastDevice;
import com.google.cast.Logger;
import com.google.cast.MimeData;
import com.google.cast.NetworkTask;
import com.google.cast.SessionError;
import com.google.cast.c;
import com.google.cast.m;
import com.google.cast.n;
import com.google.cast.o;
import java.io.IOException;

public class ApplicationSession {
    private Logger a;
    private CastContext b;
    private CastDevice c;
    private int d = 32768;
    private ApplicationMetadata e;
    private Uri f;
    private String g;
    private Listener h;
    private ApplicationChannel.a i;
    private ApplicationChannel j;
    private Handler k;
    private m l;
    private NetworkTask.Listener m;
    private NetworkTask n;
    private NetworkTask.Listener o;
    private AsyncTask<Uri, Void, Boolean> p;
    private SessionError q;
    private int r;
    private int s;
    private boolean t;
    private boolean u;
    private boolean v;
    private boolean w;
    public static final int FLAG_DISABLE_NOTIFICATION = 1;
    public static final int FLAG_DISABLE_LOCK_SCREEN_REMOTE_CONTROL = 2;
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int MIN_BUFFER_SIZE = 4096;

    public ApplicationSession(CastContext castContext, CastDevice device) throws IllegalArgumentException {
        this(castContext, device, 32768);
    }

    public ApplicationSession(CastContext castContext, CastDevice device, int bufferSize) throws IllegalArgumentException {
        if (bufferSize < 4096) {
            throw new IllegalArgumentException("bufferSize too small");
        }
        if (castContext == null) {
            throw new IllegalArgumentException("castContext cannot be null");
        }
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        this.a = new Logger("ApplicationSession");
        this.s = 0;
        this.b = castContext;
        this.c = device;
        this.d = bufferSize;
        this.m = new NetworkTask.Listener(){

            @Override
            public void onTaskCompleted() {
                if (ApplicationSession.this.t) {
                    ApplicationSession.this.l = null;
                    ApplicationSession.this.a(null);
                    return;
                }
                ApplicationSession.this.a.d("StartSessionTask completed", new Object[0]);
                long l2 = ApplicationSession.this.l.c();
                Uri uri = ApplicationSession.this.l.b();
                ApplicationSession.this.e = ApplicationSession.this.l.e();
                ApplicationSession.this.g = ApplicationSession.this.l.a();
                ApplicationSession.this.f = ApplicationSession.this.l.d();
                ApplicationSession.this.l = null;
                if (uri != null) {
                    ApplicationSession.this.a.d("connecting channel at URL: %s", uri);
                    ApplicationSession.this.j = new ApplicationChannel(ApplicationSession.this.b, ApplicationSession.this.d, l2, ApplicationSession.this.i, ApplicationSession.this.k, ApplicationSession.this.c);
                    ApplicationSession.this.a(uri);
                    if (ApplicationSession.this.e.isProtocolSupported("ramp")) {
                        com.google.cast.c.a(ApplicationSession.this.b.getApplicationContext(), ApplicationSession.this.g, ApplicationSession.this.r);
                    }
                } else {
                    ApplicationSession.this.b();
                }
            }

            @Override
            public void onTaskFailed(int status) {
                if (ApplicationSession.this.t) {
                    ApplicationSession.this.l = null;
                    ApplicationSession.this.a(null);
                    return;
                }
                ApplicationSession.this.a.d("StartSessionTask failed; status=%d", status);
                ApplicationSession.this.l = null;
                int n2 = status == -2 ? 1 : (status == 1 ? 4 : (status == 2 ? 5 : (status == 3 ? 6 : 2)));
                SessionError sessionError = new SessionError(1, n2);
                ApplicationSession.this.a.e("StartSessionTask failed with error: %s", sessionError.toString());
                ApplicationSession.this.a(sessionError);
            }

            @Override
            public void onTaskCancelled() {
                ApplicationSession.this.a.d("StartSessionTask cancelled", new Object[0]);
                ApplicationSession.this.l = null;
                ApplicationSession.this.a(null);
            }
        };
        this.o = new NetworkTask.Listener(){

            @Override
            public void onTaskCompleted() {
                ApplicationSession.this.v = true;
                ApplicationSession.this.n = null;
                ApplicationSession.this.g = null;
                ApplicationSession.this.f = null;
                ApplicationSession.this.a(null);
            }

            @Override
            public void onTaskFailed(int status) {
                SessionError sessionError;
                ApplicationSession.this.v = true;
                ApplicationSession.this.n = null;
                if (status == -4) {
                    sessionError = null;
                    ApplicationSession.this.g = null;
                    ApplicationSession.this.f = null;
                } else {
                    int n2 = status == -2 ? 1 : 2;
                    sessionError = new SessionError(4, n2);
                }
                ApplicationSession.this.a(sessionError);
            }

            @Override
            public void onTaskCancelled() {
            }
        };
        this.i = new ApplicationChannel.a(){

            @Override
            public void a(ApplicationChannel applicationChannel) {
                ApplicationSession.this.a.d("Channel is connected", new Object[0]);
                if (ApplicationSession.this.t) {
                    ApplicationSession.this.a(null);
                    return;
                }
                ApplicationSession.this.b();
            }

            @Override
            public void a(ApplicationChannel applicationChannel, int n2) {
                ApplicationSession.this.a.d("channel connection failed with error: %d", n2);
                ApplicationSession.this.j = null;
                int n3 = n2 == -2 ? 1 : 3;
                ApplicationSession.this.a(new SessionError(2, n3));
            }

            @Override
            public void b(ApplicationChannel applicationChannel, int n2) {
                ApplicationSession.this.a.d("channel disconnected with error: %d", n2);
                ApplicationSession.this.j = null;
                switch (n2) {
                    case -2: {
                        ApplicationSession.this.a(new SessionError(3, 1));
                        break;
                    }
                    case -1: {
                        ApplicationSession.this.a(new SessionError(3, 3));
                        break;
                    }
                    default: {
                        ApplicationSession.this.a(null);
                    }
                }
            }
        };
        this.k = new Handler(Looper.getMainLooper());
    }

    public void setApplicationOptions(int flags) throws IllegalArgumentException {
        if (flags > 3 || flags < 0) {
            throw new IllegalArgumentException("invalid flags: " + flags);
        }
        this.r = flags;
    }

    public int getApplicationOptions() {
        return this.r;
    }

    public Uri getApplicationInstanceUrl() {
        return this.f;
    }

    public void setStopApplicationWhenEnding(boolean stopApplication) throws IllegalStateException {
        if (this.s == 3) {
            throw new IllegalStateException("Call is not allowed while session is stopping");
        }
        this.u = stopApplication;
    }

    public void setListener(Listener listener) {
        this.h = listener;
    }

    public void startSession() throws IOException, IllegalStateException {
        this.startSession(null);
    }

    public void startSession(String applicationName) throws IOException, IllegalStateException {
        this.startSession(applicationName, null);
    }

    public void startSession(String applicationName, MimeData applicationArgument) throws IOException, IllegalStateException {
        com.google.cast.o.a();
        if (this.s != 0) {
            throw new IllegalStateException("Session is not currently stopped");
        }
        this.a();
        this.s = 1;
        this.l = new m(this.b, this.c.getApplicationUrl(), applicationName, applicationArgument);
        this.l.setListener(this.m);
        this.l.execute();
    }

    public void resumeSession() throws IOException, IllegalStateException {
        com.google.cast.o.a();
        if (this.s != 0) {
            throw new IllegalStateException("Session is not currently stopped");
        }
        if (this.f == null || this.g == null) {
            throw new IllegalStateException("No previous session to resume");
        }
        this.a();
        this.s = 1;
        this.l = new m(this.b, this.c.getApplicationUrl(), this.g, this.f);
        this.l.setListener(this.m);
        this.l.execute();
    }

    public boolean isResumable() {
        return this.s == 0 && this.f != null && this.g != null;
    }

    private void a() {
        this.s = 0;
        this.w = false;
        this.v = false;
        this.t = false;
        this.q = null;
    }

    public ApplicationMetadata getApplicationMetadata() throws IOException {
        return this.e;
    }

    public boolean hasChannel() {
        return this.j != null;
    }

    public ApplicationChannel getChannel() {
        return this.j;
    }

    public CastDevice getDevice() {
        return this.c;
    }

    public boolean endSession() throws IOException {
        com.google.cast.o.a();
        this.t = true;
        switch (this.s) {
            case 1: {
                boolean bl = false;
                if (this.p != null) {
                    this.p.cancel(true);
                    bl = true;
                }
                if (this.l != null) {
                    this.l.cancel(true);
                    bl = true;
                }
                if (!bl) {
                    this.a((SessionError)null);
                }
                return true;
            }
            case 2: {
                this.a((SessionError)null);
                return true;
            }
        }
        return false;
    }

    public boolean hasStarted() {
        return this.s == 2;
    }

    public boolean isStarting() {
        return this.s == 1;
    }

    public boolean hasStopped() {
        return this.s == 0;
    }

    private void b() {
        this.a.d("Notifying listener(s) that startup is complete", new Object[0]);
        this.w = true;
        this.s = 2;
        if (this.h != null) {
            this.h.onSessionStarted(this.e);
        }
    }

    private void a(SessionError sessionError) {
        this.s = 3;
        if (this.q == null) {
            this.q = sessionError;
        }
        if (this.j != null) {
            this.j.a();
            return;
        }
        this.e = null;
        if (this.u && !this.v && this.f != null) {
            this.n = new NetworkTask(new n(this.b, this.f));
            this.n.setListener(this.o);
            this.n.execute();
            return;
        }
        this.s = 0;
        if (this.w || this.t) {
            if (this.h != null) {
                this.h.onSessionEnded(this.q);
            }
        } else if (this.h != null) {
            this.h.onSessionStartFailed(this.q);
        }
    }

    private void a(Uri uri) {
        this.p = new AsyncTask<Uri, Void, Boolean>(){

            protected Boolean a(Uri ... uriArray) {
                boolean bl = true;
                try {
                    ApplicationSession.this.a.d("trying to connect channel to: %s", uriArray[0]);
                    ApplicationSession.this.j.a(uriArray[0]);
                }
                catch (IOException iOException) {
                    ApplicationSession.this.a.e(iOException, "error while connecting channel", new Object[0]);
                    bl = false;
                }
                ApplicationSession.this.p = null;
                return bl;
            }

            protected void onCancelled() {
                ApplicationSession.this.p = null;
                ApplicationSession.this.a(null);
            }

            protected void a(Boolean bl) {
                ApplicationSession.this.a.d("ConnectChannelTask completed with success status: %b", bl);
                ApplicationSession.this.p = null;
                if (ApplicationSession.this.t) {
                    ApplicationSession.this.a(null);
                    return;
                }
                if (!bl.booleanValue()) {
                    ApplicationSession.this.a(new SessionError(2, 3));
                }
            }

            protected /* synthetic */ void onPostExecute(Object x0) {
                this.a((Boolean)x0);
            }

            protected /* synthetic */ Object doInBackground(Object[] x0) {
                return this.a((Uri[])x0);
            }
        };
        this.p.execute((Object[])new Uri[]{uri});
    }

    public static interface Listener {
        public void onSessionStarted(ApplicationMetadata var1);

        public void onSessionStartFailed(SessionError var1);

        public void onSessionEnded(SessionError var1);
    }
}

