/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import com.google.cast.ApplicationMetadata;
import com.google.cast.CastContext;
import com.google.cast.CastDevice;
import com.google.cast.DeviceManager;
import com.google.cast.Logger;
import com.google.cast.NetworkTask;
import com.google.cast.f;
import java.util.LinkedList;
import java.util.List;

public class ApplicationSupportFilterListener
implements DeviceManager.Listener {
    private static Logger a = new Logger("ApplicationSupportFilterListener");
    private CastContext b;
    private DeviceManager.Listener c;
    private String d;
    private List<String> e;
    private LinkedList<CastDevice> f;
    private LinkedList<NetworkTask> g;

    public ApplicationSupportFilterListener(CastContext castContext, List<String> protocolList, DeviceManager.Listener downstreamListener) {
        this(castContext, null, protocolList, downstreamListener);
    }

    public ApplicationSupportFilterListener(CastContext castContext, String applicationName, DeviceManager.Listener downstreamListener) {
        this(castContext, applicationName, null, downstreamListener);
    }

    public ApplicationSupportFilterListener(CastContext castContext, String applicationName, List<String> protocolList, DeviceManager.Listener downstreamListener) {
        this.b = castContext;
        this.d = applicationName;
        this.c = downstreamListener;
        this.e = protocolList == null || protocolList.isEmpty() ? null : protocolList;
        this.f = new LinkedList();
        this.g = new LinkedList();
    }

    public boolean setFilterCriteria(String applicationName, List<String> protocolList) {
        boolean bl = false;
        if (applicationName == null != (this.d == null) || this.d != null && !this.d.equals(applicationName)) {
            this.d = applicationName;
            bl = true;
        }
        if (protocolList != null && protocolList.isEmpty()) {
            protocolList = null;
        }
        if (protocolList == null != (this.e == null)) {
            this.e = protocolList;
            bl = true;
        } else if (protocolList != null) {
            if (protocolList.size() != this.e.size()) {
                this.e = protocolList;
                bl = true;
            } else {
                for (String object : protocolList) {
                    if (this.e.contains(object)) continue;
                    this.e = protocolList;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            for (NetworkTask networkTask : this.g) {
                networkTask.cancel();
            }
            this.f.clear();
        }
        return bl;
    }

    public List<CastDevice> getAcceptedDevices() {
        return this.f;
    }

    @Override
    public void onScanStateChanged(int state) {
        if (state == 0 || state == 2) {
            for (NetworkTask networkTask : this.g) {
                networkTask.cancel();
            }
        }
        if (this.c != null) {
            this.c.onScanStateChanged(state);
        }
    }

    @Override
    public void onDeviceOnline(CastDevice device) {
        this.a(device);
    }

    @Override
    public void onDeviceOffline(CastDevice device) {
        if (this.f.remove(device) && this.c != null) {
            this.c.onDeviceOffline(device);
        }
    }

    private void a(final CastDevice castDevice) {
        Uri uri = castDevice.getApplicationUrl();
        if (uri == null) {
            return;
        }
        final f f2 = new f(this.b, uri, this.d);
        final NetworkTask networkTask = new NetworkTask(f2);
        networkTask.setListener(new NetworkTask.Listener(){

            @Override
            public void onTaskCompleted() {
                boolean bl = true;
                if (ApplicationSupportFilterListener.this.e != null) {
                    ApplicationMetadata applicationMetadata = f2.a();
                    boolean bl2 = bl = applicationMetadata != null ? applicationMetadata.areProtocolsSupported(ApplicationSupportFilterListener.this.e) : false;
                }
                if (bl) {
                    ApplicationSupportFilterListener.this.f.add(castDevice);
                    if (ApplicationSupportFilterListener.this.c != null) {
                        ApplicationSupportFilterListener.this.c.onDeviceOnline(castDevice);
                    }
                }
                ApplicationSupportFilterListener.this.g.remove((Object)networkTask);
            }

            @Override
            public void onTaskFailed(int status) {
                a.d("Device does not support app %s", ApplicationSupportFilterListener.this.d);
                ApplicationSupportFilterListener.this.g.remove((Object)networkTask);
            }

            @Override
            public void onTaskCancelled() {
                ApplicationSupportFilterListener.this.g.remove((Object)networkTask);
            }
        });
        this.g.add(networkTask);
        networkTask.execute();
    }
}

