/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.google.cast.CastContext;
import com.google.cast.CastDevice;
import com.google.cast.Logger;
import com.google.cast.NetworkTask;
import com.google.cast.SsdpScanner;
import com.google.cast.g;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DeviceManager {
    private static final int a = (int)TimeUnit.SECONDS.toSeconds(1L);
    private static final int b = (int)TimeUnit.MILLISECONDS.toMillis(1000L);
    private static final int c = b * 10;
    private CastContext d;
    private b e;
    private List<Listener> f;
    private SsdpScanner g;
    private Handler h;
    private Runnable i;
    private int j = 0;
    private Logger k = new Logger("DeviceManager");
    public static final int SCAN_STOPPED = 0;
    public static final int SCAN_STARTED = 1;
    public static final int SCAN_SUSPENDED_NETWORK_ERROR = 2;

    public DeviceManager(CastContext castContext) throws IllegalArgumentException {
        if (castContext == null) {
            throw new IllegalArgumentException("castContext cannot be null");
        }
        this.d = castContext;
        this.e = new b();
        this.f = new ArrayList<Listener>();
        this.h = new Handler(Looper.getMainLooper());
        this.i = new Runnable(){

            @Override
            public void run() {
                DeviceManager.this.c();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        List<Listener> list = this.f;
        synchronized (list) {
            if (this.f.contains(listener)) {
                throw new IllegalArgumentException("the same listener cannot be added twice");
            }
            this.f.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        List<Listener> list = this.f;
        synchronized (list) {
            this.f.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        List<Listener> list = this.f;
        synchronized (list) {
            this.f.clear();
        }
    }

    public void startScan() {
        this.k.d("startScan", new Object[0]);
        if (this.g == null) {
            this.g = new SsdpScanner(this.d.getApplicationContext(), "urn:dial-multiscreen-org:service:dial:1", a, b, this.h);
            this.g.a(new SsdpScanner.Listener(){

                @Override
                public void onSsdpResponse(SsdpScanner.SsdpResponse response) {
                    DeviceManager.this.a(response);
                }

                @Override
                public void onNetworkError() {
                    DeviceManager.this.d();
                    DeviceManager.this.a(2);
                }

                @Override
                public void onResultsInvalidated() {
                    DeviceManager.this.d();
                }
            });
        }
        this.a(1);
        this.g.a();
        this.h.postDelayed(this.i, (long)c);
    }

    public void stopScan() {
        this.b();
        this.a(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        if (this.g == null) {
            return;
        }
        this.g.b();
        this.h.removeCallbacksAndMessages(null);
        b b2 = this.e;
        synchronized (b2) {
            for (a a2 : this.e.a) {
                if (a2.d == null) continue;
                a2.d.cancel();
            }
            this.e.a.clear();
        }
    }

    public void clearDevices() {
        this.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CastDevice> getDevices() {
        ArrayList<CastDevice> arrayList = new ArrayList<CastDevice>();
        b b2 = this.e;
        synchronized (b2) {
            for (a a2 : this.e.b) {
                arrayList.add(a2.b);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(SsdpScanner.SsdpResponse ssdpResponse) {
        long l2 = System.currentTimeMillis();
        b b2 = this.e;
        synchronized (b2) {
            InetAddress inetAddress;
            for (a object2 : this.e.a) {
                if (!object2.a.equals(ssdpResponse.getUsn())) continue;
                if (!object2.f) {
                    object2.e = l2;
                }
                return;
            }
            for (a a2 : this.e.b) {
                if (!a2.a.equals(ssdpResponse.getUsn())) continue;
                a2.e = l2;
                return;
            }
            Uri uri = Uri.parse((String)ssdpResponse.getLocation());
            Object var6_8 = null;
            try {
                inetAddress = InetAddress.getByName(uri.getHost());
                if (!(inetAddress instanceof Inet4Address)) {
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                return;
            }
            final a a3 = new a();
            a3.b = new CastDevice((Inet4Address)inetAddress);
            a3.a = ssdpResponse.getUsn();
            a3.e = l2;
            a3.c = new g(this.d, uri, a3.b);
            a3.d = new NetworkTask(a3.c);
            a3.d.setListener(new NetworkTask.Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTaskCompleted() {
                    CastDevice castDevice = null;
                    Object object = DeviceManager.this.e;
                    synchronized (object) {
                        ((DeviceManager)DeviceManager.this).e.a.remove(a3);
                        ((DeviceManager)DeviceManager.this).e.b.add(a3);
                        a3.c = null;
                        a3.d = null;
                        castDevice = a3.b;
                    }
                    DeviceManager.this.k.d("onDeviceOnline", new Object[0]);
                    object = DeviceManager.this.e();
                    if (object != null) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Listener listener = (Listener)iterator.next();
                            listener.onDeviceOnline(castDevice);
                        }
                    }
                }

                @Override
                public void onTaskFailed(int result) {
                    a3.f = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTaskCancelled() {
                    b b2 = DeviceManager.this.e;
                    synchronized (b2) {
                        ((DeviceManager)DeviceManager.this).e.a.remove(a3);
                    }
                }
            });
            this.e.a.add(a3);
            a3.d.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        Object object;
        LinkedList<CastDevice> linkedList = null;
        long l2 = System.currentTimeMillis();
        Object object2 = this.e;
        synchronized (object2) {
            Iterator<a> iterator = this.e.a.iterator();
            while (iterator.hasNext()) {
                a object3 = iterator.next();
                if (!object3.a(l2)) continue;
                iterator.remove();
            }
            Iterator<a> iterator2 = this.e.b.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (!((a)object).a(l2)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<CastDevice>();
                }
                linkedList.add(((a)object).b);
                iterator2.remove();
            }
        }
        if (linkedList != null && (object2 = this.e()) != null) {
            for (CastDevice castDevice : linkedList) {
                object = object2.iterator();
                while (object.hasNext()) {
                    Listener listener = (Listener)object.next();
                    listener.onDeviceOffline(castDevice);
                }
            }
        }
        this.h.postDelayed(this.i, (long)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        this.k.d("flushing device list", new Object[0]);
        b b2 = this.e;
        synchronized (b2) {
            this.e.a.clear();
            if (!this.e.b.isEmpty()) {
                List<Listener> list = this.e();
                if (list != null) {
                    for (a a2 : this.e.b) {
                        for (Listener listener : list) {
                            listener.onDeviceOffline(a2.b);
                        }
                    }
                }
                this.e.b.clear();
            }
        }
    }

    private void a(final int n2) {
        if (this.j == n2) {
            return;
        }
        this.k.d("notifyStateChanged: %d", n2);
        this.j = n2;
        final List<Listener> list = this.e();
        if (list != null) {
            this.h.post(new Runnable(){

                @Override
                public void run() {
                    for (Listener listener : list) {
                        listener.onScanStateChanged(n2);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Listener> e() {
        ArrayList<Listener> arrayList = null;
        List<Listener> list = this.f;
        synchronized (list) {
            if (!this.f.isEmpty()) {
                arrayList = new ArrayList<Listener>(this.f);
            }
        }
        return arrayList;
    }

    private class b {
        public final List<a> a = new ArrayList<a>();
        public final List<a> b = new ArrayList<a>();
    }

    private class a {
        String a;
        CastDevice b;
        g c;
        NetworkTask d;
        long e;
        boolean f;

        private a() {
        }

        boolean a(long l2) {
            return l2 - this.e >= (long)c;
        }
    }

    public static interface Listener {
        public void onScanStateChanged(int var1);

        public void onDeviceOnline(CastDevice var1);

        public void onDeviceOffline(CastDevice var1);
    }
}

