/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.webkit.URLUtil;
import com.google.cast.CastContext;
import com.google.cast.Logger;
import com.google.cast.MimeData;
import com.google.cast.NetworkRequest;
import com.google.cast.SimpleHttpRequest;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class FetchBitmapRequest
extends NetworkRequest {
    private static final Logger a = new Logger("FetchBitmapRequest");
    private int b;
    private int c;
    protected Bitmap mBitmap;
    protected Uri mImageUrl;

    public FetchBitmapRequest(CastContext castContext, Uri imageUrl) throws IllegalArgumentException {
        this(castContext, imageUrl, 0, 0);
    }

    public FetchBitmapRequest(CastContext castContext, Uri imageUrl, int preferredWidth, int preferredHeight) throws IllegalArgumentException {
        super(castContext);
        if (imageUrl == null) {
            throw new IllegalArgumentException("image URL cannot be null");
        }
        this.mImageUrl = imageUrl;
        this.b = preferredWidth < 0 ? 0 : preferredWidth;
        this.c = preferredHeight < 0 ? 0 : preferredHeight;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public int execute() {
        try {
            a.d("Fetching image", new Object[0]);
            if (!URLUtil.isValidUrl((String)this.mImageUrl.toString())) {
                return -1;
            }
            SimpleHttpRequest simpleHttpRequest = this.performHttpGet(this.mImageUrl, DEFAULT_TIMEOUT);
            if (simpleHttpRequest.getResponseStatus() != 200) {
                return -1;
            }
            MimeData mimeData = simpleHttpRequest.getResponseData();
            if (mimeData == null) {
                return -3;
            }
            byte[] byArray = mimeData.getData();
            if (byArray == null) {
                return -3;
            }
            this.mBitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            if (this.mBitmap == null) {
                return -3;
            }
            a.d("retrieved an image of size %dx%d", this.mBitmap.getWidth(), this.mBitmap.getHeight());
            if (this.b != 0 && this.c != 0) {
                this.mBitmap = this.a(this.mBitmap);
            }
        }
        catch (IOException iOException) {
            a.d(iOException, "exception while retrieving icon", new Object[0]);
            return -1;
        }
        catch (TimeoutException timeoutException) {
            return -2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            a.d(outOfMemoryError, "Out of memory when fetching bitmap", new Object[0]);
            return -1;
        }
        return 0;
    }

    private Bitmap a(Bitmap bitmap) {
        float f2;
        float f3;
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = n2 - this.b;
        int n5 = n3 - this.c;
        if (n4 == 0 || n5 == 0) {
            return bitmap;
        }
        float f4 = 0.0f;
        if (n4 > 0 || n5 > 0) {
            f3 = (float)this.b / (float)n2;
            f2 = (float)this.c / (float)n3;
            f4 = Math.min(f2, f3);
        } else {
            f3 = (float)n2 / (float)this.b;
            f2 = (float)n3 / (float)this.c;
            f4 = Math.min(f2, f3);
        }
        int n6 = (int)((float)n2 * f4 + 0.5f);
        int n7 = (int)((float)n3 * f4 + 0.5f);
        a.d("scaling drawable %dx%d to %dx%d", n2, n3, n6, n7);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n6, (int)n7, (boolean)false);
    }
}

