/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtils {
    private static final Class<?>[] a = new Class[]{Integer.TYPE};

    private JsonUtils() {
    }

    public static <E extends Enum<?>> E getEnumValue(JSONObject object, String key, E defaultValue, Class<E> enumClass) {
        if (!object.has(key)) {
            return defaultValue;
        }
        try {
            int n2 = object.getInt(key);
            Method method = enumClass.getDeclaredMethod("fromInt", a);
            if (method != null && (method.getModifiers() & 8) != 0) {
                return (E)((Enum)method.invoke(null, n2));
            }
        }
        catch (JSONException jSONException) {
            return defaultValue;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return defaultValue;
        }
        catch (IllegalAccessException illegalAccessException) {
            return defaultValue;
        }
        catch (InvocationTargetException invocationTargetException) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static <E extends Enum<?>> boolean setEnumValue(JSONObject object, String key, E value) {
        int n2 = 0;
        try {
            Field field = value.getClass().getField("code");
            n2 = field.getInt(value);
            object.put(key, n2);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    public static boolean areJsonStringsEquivalent(String expectedJson, String actualJson) {
        if (expectedJson == null && actualJson == null) {
            return true;
        }
        if (expectedJson == null || actualJson == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(expectedJson);
            JSONObject jSONObject2 = new JSONObject(actualJson);
            return JsonUtils.a(jSONObject, jSONObject2);
        }
        catch (JSONException jSONException) {
            try {
                JSONArray jSONArray = new JSONArray(expectedJson);
                JSONArray jSONArray2 = new JSONArray(actualJson);
                return JsonUtils.a(jSONArray, jSONArray2);
            }
            catch (JSONException jSONException2) {
                return false;
            }
        }
    }

    private static boolean a(Object object, Object object2) {
        if (object instanceof JSONObject && object2 instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = (JSONObject)object2;
            if (jSONObject.length() != jSONObject2.length()) {
                return false;
            }
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!jSONObject2.has(string2)) {
                    return false;
                }
                try {
                    Object object3;
                    Object object4 = jSONObject.get(string2);
                    if (JsonUtils.a(object4, object3 = jSONObject2.get(string2))) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        if (object instanceof JSONArray && object2 instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = (JSONArray)object2;
            if (jSONArray.length() != jSONArray2.length()) {
                return false;
            }
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    Object object5 = jSONArray.get(i2);
                    Object object6 = jSONArray2.get(i2);
                    if (JsonUtils.a(object5, object6)) continue;
                    return false;
                }
                catch (JSONException jSONException) {
                    return false;
                }
            }
            return true;
        }
        return object.equals(object2);
    }
}

