/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.os.SystemClock;
import com.google.cast.ContentMetadata;
import com.google.cast.Logger;
import com.google.cast.MediaProtocolCommand;
import com.google.cast.MediaTrack;
import com.google.cast.MessageStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaProtocolMessageStream
extends MessageStream {
    public static final String NAMESPACE = "ramp";
    private static final Logger a = new Logger("MediaProtocolMessageStream");
    private PlayerState b;
    private String c;
    private JSONObject d;
    private double e;
    private double f;
    private double g;
    private boolean h;
    private long i;
    private boolean j;
    private String k;
    private Map<Long, MediaTrack> l = new HashMap<Long, MediaTrack>();
    private Uri m;
    private long n;
    private long o = -1L;
    private Map<Long, MediaProtocolCommand> p = new HashMap<Long, MediaProtocolCommand>();
    private long q = -1L;

    public MediaProtocolMessageStream() {
        super(NAMESPACE);
    }

    public final MediaProtocolCommand requestStatus() throws IOException, IllegalStateException {
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "INFO");
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        return mediaProtocolCommand;
    }

    public final MediaProtocolCommand loadMedia(String contentId, ContentMetadata contentMetadata) throws IOException, IllegalStateException {
        return this.loadMedia(contentId, contentMetadata, false);
    }

    public final MediaProtocolCommand loadMedia(String contentId, ContentMetadata contentMetadata, boolean autoplay) throws IOException, IllegalStateException {
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "LOAD");
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
            jSONObject.put("src", (Object)contentId);
            if (autoplay) {
                jSONObject.put("autoplay", autoplay);
            }
            if (contentMetadata != null) {
                if (contentMetadata.getContentInfo() != null) {
                    this.d = contentMetadata.getContentInfo();
                    jSONObject.put("content_info", (Object)this.d);
                } else {
                    this.d = null;
                }
                if (contentMetadata.getTitle() != null) {
                    this.k = contentMetadata.getTitle();
                    jSONObject.put("title", (Object)this.k);
                } else {
                    this.k = null;
                }
                if (contentMetadata.getImageUrl() != null) {
                    this.m = contentMetadata.getImageUrl();
                    jSONObject.put("image_url", (Object)this.m.toString());
                } else {
                    this.m = null;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        return mediaProtocolCommand;
    }

    public final void sendKeyResponse(long requestId, String[] tokens) throws IOException, IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        try {
            int n2 = tokens.length;
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < n2; ++i2) {
                jSONArray.put(i2, (Object)tokens[i2]);
            }
            jSONObject.put("cmd_id", requestId);
            jSONObject.put("type", (Object)"KEY_RESPONSE");
            jSONObject.put("tokens", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
    }

    public final MediaProtocolCommand resume() throws IOException, IllegalStateException {
        return this.playFrom(-1.0);
    }

    public final MediaProtocolCommand play() throws IOException, IllegalStateException {
        return this.playFrom(0.0);
    }

    public final MediaProtocolCommand playFrom(double position) throws IOException, IllegalStateException {
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "PLAY");
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
            if (position >= 0.0) {
                jSONObject.put("position", position);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        return mediaProtocolCommand;
    }

    public final void stop() throws IOException, IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", ++this.n);
            jSONObject.put("type", (Object)"STOP");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
    }

    public final MediaProtocolCommand setVolume(double volume) throws IOException, IllegalStateException {
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "VOLUME");
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
            jSONObject.put("volume", this.a(volume));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        this.q = mediaProtocolCommand.a();
        this.g = volume;
        return mediaProtocolCommand;
    }

    public final MediaProtocolCommand setMuted(boolean muted) throws IOException, IllegalStateException {
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "VOLUME");
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
            jSONObject.put("muted", muted);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        return mediaProtocolCommand;
    }

    public final MediaProtocolCommand selectMediaTracks(Set<Long> tracksToEnable, Set<Long> tracksToDisable) throws IOException, IllegalArgumentException, IllegalStateException {
        if ((tracksToEnable == null || tracksToEnable.isEmpty()) && (tracksToDisable == null || tracksToDisable.isEmpty())) {
            throw new IllegalArgumentException("Both lists can't be null or empty.");
        }
        MediaProtocolCommand mediaProtocolCommand = new MediaProtocolCommand(++this.n, "SELECT_TRACKS");
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray;
            jSONObject.put("cmd_id", mediaProtocolCommand.a());
            jSONObject.put("type", (Object)mediaProtocolCommand.getType());
            if (tracksToEnable != null && !tracksToEnable.isEmpty()) {
                jSONArray = new JSONArray();
                for (Long l2 : tracksToEnable) {
                    jSONArray.put((Object)l2);
                }
                jSONObject.put("enabled", (Object)jSONArray);
            }
            if (tracksToDisable != null && !tracksToDisable.isEmpty()) {
                jSONArray = new JSONArray();
                for (Long l2 : tracksToDisable) {
                    jSONArray.put((Object)l2);
                }
                jSONObject.put("disabled", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.sendMessage(jSONObject);
        this.p.put(mediaProtocolCommand.a(), mediaProtocolCommand);
        return mediaProtocolCommand;
    }

    public final boolean cancelCommand(MediaProtocolCommand command) {
        if (!this.p.containsValue(command)) {
            return false;
        }
        this.p.remove(command.a());
        command.c();
        if (command.a() == this.q) {
            this.q = -1L;
        }
        return true;
    }

    public final PlayerState getPlayerState() {
        return this.b;
    }

    public final String getContentId() {
        return this.c;
    }

    public final JSONObject getContentInfo() {
        return this.d;
    }

    public final String getTitle() {
        return this.k;
    }

    public final double getStreamPosition() {
        double d2;
        if (this.i == 0L) {
            return 0.0;
        }
        if (!this.j) {
            return this.e;
        }
        double d3 = (double)(SystemClock.elapsedRealtime() - this.i) / 1000.0;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if ((d2 = this.e + d3) > this.f) {
            d2 = this.f;
        }
        return d2;
    }

    public final boolean isStreamProgressing() {
        return this.j;
    }

    public final double getStreamDuration() {
        return this.f;
    }

    public final double getVolume() {
        return this.g;
    }

    public final boolean isMuted() {
        return this.h;
    }

    public final Uri getImageUrl() {
        return this.m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MediaTrack> getMediaTracks() {
        Map<Long, MediaTrack> map = this.l;
        synchronized (map) {
            ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>(this.l.size());
            for (MediaTrack mediaTrack : this.l.values()) {
                try {
                    arrayList.add((MediaTrack)mediaTrack.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            return arrayList;
        }
    }

    @Override
    public final void onMessageReceived(JSONObject message) {
        a.v("Received message: \"%s\"", message);
        try {
            String string2 = message.getString("type");
            if ("RESPONSE".equals(string2)) {
                long l2 = message.getLong("cmd_id");
                MediaProtocolCommand mediaProtocolCommand = this.p.remove(l2);
                if (l2 == this.q) {
                    this.q = -1L;
                }
                if (mediaProtocolCommand == null) {
                    a.w("Got a response to an unknown request: %s", message);
                    return;
                }
                if (message.has("status")) {
                    JSONObject jSONObject = message.getJSONObject("status");
                    this.a(jSONObject);
                    if (jSONObject.has("error")) {
                        a.d("message has an error!", new Object[0]);
                        JSONObject jSONObject2 = jSONObject.getJSONObject("error");
                        String string3 = jSONObject2.getString("domain");
                        long l3 = jSONObject2.getLong("code");
                        JSONObject jSONObject3 = jSONObject2.optJSONObject("error_info");
                        mediaProtocolCommand.a(string3, l3, jSONObject3);
                    } else if (mediaProtocolCommand.getType().equals("LOAD")) {
                        this.e = 0.0;
                        this.i = 0L;
                    }
                }
                mediaProtocolCommand.b();
            } else if ("STATUS".equals(string2)) {
                JSONObject jSONObject = message.getJSONObject("status");
                this.a(jSONObject);
                if (jSONObject.has("error")) {
                    JSONObject jSONObject4 = jSONObject.getJSONObject("error");
                    String string4 = jSONObject4.getString("domain");
                    long l4 = jSONObject4.getLong("code");
                    JSONObject jSONObject5 = jSONObject4.optJSONObject("error_info");
                    this.onError(string4, l4, jSONObject5);
                }
            } else if ("KEY_REQUEST".equals(string2)) {
                long l5 = message.getLong("cmd_id");
                String string5 = message.getString("method");
                JSONArray jSONArray = message.getJSONArray("requests");
                int n2 = jSONArray.length();
                String[] stringArray = new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringArray[i2] = jSONArray.get(i2).toString();
                }
                this.onKeyRequested(l5, string5, stringArray);
            } else {
                a.w("Ignoring message. Got a request with unknown request type=" + string2, new Object[0]);
            }
        }
        catch (JSONException jSONException) {
            a.e("error parsing message: %s %s", new Object[]{message, jSONException});
        }
    }

    protected void onStatusUpdated() {
    }

    protected void onTrackListUpdated() {
    }

    protected void onError(String errorDomain, long errorCode, JSONObject errorInfo) {
    }

    protected void onKeyRequested(long requestId, String method, String[] requests) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(JSONObject jSONObject) throws JSONException {
        Map<Long, MediaTrack> map;
        if (jSONObject.has("event_sequence")) {
            long l2 = jSONObject.getLong("event_sequence");
            if (l2 < this.o) {
                return;
            }
            this.o = l2;
        }
        PlayerState playerState = PlayerState.IDLE;
        int n2 = jSONObject.getInt("state");
        switch (n2) {
            case 0: {
                playerState = PlayerState.IDLE;
                break;
            }
            case 1: {
                playerState = PlayerState.STOPPED;
                break;
            }
            case 2: {
                playerState = PlayerState.PLAYING;
                break;
            }
            default: {
                throw new JSONException("invalid state value: " + n2);
            }
        }
        this.b = playerState;
        String string2 = jSONObject.optString("content_id", null);
        boolean bl = !(this.c != null && this.c.equals(string2) || this.c == null && string2 == null);
        this.c = string2;
        this.d = jSONObject.optJSONObject("content_info");
        this.e = jSONObject.optDouble("current_time", 0.0);
        this.i = SystemClock.elapsedRealtime();
        this.f = jSONObject.optDouble("duration", 0.0);
        this.j = jSONObject.optBoolean("time_progress", false);
        this.k = jSONObject.optString("title", null);
        if (this.q == -1L) {
            this.g = this.a(jSONObject.optDouble("volume", 0.0));
        }
        this.h = jSONObject.optBoolean("muted");
        boolean bl2 = false;
        if (bl) {
            map = this.l;
            synchronized (map) {
                this.l.clear();
                bl2 = true;
            }
        }
        if (jSONObject.has("image_url")) {
            this.m = Uri.parse((String)jSONObject.optString("image_url"));
        }
        if (jSONObject.has("tracks")) {
            map = this.l;
            synchronized (map) {
                JSONArray jSONArray = jSONObject.getJSONArray("tracks");
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                    long l3 = jSONObject2.getLong("id");
                    boolean bl3 = jSONObject2.optBoolean("selected", false);
                    MediaTrack mediaTrack = this.l.get(l3);
                    if (mediaTrack != null) {
                        if (mediaTrack.isEnabled() == bl3) continue;
                        mediaTrack.a(bl3);
                        bl2 = true;
                        continue;
                    }
                    String string3 = jSONObject2.getString("type");
                    String string4 = jSONObject2.optString("name", null);
                    String string5 = jSONObject2.optString("lang", null);
                    MediaTrack.Type type = null;
                    if (string3.equalsIgnoreCase("subtitles")) {
                        type = MediaTrack.Type.SUBTITLES;
                    } else if (string3.equalsIgnoreCase("captions")) {
                        type = MediaTrack.Type.CAPTIONS;
                    } else if (string3.equalsIgnoreCase("audio")) {
                        type = MediaTrack.Type.AUDIO;
                    } else if (string3.equalsIgnoreCase("video")) {
                        type = MediaTrack.Type.VIDEO;
                    }
                    if (type == null) {
                        throw new JSONException("invalid track type: " + string3);
                    }
                    this.l.put(l3, new MediaTrack(l3, type, string4, string5, bl3));
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.onTrackListUpdated();
        }
        this.onStatusUpdated();
    }

    @Override
    public void onDetached() {
        for (MediaProtocolCommand mediaProtocolCommand : this.p.values()) {
            mediaProtocolCommand.c();
        }
        this.b = PlayerState.IDLE;
        this.c = null;
        this.d = null;
        this.e = 0.0;
        this.f = 0.0;
        this.g = 0.0;
        this.h = false;
        this.i = 0L;
        this.j = false;
        this.k = null;
        this.l.clear();
        this.m = null;
        this.o = 0L;
        this.p.clear();
        this.q = -1L;
    }

    private double a(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        return d2;
    }

    @Override
    protected void sendMessage(JSONObject message) throws IOException, IllegalStateException {
        a.v("Sending message: \"%s\"", message);
        super.sendMessage(message);
    }

    public static enum PlayerState {
        IDLE,
        STOPPED,
        PLAYING;

    }
}

