/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.content.Context;
import android.content.Intent;
import android.support.v7.media.MediaRouteProvider;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import com.google.cast.CastContext;
import com.google.cast.Logger;
import com.google.cast.MediaRouteAdapter;
import com.google.cast.MimeData;
import com.google.cast.b;
import com.google.cast.i;
import com.google.cast.o;
import java.util.List;

public final class MediaRouteHelper {
    private static Logger a = new Logger("MediaRouteHelper");
    private static MediaRouteProvider b;
    public static final String CATEGORY_CAST = "com.google.cast.CATEGORY_CAST";
    public static final String CATEGORY_PREFIX_CAST_APP_NAME = "com.google.cast.CATEGORY_CAST_APP_NAME:";
    public static final String CATEGORY_PREFIX_CAST_APP_PROTOCOLS = "com.google.cast.CATEGORY_CAST_APP_PROTOCOLS:";

    private MediaRouteHelper() {
    }

    public static boolean registerMediaRouteProvider(CastContext castContext) {
        return MediaRouteHelper.registerMediaRouteProvider(castContext, null, null, 0, false);
    }

    public static boolean registerMediaRouteProvider(CastContext castContext, String receiverApplicationName, MimeData receiverApplicationArgument, int sessionOptions, boolean stopApplicationWhenRouteDeselected) {
        o.a();
        if (b != null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)receiverApplicationName)) {
            receiverApplicationName = null;
        }
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)castContext.getApplicationContext());
        b = new b(castContext, receiverApplicationName, receiverApplicationArgument, sessionOptions, stopApplicationWhenRouteDeselected);
        mediaRouter.addProvider(b);
        return true;
    }

    public static boolean registerMinimalMediaRouteProvider(CastContext castContext, MediaRouteAdapter adapter) {
        o.a();
        if (b != null) {
            return false;
        }
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)castContext.getApplicationContext());
        b = new i(castContext, adapter);
        mediaRouter.addProvider(b);
        return true;
    }

    public static void unregisterMediaRouteProvider(CastContext castContext) {
        o.a();
        if (b == null) {
            return;
        }
        MediaRouter mediaRouter = MediaRouter.getInstance((Context)castContext.getApplicationContext());
        mediaRouter.removeProvider(b);
        b = null;
    }

    public static MediaRouteSelector buildMediaRouteSelector(String controlCategory) {
        return MediaRouteHelper.buildMediaRouteSelector(controlCategory, null, null);
    }

    public static MediaRouteSelector buildMediaRouteSelector(String controlCategory, String appName, List<String> protocols) throws IllegalArgumentException {
        MediaRouteSelector.Builder builder = new MediaRouteSelector.Builder();
        builder.addControlCategory(controlCategory);
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            builder.addControlCategory(CATEGORY_PREFIX_CAST_APP_NAME + appName);
        }
        if (protocols != null && !protocols.isEmpty()) {
            builder.addControlCategory(CATEGORY_PREFIX_CAST_APP_PROTOCOLS + TextUtils.join((CharSequence)",", protocols));
        }
        return builder.build();
    }

    public static boolean requestCastDeviceForRoute(MediaRouter.RouteInfo route) {
        if (b == null || !(b instanceof i)) {
            return false;
        }
        Intent intent = new Intent("com.google.cast.ACTION_GET_DEVICE");
        intent.putExtra("com.google.cast.EXTRA_ROUTE_ID", route.getId());
        intent.addCategory(CATEGORY_CAST);
        route.sendControlRequest(intent, null);
        return true;
    }
}

