/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.text.TextUtils;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONObject;

public final class MimeData {
    public static final String TYPE_BINARY = "application/octet-stream";
    public static final String TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String TYPE_HTML = "text/html";
    public static final String TYPE_JSON = "application/json";
    public static final String TYPE_TEXT = "text/plain";
    public static final String TYPE_URL = "text/url";
    public static final String TYPE_XML = "application/xml";
    private static final Charset a = Charset.forName("UTF-8");
    private byte[] b;
    private String c;

    public MimeData(String data, String type) throws IllegalArgumentException {
        this.a(type);
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.b = data.getBytes(a);
        this.c = type;
    }

    public MimeData(byte[] data, String type) throws IllegalArgumentException {
        this.a(type);
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.b = data;
        this.c = type;
    }

    public String getTextData() {
        return this.b != null ? new String(this.b, a) : null;
    }

    public byte[] getData() {
        return this.b;
    }

    public String getType() {
        return this.c;
    }

    public String toString() {
        return "[MimeData; type: " + this.c + ", length: " + this.b.length + "]";
    }

    public static MimeData createJsonData(JSONObject json) {
        return new MimeData(json.toString(), TYPE_JSON);
    }

    public static MimeData createJsonData(JSONArray json) {
        return new MimeData(json.toString(), TYPE_JSON);
    }

    public static MimeData createUrlData(Uri url) {
        return new MimeData(url.toString(), TYPE_URL);
    }

    private void a(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("mime type cannot be null or empty");
        }
    }
}

