/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import com.google.cast.CastContext;
import com.google.cast.Logger;
import com.google.cast.MimeData;
import com.google.cast.SimpleHttpRequest;
import com.google.cast.k;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class NetworkRequest {
    public static final int DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = -1;
    public static final int STATUS_TIMEOUT = -2;
    public static final int STATUS_INVALID_RESPONSE = -3;
    public static final int STATUS_NOT_FOUND = -4;
    public static final int STATUS_ACCESS_DENIED = -5;
    public static final int STATUS_BUSY = -6;
    public static final int STATUS_NOT_SUPPORTED = -7;
    public static final int STATUS_CANCELLED = -99;
    private SimpleHttpRequest a;
    private Object b = new Object();
    private boolean c;
    private Logger d;
    protected CastContext mCastContext;

    protected NetworkRequest(CastContext castContext) throws IllegalArgumentException {
        if (castContext == null) {
            throw new IllegalArgumentException("cast context cannot be null");
        }
        this.mCastContext = castContext;
        this.d = new Logger("NetworkRequest");
    }

    public abstract int execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.b;
        synchronized (object) {
            this.c = true;
            if (this.a != null) {
                this.a.cancel();
            }
        }
    }

    protected final boolean isCancelled() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleHttpRequest performHttpGet(Uri uri, int timeout) throws IOException, TimeoutException {
        this.d.d("performGet: %s", uri);
        SimpleHttpRequest simpleHttpRequest = this.constructHttpRequest(timeout);
        simpleHttpRequest.setRequestHeader("Origin", "https://www.google.com");
        try {
            Object object = this.b;
            synchronized (object) {
                this.a = simpleHttpRequest;
            }
            simpleHttpRequest.performGet(uri);
        }
        catch (IOException iOException) {
            this.d.d("HTTP GET error: %s", iOException);
            throw iOException;
        }
        catch (TimeoutException timeoutException) {
            this.d.d("HTTP GET timeout: %s", timeoutException);
            throw timeoutException;
        }
        finally {
            Object object = this.b;
            synchronized (object) {
                this.a = null;
            }
        }
        return simpleHttpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleHttpRequest performHttpPost(Uri uri, MimeData data, int timeout) throws IOException, TimeoutException {
        this.d.d("performPost: %s", uri);
        SimpleHttpRequest simpleHttpRequest = this.constructHttpRequest(timeout);
        simpleHttpRequest.setRequestHeader("Origin", "https://www.google.com");
        try {
            Object object = this.b;
            synchronized (object) {
                this.a = simpleHttpRequest;
            }
            simpleHttpRequest.performPost(uri, data);
        }
        catch (IOException iOException) {
            this.d.d("HTTP POST error: %s", iOException);
            throw iOException;
        }
        catch (TimeoutException timeoutException) {
            this.d.d("HTTP POST timeout: %s", timeoutException);
            throw timeoutException;
        }
        finally {
            Object object = this.b;
            synchronized (object) {
                this.a = null;
            }
        }
        return simpleHttpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleHttpRequest performHttpDelete(Uri uri, int timeout) throws IOException, TimeoutException {
        this.d.d("performDelete: %s", uri);
        SimpleHttpRequest simpleHttpRequest = this.constructHttpRequest(timeout);
        simpleHttpRequest.setRequestHeader("Origin", "https://www.google.com");
        try {
            Object object = this.b;
            synchronized (object) {
                this.a = simpleHttpRequest;
            }
            simpleHttpRequest.performDelete(uri);
        }
        catch (IOException iOException) {
            this.d.d("HTTP DELETE error: %s", iOException);
            throw iOException;
        }
        catch (TimeoutException timeoutException) {
            this.d.d("HTTP DELETE timeout: %s", timeoutException);
            throw timeoutException;
        }
        finally {
            Object object = this.b;
            synchronized (object) {
                this.a = null;
            }
        }
        return simpleHttpRequest;
    }

    protected SimpleHttpRequest constructHttpRequest(int timeout) {
        return new k(this.mCastContext, timeout, timeout);
    }
}

