/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.text.TextUtils;
import com.google.cast.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

class SsdpScanner {
    private Context a;
    private MulticastSocket b;
    private InetSocketAddress c;
    private String d;
    private int e;
    private int f;
    private Listener g;
    private Handler h;
    private volatile boolean i;
    private Thread j;
    private Thread k;
    private AtomicBoolean l;
    private ConnectivityManager m;
    private a n;
    private WifiManager o;
    private String p;
    private volatile boolean q;
    private Logger r = new Logger("SsdpScanner");

    public SsdpScanner(Context context, String target, int maxWaitTimeSeconds, int delayBetweenMessagesMillis, Handler handler) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        if (maxWaitTimeSeconds < 1) {
            throw new IllegalArgumentException("delay must be at least 1 second");
        }
        this.a = context;
        this.d = target;
        this.f = delayBetweenMessagesMillis;
        this.e = maxWaitTimeSeconds;
        this.h = handler;
        this.c = new InetSocketAddress("239.255.255.250", 1900);
        this.l = new AtomicBoolean();
        this.m = (ConnectivityManager)this.a.getSystemService("connectivity");
        if (this.a.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            this.o = (WifiManager)this.a.getSystemService("wifi");
        } else {
            this.r.d("Don't have Wifi permissions.", new Object[0]);
        }
    }

    public void a(Listener listener) {
        this.g = listener;
    }

    public void a() {
        Object object;
        this.r.d("start", new Object[0]);
        if (this.b != null) {
            return;
        }
        this.i();
        try {
            NetworkInterface networkInterface = this.d();
            if (networkInterface == null) {
                this.r.d("No suitable network interface!", new Object[0]);
                this.h();
                return;
            }
            object = new MulticastSocket();
            ((MulticastSocket)object).setNetworkInterface(networkInterface);
            ((MulticastSocket)object).setTimeToLive(2);
            this.b = object;
        }
        catch (IOException iOException) {
            this.r.e(iOException, "couldn't create socket", new Object[0]);
            this.h();
            return;
        }
        this.q = false;
        this.i = false;
        this.l.set(false);
        this.j = new Thread(){

            @Override
            public void run() {
                SsdpScanner.this.e();
            }
        };
        this.j.start();
        this.k = new Thread(){

            @Override
            public void run() {
                SsdpScanner.this.f();
            }
        };
        this.k.start();
        boolean bl = false;
        if (this.o != null) {
            object = null;
            WifiInfo wifiInfo = this.o.getConnectionInfo();
            if (wifiInfo != null) {
                object = wifiInfo.getBSSID();
            }
            if (this.p == null || object == null || !this.p.equals(object)) {
                this.r.d("BSSID changed", new Object[0]);
                bl = true;
            }
            this.p = object;
        } else {
            bl = true;
        }
        if (bl && this.g != null) {
            this.g.onResultsInvalidated();
        }
        this.r.d("scan started", new Object[0]);
    }

    public void b() {
        this.j();
        this.c();
    }

    private void c() {
        if (this.b == null) {
            return;
        }
        this.i = true;
        this.b.close();
        while (this.j != null) {
            this.j.interrupt();
            try {
                this.j.join();
                this.j = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.k != null) {
            this.k.interrupt();
            try {
                this.k.join();
                this.k = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.b = null;
    }

    private NetworkInterface d() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isPointToPoint() || !networkInterface.supportsMulticast()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (!(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                    this.r.d("Multicast using: %s", networkInterface.getDisplayName());
                    return networkInterface;
                }
            }
        }
        return null;
    }

    private void e() {
        block5: {
            String string2 = String.format(Locale.getDefault(), "M-SEARCH * HTTP/1.1\r\nHOST: %s:%d\r\nMAN: \"ssdp:discover\"\r\nMX: %d\r\nST: %s\r\n\r\n", "239.255.255.250", 1900, this.e, this.d);
            byte[] byArray = string2.getBytes();
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.c);
                while (!this.i) {
                    this.b.send(datagramPacket);
                    try {
                        Thread.sleep(this.f);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                this.r.d(iOException, "Send thread got an exception; mShouldStop=" + this.i, new Object[0]);
                if (this.i) break block5;
                this.g();
            }
        }
    }

    private void f() {
        block13: {
            byte[] byArray = new byte[4096];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                while (!this.i) {
                    try {
                        this.b.receive(datagramPacket);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    if (!this.i) {
                        String string2;
                        final SsdpResponse ssdpResponse = new SsdpResponse();
                        String string3 = new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), "UTF8");
                        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
                        while ((string2 = bufferedReader.readLine()) != null) {
                            String string4 = string2.toUpperCase(Locale.getDefault());
                            if (string4.startsWith("CACHE-CONTROL:")) {
                                ssdpResponse.a(string2.substring("CACHE-CONTROL:".length()).trim());
                                continue;
                            }
                            if (string4.startsWith("DATE:")) {
                                ssdpResponse.b(string2.substring("DATE:".length()).trim());
                                continue;
                            }
                            if (string4.startsWith("LOCATION:")) {
                                ssdpResponse.c(string2.substring("LOCATION:".length()).trim());
                                continue;
                            }
                            if (string4.startsWith("SERVER:")) {
                                ssdpResponse.d(string2.substring("SERVER:".length()).trim());
                                continue;
                            }
                            if (string4.startsWith("ST:")) {
                                ssdpResponse.e(string2.substring("ST:".length()).trim());
                                continue;
                            }
                            if (string4.startsWith("USN:")) {
                                ssdpResponse.f(string2.substring("USN:".length()).trim());
                                continue;
                            }
                            if (!string4.startsWith("BOOTID.UPNP.ORG:")) continue;
                            ssdpResponse.g(string2.substring("BOOTID.UPNP.ORG:".length()).trim());
                        }
                        bufferedReader.close();
                        if (!ssdpResponse.isValidCastDevice() || this.g == null) continue;
                        this.h.post(new Runnable(){

                            @Override
                            public void run() {
                                SsdpScanner.this.g.onSsdpResponse(ssdpResponse);
                            }
                        });
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this.r.d(iOException, "Receive thread got an exception; mShouldStop=" + this.i, new Object[0]);
                if (this.i) break block13;
                this.g();
            }
        }
    }

    private void g() {
        if (!this.l.getAndSet(true) && this.g != null) {
            this.h.post(new Runnable(){

                @Override
                public void run() {
                    SsdpScanner.this.h();
                }
            });
        }
    }

    private void h() {
        if (!this.q) {
            this.r.d("reportNetworkError; errorState now true", new Object[0]);
            this.q = true;
            if (this.g != null) {
                this.g.onNetworkError();
            }
        }
    }

    private void i() {
        if (this.n != null) {
            return;
        }
        this.n = new a();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.a.registerReceiver((BroadcastReceiver)this.n, intentFilter);
    }

    private void j() {
        if (this.n == null) {
            return;
        }
        try {
            this.a.unregisterReceiver((BroadcastReceiver)this.n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.n = null;
    }

    private class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = SsdpScanner.this.m.getActiveNetworkInfo();
            boolean bl = networkInfo != null && networkInfo.isConnected();
            SsdpScanner.this.r.d("connectivity state changed; connected? %b, errorState? %b", bl, SsdpScanner.this.q);
            if (!bl) {
                SsdpScanner.this.p = null;
            }
            if (bl && SsdpScanner.this.q) {
                SsdpScanner.this.r.d("re-established connectivity; restarting scan", new Object[0]);
                SsdpScanner.this.a();
            } else if (!bl && SsdpScanner.this.b != null) {
                SsdpScanner.this.r.d("lost connectivity while scanning; stopping scan", new Object[0]);
                SsdpScanner.this.c();
                SsdpScanner.this.g();
            }
        }
    }

    public static interface Listener {
        public void onNetworkError();

        public void onSsdpResponse(SsdpResponse var1);

        public void onResultsInvalidated();
    }

    public static final class SsdpResponse {
        private String a;
        private String b;
        private String c;
        private String d;
        private String e;
        private String f;
        private String g;

        private void a(String string2) {
            this.a = string2;
        }

        public String getCacheControl() {
            return this.a;
        }

        private void b(String string2) {
            this.b = string2;
        }

        public String getDate() {
            return this.b;
        }

        private void c(String string2) {
            this.c = string2;
        }

        public String getLocation() {
            return this.c;
        }

        private void d(String string2) {
            this.d = string2;
        }

        public String getServer() {
            return this.d;
        }

        private void e(String string2) {
            this.e = string2;
        }

        public String getSearchTarget() {
            return this.e;
        }

        private void f(String string2) {
            this.f = string2;
        }

        public String getUsn() {
            return this.f;
        }

        private void g(String string2) {
            this.g = string2;
        }

        public String getBootId() {
            return this.g;
        }

        public boolean isValidCastDevice() {
            return !TextUtils.isEmpty((CharSequence)this.c) && !TextUtils.isEmpty((CharSequence)this.f);
        }
    }
}

