/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.google.cast.Logger;
import com.google.cast.d;
import com.google.cast.e;
import com.google.cast.p;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class WebSocket {
    private static final byte[] a = new byte[]{13, 10, 13, 10};
    private Uri b;
    private int c;
    private String d;
    private String e;
    private Listener f;
    private SocketChannel g;
    private int h;
    private int i;
    private d j;
    private d k;
    private p l;
    private Charset m;
    private CharsetDecoder n;
    private boolean o;
    private static Logger p;
    private int q;
    private byte r;
    private boolean s;
    private boolean t;
    private boolean u;
    private byte[] v;
    private String w;
    private int x;
    private long y;
    private long z;

    public WebSocket(String origin, String protocol, int bufferSize) throws IllegalArgumentException {
        if (bufferSize < 4096) {
            throw new IllegalArgumentException("bufferSize < MIN_BUFFER_SIZE");
        }
        this.q = 0;
        this.d = origin;
        this.e = protocol;
        this.l = com.google.cast.p.a();
        this.h = bufferSize;
        this.i = this.h - 14;
        this.m = this.l.f();
        this.n = this.m.newDecoder();
        this.z = 5000L;
        p = new Logger("WebSocket");
    }

    public void a(Listener listener) {
        this.f = listener;
    }

    public void a(Uri uri) throws IOException {
        this.a(uri, 5000);
    }

    public synchronized void a(Uri uri, int n2) throws IOException {
        InetSocketAddress inetSocketAddress;
        if (this.g != null) {
            throw new IllegalStateException("already connected");
        }
        if (!uri.getScheme().equals("ws")) {
            throw new IllegalArgumentException("scheme must be ws");
        }
        this.z = n2 >= 1000 ? (long)n2 : 1000L;
        this.y = System.currentTimeMillis();
        this.b = uri;
        this.g = SocketChannel.open();
        this.g.configureBlocking(false);
        boolean bl = false;
        this.c = this.b.getPort();
        if (this.c == -1) {
            this.c = 80;
        }
        this.q = 1;
        InetAddress inetAddress = null;
        if (Build.VERSION.SDK_INT <= 13) {
            try {
                inetAddress = WebSocket.b(this.b.getHost());
            }
            catch (Exception exception) {
                p.w("Unable to create InetAddress object.", new Object[0]);
                inetAddress = null;
            }
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = inetAddress != null ? new InetSocketAddress(inetAddress, this.c) : new InetSocketAddress(this.b.getHost(), this.c);
        if (this.g.connect(inetSocketAddress)) {
            bl = true;
        }
        this.j = new d(this.h);
        this.k = new d(this.h);
        this.r = (byte)-1;
        this.u = false;
        this.t = false;
        this.s = false;
        this.v = null;
        this.x = 0;
        this.l.b();
        this.l.a(this);
        if (bl) {
            this.j();
        }
    }

    public synchronized void a() throws IOException {
        if (this.q == 3) {
            this.q = 4;
            if (!this.s) {
                this.a((short)1000);
            }
        } else {
            p.d("force-closing socket in disconnect()", new Object[0]);
            this.b(0);
        }
        this.l.c();
    }

    public synchronized void a(int n2) {
        this.b(n2);
        this.l.c();
    }

    public synchronized boolean b() {
        return this.q == 3;
    }

    public synchronized boolean c() {
        return this.q == 1 || this.q == 2;
    }

    public synchronized void a(String string2) throws IOException {
        this.n();
        if (string2 == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        byte[] byArray = string2.getBytes(this.m);
        this.a((byte)1, byArray, true);
        this.l.c();
    }

    public synchronized int d() {
        return this.k.g();
    }

    public synchronized int e() {
        return this.k.h();
    }

    private static InetAddress b(String string2) throws ClassNotFoundException, IOException {
        InetAddress inetAddress = InetAddress.getByName(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(inetAddress);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[byArray.length + 2];
        int n2 = byArray.length - 2;
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2++] = 116;
        byArray2[n2++] = 0;
        byArray2[n2++] = 0;
        byArray2[n2] = 120;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Inet4Address inet4Address = (Inet4Address)objectInputStream.readObject();
        objectInputStream.close();
        return inet4Address;
    }

    private void j() throws IOException {
        this.q = 2;
        this.w = this.l.d();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("GET %s HTTP/1.1\r\nHost: %s\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: %s\r\nOrigin: %s\r\nSec-WebSocket-Version: 13\r\n", this.b.getPath() + "?" + this.b.getQuery(), this.b.getHost() + ":" + this.c, this.w, this.d));
        if (!TextUtils.isEmpty((CharSequence)this.e)) {
            stringBuilder.append("Sec-WebSocket-Protocol").append(": ").append(this.e).append("\r\n");
        }
        stringBuilder.append("\r\n");
        String string2 = stringBuilder.toString();
        p.d("sending handshake:\n%s", string2);
        this.k.a(string2, null, this.m);
    }

    private boolean k() throws IOException {
        int n2 = this.j.a(a);
        if (n2 < 0) {
            return true;
        }
        String string2 = null;
        try {
            string2 = this.j.a(n2, null, this.n);
            if (string2 == null) {
                throw new IOException("Invalid opening handshake reply");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new e(unsupportedEncodingException.toString());
        }
        p.d("handshake reply:\n%s", string2);
        String[] stringArray = string2.split("\r\n");
        if (stringArray.length == 0) {
            throw new IOException("Invalid opening handshake reply");
        }
        if (!stringArray[0].toUpperCase().matches("^HTTP\\/[0-9\\.]+\\s+101\\s+.*$")) {
            p.w("Unexpected HTTP status: %s", stringArray[0]);
            return false;
        }
        boolean bl = false;
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2].toLowerCase();
            if (string3.startsWith("sec-websocket-accept: ")) {
                String string4;
                String string5 = stringArray[i2].substring("sec-websocket-accept: ".length()).trim();
                if (string5.equals(string4 = WebSocket.a(this.w, this.m))) {
                    bl = true;
                    continue;
                }
                p.w("Expected accept value <%s> but got <%s>", string4, string5);
                continue;
            }
            if (!string3.startsWith("sec-websocket-protocol: ")) continue;
            this.e = stringArray[i2].substring("sec-websocket-protocol: ".length()).trim();
        }
        if (bl) {
            p.d("Switching to STATE_CONNECTED", new Object[0]);
            this.q = 3;
            if (this.f != null) {
                this.f.onConnected();
            }
        }
        return bl;
    }

    private void l() throws IOException {
        this.a((byte)10, this.v, true);
        this.v = null;
    }

    private void a(short s) throws IOException {
        p.d("writing closing handshake", new Object[0]);
        byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        this.a((byte)8, byArray, true);
        this.s = true;
    }

    private boolean m() throws IOException {
        boolean bl = false;
        block7: while (!this.j.i()) {
            this.j.e();
            Byte by = this.j.a();
            if (by == null) {
                bl = true;
                break;
            }
            byte by2 = (byte)(by & 0xF);
            boolean bl2 = (by & 0xFFFFFF80) != 0;
            by = this.j.a();
            if (by == null) {
                bl = true;
                break;
            }
            boolean bl3 = (by & 0xFFFFFF80) != 0;
            long l2 = by & 0x7F;
            if (l2 == 126L) {
                Integer n2 = this.j.b();
                if (n2 == null) {
                    bl = true;
                    break;
                }
                l2 = n2.intValue();
            } else if (l2 == 127L) {
                Long l3 = this.j.c();
                if (l3 == null) {
                    bl = true;
                    break;
                }
                l2 = l3;
            }
            if (l2 > (long)this.i) {
                throw new IOException("message too large: " + l2 + " bytes");
            }
            int n3 = (int)l2;
            byte[] byArray = null;
            if (bl3 && !this.j.a(byArray = new byte[4], null)) {
                bl = true;
                break;
            }
            if (this.j.h() < n3) {
                bl = true;
                break;
            }
            switch (by2) {
                case 0: {
                    Object object;
                    if (this.r == 1) {
                        object = this.j.a(n3, byArray, this.n);
                        if (object == null) {
                            bl = true;
                            break block7;
                        }
                        if (this.f == null) continue block7;
                        this.f.onContinuationMessageReceived((String)object, bl2);
                        break;
                    }
                    if (this.r == 2) {
                        object = new byte[n3];
                        if (!this.j.a((byte[])object, byArray)) {
                            bl = true;
                            break block7;
                        }
                        if (this.f == null) continue block7;
                        this.f.onContinuationMessageReceived((byte[])object, bl2);
                        break;
                    }
                    throw new IOException("Unexpected continuation frame received");
                }
                case 1: {
                    p.d("reading a text message of length %d, mask %h", n3, byArray);
                    Object object = this.j.a(n3, byArray, this.n);
                    if (object == null) {
                        bl = true;
                        break block7;
                    }
                    if (this.f != null) {
                        this.f.onMessageReceived((String)object, bl2);
                    }
                    this.r = by2;
                    break;
                }
                case 2: {
                    Object object = new byte[n3];
                    if (!this.j.a((byte[])object, byArray)) {
                        bl = true;
                        break block7;
                    }
                    if (this.f != null) {
                        this.f.onMessageReceived((byte[])object, bl2);
                    }
                    this.r = by2;
                    break;
                }
                case 8: {
                    Object object;
                    this.q = 4;
                    if (n3 >= 2) {
                        object = this.j.b();
                        if (object == null) {
                            bl = true;
                            break block7;
                        }
                        this.x = object.intValue();
                        n3 -= 2;
                    }
                    if (n3 > 0 && !this.j.a(n3)) {
                        bl = true;
                        break block7;
                    }
                    this.t = true;
                    if (!this.s) continue block7;
                    return false;
                }
                case 9: {
                    this.v = new byte[n3];
                    if (!this.j.a(this.v, byArray)) {
                        bl = true;
                        break block7;
                    }
                    this.u = true;
                    this.r = (byte)-1;
                    break;
                }
                default: {
                    if (!this.j.a(n3)) {
                        bl = true;
                        break block7;
                    }
                    this.r = (byte)-1;
                }
            }
        }
        if (bl) {
            this.j.f();
        }
        return true;
    }

    private void a(byte by, byte[] byArray, boolean bl) throws IOException {
        int n2;
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (this.k.g() < n2 + 14) {
            throw new IOException("no room in buffer");
        }
        byte by2 = by;
        if (bl) {
            by2 = (byte)(by2 | 0xFFFFFF80);
        }
        this.k.a(by2);
        if (byArray == null) {
            this.k.a((byte)-128);
        } else if (byArray.length < 126) {
            this.k.a((byte)(byArray.length | 0xFFFFFF80));
        } else if (byArray.length < 65536) {
            this.k.a((byte)-2);
            this.k.b(byArray.length);
        } else {
            this.k.a((byte)-1);
            this.k.a((long)byArray.length);
        }
        byte[] byArray2 = this.l.e();
        this.k.b(byArray2, null);
        if (byArray != null) {
            this.k.b(byArray, byArray2);
        }
    }

    private void b(int n2) {
        p.d("doTeardown with error=%d", n2);
        if (this.g != null) {
            try {
                this.g.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.g = null;
        }
        this.b = null;
        this.j = null;
        this.k = null;
        boolean bl = this.q == 1 || this.q == 2;
        this.q = 0;
        this.o = true;
        if (this.f != null) {
            if (bl) {
                this.f.onConnectionFailed(n2);
            } else {
                this.f.onDisconnected(n2, this.x);
            }
        }
    }

    private void n() throws IllegalStateException {
        if (this.q != 3) {
            throw new IllegalStateException("not connected; state=" + this.q);
        }
    }

    static String a(String string2, Charset charset) {
        try {
            String string3 = string2 + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string3.getBytes(charset));
            byte[] byArray = messageDigest.digest();
            return Base64.encodeToString((byte[])byArray, (int)0, (int)byArray.length, (int)2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            p.e(noSuchAlgorithmException, "unexpected Base64 encoding error", new Object[0]);
            return null;
        }
    }

    synchronized boolean a(SelectionKey selectionKey, long l2) {
        if (this.c() && l2 - this.y > this.z) {
            this.b(-3);
            return false;
        }
        if (this.o) {
            p.w("Socket is no longer connected", new Object[0]);
            this.o = false;
            return false;
        }
        int n2 = 0;
        if (this.q == 1 && !this.g.isConnected()) {
            n2 |= 8;
        } else if (this.q != 0 && this.q != 1) {
            if (!this.j.j()) {
                n2 |= 1;
            }
            if (!this.k.i()) {
                n2 |= 4;
            }
        }
        selectionKey.interestOps(n2);
        return true;
    }

    synchronized boolean f() {
        p.d("connectable; starting handshake", new Object[0]);
        try {
            this.g.finishConnect();
            this.j();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    synchronized boolean g() {
        p.d("readable", new Object[0]);
        try {
            this.j.b(this.g);
            if (this.q == 2) {
                if (!this.k()) {
                    p.w("problem reading opening handshake reply", new Object[0]);
                    this.b(-1);
                    return false;
                }
            } else if (!this.m()) {
                p.w("readMessages() returned false", new Object[0]);
                this.b(this.q == 4 ? -2 : -1);
                return false;
            }
            return true;
        }
        catch (ClosedChannelException closedChannelException) {
            p.d(closedChannelException, "ClosedChannelException when state was %d", this.q);
            this.b(this.q == 4 ? 0 : -1);
            return false;
        }
        catch (IOException iOException) {
            this.b(this.q == 4 ? -2 : -1);
            return false;
        }
    }

    synchronized boolean h() {
        p.d("writable", new Object[0]);
        try {
            this.k.a(this.g);
            if (this.k.i()) {
                if (this.q == 4) {
                    if (!this.s) {
                        this.a((short)1000);
                    } else if (this.t) {
                        p.d("closing handshake complete", new Object[0]);
                        this.b(0);
                        return false;
                    }
                } else if (this.q == 3 && this.u) {
                    this.l();
                    this.u = false;
                }
            }
            return true;
        }
        catch (ClosedChannelException closedChannelException) {
            p.d(closedChannelException, "ClosedChannelException when state was %d", this.q);
            this.b(this.q == 4 ? 0 : -1);
            return false;
        }
        catch (IOException iOException) {
            this.b(this.q == 4 ? -2 : -1);
            return false;
        }
    }

    synchronized SocketChannel i() {
        return this.g;
    }

    public static interface Listener {
        public void onConnected();

        public void onConnectionFailed(int var1);

        public void onMessageReceived(String var1, boolean var2);

        public void onMessageReceived(byte[] var1, boolean var2);

        public void onContinuationMessageReceived(String var1, boolean var2);

        public void onContinuationMessageReceived(byte[] var1, boolean var2);

        public void onDisconnected(int var1, int var2);
    }
}

